/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.activity.BackEventCompat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.animation.PathInterpolatorCompat;
import com.google.android.material.R;
import com.google.android.material.motion.MotionUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class MaterialBackAnimationHelper<V extends View> {
    private static final String TAG = "MaterialBackHelper";
    private static final int HIDE_DURATION_MAX_DEFAULT = 300;
    private static final int HIDE_DURATION_MIN_DEFAULT = 150;
    private static final int CANCEL_DURATION_DEFAULT = 100;
    @NonNull
    private final TimeInterpolator progressInterpolator;
    @NonNull
    protected final V view;
    protected final int hideDurationMax;
    protected final int hideDurationMin;
    protected final int cancelDuration;
    @Nullable
    private BackEventCompat backEvent;

    public MaterialBackAnimationHelper(@NonNull V view) {
        this.view = view;
        Context context = view.getContext();
        this.progressInterpolator = MotionUtils.resolveThemeInterpolator(context, R.attr.motionEasingStandardDecelerateInterpolator, (TimeInterpolator)PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        this.hideDurationMax = MotionUtils.resolveThemeDuration(context, R.attr.motionDurationMedium2, 300);
        this.hideDurationMin = MotionUtils.resolveThemeDuration(context, R.attr.motionDurationShort3, 150);
        this.cancelDuration = MotionUtils.resolveThemeDuration(context, R.attr.motionDurationShort2, 100);
    }

    protected float interpolateProgress(float progress) {
        return this.progressInterpolator.getInterpolation(progress);
    }

    protected void onStartBackProgress(@NonNull BackEventCompat backEvent) {
        this.backEvent = backEvent;
    }

    @Nullable
    protected BackEventCompat onUpdateBackProgress(@NonNull BackEventCompat backEvent) {
        if (this.backEvent == null) {
            Log.w((String)TAG, (String)"Must call startBackProgress() before updateBackProgress()");
        }
        BackEventCompat finalBackEvent = this.backEvent;
        this.backEvent = backEvent;
        return finalBackEvent;
    }

    @Nullable
    public BackEventCompat onHandleBackInvoked() {
        BackEventCompat finalBackEvent = this.backEvent;
        this.backEvent = null;
        return finalBackEvent;
    }

    @Nullable
    protected BackEventCompat onCancelBackProgress() {
        if (this.backEvent == null) {
            Log.w((String)TAG, (String)"Must call startBackProgress() and updateBackProgress() before cancelBackProgress()");
        }
        BackEventCompat finalBackEvent = this.backEvent;
        this.backEvent = null;
        return finalBackEvent;
    }
}

