/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.BackEventCompat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MaterialBackAnimationHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaterialBottomContainerBackHelper
extends MaterialBackAnimationHelper<View> {
    private final float maxScaleXDistance;
    private final float maxScaleYDistance;

    public MaterialBottomContainerBackHelper(@NonNull View view) {
        super(view);
        Resources resources = view.getResources();
        this.maxScaleXDistance = resources.getDimension(R.dimen.m3_back_progress_bottom_container_max_scale_x_distance);
        this.maxScaleYDistance = resources.getDimension(R.dimen.m3_back_progress_bottom_container_max_scale_y_distance);
    }

    public void startBackProgress(@NonNull BackEventCompat backEvent) {
        super.onStartBackProgress(backEvent);
    }

    public void updateBackProgress(@NonNull BackEventCompat backEvent) {
        if (super.onUpdateBackProgress(backEvent) == null) {
            return;
        }
        this.updateBackProgress(backEvent.getProgress());
    }

    @VisibleForTesting
    public void updateBackProgress(float progress) {
        progress = this.interpolateProgress(progress);
        float width = this.view.getWidth();
        float height = this.view.getHeight();
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        float maxScaleXDelta = this.maxScaleXDistance / width;
        float maxScaleYDelta = this.maxScaleYDistance / height;
        float scaleXDelta = AnimationUtils.lerp(0.0f, maxScaleXDelta, progress);
        float scaleYDelta = AnimationUtils.lerp(0.0f, maxScaleYDelta, progress);
        float scaleX = 1.0f - scaleXDelta;
        float scaleY = 1.0f - scaleYDelta;
        this.view.setScaleX(scaleX);
        this.view.setPivotY(height);
        this.view.setScaleY(scaleY);
        if (this.view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                childView.setPivotY((float)(-childView.getTop()));
                childView.setScaleY(scaleY != 0.0f ? scaleX / scaleY : 1.0f);
            }
        }
    }

    public void finishBackProgressPersistent(@NonNull BackEventCompat backEvent, @Nullable Animator.AnimatorListener animatorListener) {
        Animator animator2 = this.createResetScaleAnimator();
        animator2.setDuration((long)AnimationUtils.lerp(this.hideDurationMax, this.hideDurationMin, backEvent.getProgress()));
        if (animatorListener != null) {
            animator2.addListener(animatorListener);
        }
        animator2.start();
    }

    public void finishBackProgressNotPersistent(@NonNull BackEventCompat backEvent, @Nullable Animator.AnimatorListener animatorListener) {
        float scaledHeight = (float)this.view.getHeight() * this.view.getScaleY();
        ObjectAnimator finishAnimator = ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_Y, (float[])new float[]{scaledHeight});
        finishAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        finishAnimator.setDuration((long)AnimationUtils.lerp(this.hideDurationMax, this.hideDurationMin, backEvent.getProgress()));
        finishAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaterialBottomContainerBackHelper.this.view.setTranslationY(0.0f);
                MaterialBottomContainerBackHelper.this.updateBackProgress(0.0f);
            }
        });
        if (animatorListener != null) {
            finishAnimator.addListener(animatorListener);
        }
        finishAnimator.start();
    }

    public void cancelBackProgress() {
        if (super.onCancelBackProgress() == null) {
            return;
        }
        Animator animator2 = this.createResetScaleAnimator();
        animator2.setDuration((long)this.cancelDuration);
        animator2.start();
    }

    private Animator createResetScaleAnimator() {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_X, (float[])new float[]{1.0f}), ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_Y, (float[])new float[]{1.0f})});
        if (this.view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)childView, (Property)View.SCALE_Y, (float[])new float[]{1.0f})});
            }
        }
        animatorSet.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        return animatorSet;
    }
}

