/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.navigation.NavigationBarMenu;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigation.NavigationBarPresenter;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class NavigationBarView
extends FrameLayout {
    public static final int LABEL_VISIBILITY_AUTO = -1;
    public static final int LABEL_VISIBILITY_SELECTED = 0;
    public static final int LABEL_VISIBILITY_LABELED = 1;
    public static final int LABEL_VISIBILITY_UNLABELED = 2;
    private static final int MENU_PRESENTER_ID = 1;
    @NonNull
    private final NavigationBarMenu menu;
    @NonNull
    private final NavigationBarMenuView menuView;
    @NonNull
    private final NavigationBarPresenter presenter = new NavigationBarPresenter();
    private MenuInflater menuInflater;
    private OnItemSelectedListener selectedListener;
    private OnItemReselectedListener reselectedListener;

    public NavigationBarView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, defStyleRes), attrs, defStyleAttr);
        context = this.getContext();
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.NavigationBarView, defStyleAttr, defStyleRes, R.styleable.NavigationBarView_itemTextAppearanceInactive, R.styleable.NavigationBarView_itemTextAppearanceActive);
        this.menu = new NavigationBarMenu(context, ((Object)((Object)this)).getClass(), this.getMaxItemCount());
        this.menuView = this.createNavigationBarMenuView(context);
        this.presenter.setMenuView(this.menuView);
        this.presenter.setId(1);
        this.menuView.setPresenter(this.presenter);
        this.menu.addMenuPresenter(this.presenter);
        this.presenter.initForMenu(this.getContext(), this.menu);
        if (attributes.hasValue(R.styleable.NavigationBarView_itemIconTint)) {
            this.menuView.setIconTintList(attributes.getColorStateList(R.styleable.NavigationBarView_itemIconTint));
        } else {
            this.menuView.setIconTintList(this.menuView.createDefaultColorStateList(16842808));
        }
        this.setItemIconSize(attributes.getDimensionPixelSize(R.styleable.NavigationBarView_itemIconSize, this.getResources().getDimensionPixelSize(R.dimen.mtrl_navigation_bar_item_default_icon_size)));
        if (attributes.hasValue(R.styleable.NavigationBarView_itemTextAppearanceInactive)) {
            this.setItemTextAppearanceInactive(attributes.getResourceId(R.styleable.NavigationBarView_itemTextAppearanceInactive, 0));
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_itemTextAppearanceActive)) {
            this.setItemTextAppearanceActive(attributes.getResourceId(R.styleable.NavigationBarView_itemTextAppearanceActive, 0));
        }
        boolean isBold = attributes.getBoolean(R.styleable.NavigationBarView_itemTextAppearanceActiveBoldEnabled, true);
        this.setItemTextAppearanceActiveBoldEnabled(isBold);
        if (attributes.hasValue(R.styleable.NavigationBarView_itemTextColor)) {
            this.setItemTextColor(attributes.getColorStateList(R.styleable.NavigationBarView_itemTextColor));
        }
        Drawable background = this.getBackground();
        ColorStateList backgroundColorStateList = DrawableUtils.getColorStateListOrNull(background);
        if (background == null || backgroundColorStateList != null) {
            ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, defStyleRes).build();
            MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
            if (backgroundColorStateList != null) {
                materialShapeDrawable.setFillColor(backgroundColorStateList);
            }
            materialShapeDrawable.initializeElevationOverlay(context);
            ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_itemPaddingTop)) {
            this.setItemPaddingTop(attributes.getDimensionPixelSize(R.styleable.NavigationBarView_itemPaddingTop, 0));
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_itemPaddingBottom)) {
            this.setItemPaddingBottom(attributes.getDimensionPixelSize(R.styleable.NavigationBarView_itemPaddingBottom, 0));
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_activeIndicatorLabelPadding)) {
            this.setActiveIndicatorLabelPadding(attributes.getDimensionPixelSize(R.styleable.NavigationBarView_activeIndicatorLabelPadding, 0));
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_elevation)) {
            this.setElevation(attributes.getDimensionPixelSize(R.styleable.NavigationBarView_elevation, 0));
        }
        ColorStateList backgroundTint = MaterialResources.getColorStateList(context, attributes, R.styleable.NavigationBarView_backgroundTint);
        DrawableCompat.setTintList((Drawable)this.getBackground().mutate(), (ColorStateList)backgroundTint);
        this.setLabelVisibilityMode(attributes.getInteger(R.styleable.NavigationBarView_labelVisibilityMode, -1));
        int itemBackground = attributes.getResourceId(R.styleable.NavigationBarView_itemBackground, 0);
        if (itemBackground != 0) {
            this.menuView.setItemBackgroundRes(itemBackground);
        } else {
            this.setItemRippleColor(MaterialResources.getColorStateList(context, attributes, R.styleable.NavigationBarView_itemRippleColor));
        }
        int activeIndicatorStyleResId = attributes.getResourceId(R.styleable.NavigationBarView_itemActiveIndicatorStyle, 0);
        if (activeIndicatorStyleResId != 0) {
            this.setItemActiveIndicatorEnabled(true);
            TypedArray activeIndicatorAttributes = context.obtainStyledAttributes(activeIndicatorStyleResId, R.styleable.NavigationBarActiveIndicator);
            int itemActiveIndicatorWidth = activeIndicatorAttributes.getDimensionPixelSize(R.styleable.NavigationBarActiveIndicator_android_width, 0);
            this.setItemActiveIndicatorWidth(itemActiveIndicatorWidth);
            int itemActiveIndicatorHeight = activeIndicatorAttributes.getDimensionPixelSize(R.styleable.NavigationBarActiveIndicator_android_height, 0);
            this.setItemActiveIndicatorHeight(itemActiveIndicatorHeight);
            int itemActiveIndicatorMarginHorizontal = activeIndicatorAttributes.getDimensionPixelOffset(R.styleable.NavigationBarActiveIndicator_marginHorizontal, 0);
            this.setItemActiveIndicatorMarginHorizontal(itemActiveIndicatorMarginHorizontal);
            ColorStateList itemActiveIndicatorColor = MaterialResources.getColorStateList(context, activeIndicatorAttributes, R.styleable.NavigationBarActiveIndicator_android_color);
            this.setItemActiveIndicatorColor(itemActiveIndicatorColor);
            int shapeAppearanceResId = activeIndicatorAttributes.getResourceId(R.styleable.NavigationBarActiveIndicator_shapeAppearance, 0);
            ShapeAppearanceModel itemActiveIndicatorShapeAppearance = ShapeAppearanceModel.builder(context, shapeAppearanceResId, 0).build();
            this.setItemActiveIndicatorShapeAppearance(itemActiveIndicatorShapeAppearance);
            activeIndicatorAttributes.recycle();
        }
        if (attributes.hasValue(R.styleable.NavigationBarView_menu)) {
            this.inflateMenu(attributes.getResourceId(R.styleable.NavigationBarView_menu, 0));
        }
        attributes.recycle();
        this.addView((View)this.menuView);
        this.menu.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, @NonNull MenuItem item) {
                if (NavigationBarView.this.reselectedListener != null && item.getItemId() == NavigationBarView.this.getSelectedItemId()) {
                    NavigationBarView.this.reselectedListener.onNavigationItemReselected(item);
                    return true;
                }
                return NavigationBarView.this.selectedListener != null && !NavigationBarView.this.selectedListener.onNavigationItemSelected(item);
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    public void setElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.setElevation(elevation);
        }
        MaterialShapeUtils.setElevation((View)this, elevation);
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener listener) {
        this.selectedListener = listener;
    }

    public void setOnItemReselectedListener(@Nullable OnItemReselectedListener listener) {
        this.reselectedListener = listener;
    }

    @NonNull
    public Menu getMenu() {
        return this.menu;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public MenuView getMenuView() {
        return this.menuView;
    }

    public void inflateMenu(int resId) {
        this.presenter.setUpdateSuspended(true);
        this.getMenuInflater().inflate(resId, (Menu)this.menu);
        this.presenter.setUpdateSuspended(false);
        this.presenter.updateMenuView(true);
    }

    @Nullable
    public ColorStateList getItemIconTintList() {
        return this.menuView.getIconTintList();
    }

    public void setItemIconTintList(@Nullable ColorStateList tint) {
        this.menuView.setIconTintList(tint);
    }

    public void setItemIconSize(@Dimension int iconSize) {
        this.menuView.setItemIconSize(iconSize);
    }

    public void setItemIconSizeRes(@DimenRes int iconSizeRes) {
        this.setItemIconSize(this.getResources().getDimensionPixelSize(iconSizeRes));
    }

    @Dimension
    public int getItemIconSize() {
        return this.menuView.getItemIconSize();
    }

    @Nullable
    public ColorStateList getItemTextColor() {
        return this.menuView.getItemTextColor();
    }

    public void setItemTextColor(@Nullable ColorStateList textColor) {
        this.menuView.setItemTextColor(textColor);
    }

    @Deprecated
    @DrawableRes
    public int getItemBackgroundResource() {
        return this.menuView.getItemBackgroundRes();
    }

    public void setItemBackgroundResource(@DrawableRes int resId) {
        this.menuView.setItemBackgroundRes(resId);
    }

    @Nullable
    public Drawable getItemBackground() {
        return this.menuView.getItemBackground();
    }

    public void setItemBackground(@Nullable Drawable background) {
        this.menuView.setItemBackground(background);
    }

    @Nullable
    public ColorStateList getItemRippleColor() {
        return this.menuView.getItemRippleColor();
    }

    public void setItemRippleColor(@Nullable ColorStateList itemRippleColor) {
        this.menuView.setItemRippleColor(itemRippleColor);
    }

    @Px
    public int getItemPaddingTop() {
        return this.menuView.getItemPaddingTop();
    }

    public void setItemPaddingTop(@Px int paddingTop) {
        this.menuView.setItemPaddingTop(paddingTop);
    }

    @Px
    public int getItemPaddingBottom() {
        return this.menuView.getItemPaddingBottom();
    }

    public void setItemPaddingBottom(@Px int paddingBottom) {
        this.menuView.setItemPaddingBottom(paddingBottom);
    }

    public void setActiveIndicatorLabelPadding(@Px int activeIndicatorLabelPadding) {
        this.menuView.setActiveIndicatorLabelPadding(activeIndicatorLabelPadding);
    }

    @Px
    public int getActiveIndicatorLabelPadding() {
        return this.menuView.getActiveIndicatorLabelPadding();
    }

    public boolean isItemActiveIndicatorEnabled() {
        return this.menuView.getItemActiveIndicatorEnabled();
    }

    public void setItemActiveIndicatorEnabled(boolean enabled) {
        this.menuView.setItemActiveIndicatorEnabled(enabled);
    }

    @Px
    public int getItemActiveIndicatorWidth() {
        return this.menuView.getItemActiveIndicatorWidth();
    }

    public void setItemActiveIndicatorWidth(@Px int width) {
        this.menuView.setItemActiveIndicatorWidth(width);
    }

    @Px
    public int getItemActiveIndicatorHeight() {
        return this.menuView.getItemActiveIndicatorHeight();
    }

    public void setItemActiveIndicatorHeight(@Px int height) {
        this.menuView.setItemActiveIndicatorHeight(height);
    }

    @Px
    public int getItemActiveIndicatorMarginHorizontal() {
        return this.menuView.getItemActiveIndicatorMarginHorizontal();
    }

    public void setItemActiveIndicatorMarginHorizontal(@Px int horizontalMargin) {
        this.menuView.setItemActiveIndicatorMarginHorizontal(horizontalMargin);
    }

    @Nullable
    public ShapeAppearanceModel getItemActiveIndicatorShapeAppearance() {
        return this.menuView.getItemActiveIndicatorShapeAppearance();
    }

    public void setItemActiveIndicatorShapeAppearance(@Nullable ShapeAppearanceModel shapeAppearance) {
        this.menuView.setItemActiveIndicatorShapeAppearance(shapeAppearance);
    }

    @Nullable
    public ColorStateList getItemActiveIndicatorColor() {
        return this.menuView.getItemActiveIndicatorColor();
    }

    public void setItemActiveIndicatorColor(@Nullable ColorStateList csl) {
        this.menuView.setItemActiveIndicatorColor(csl);
    }

    @IdRes
    public int getSelectedItemId() {
        return this.menuView.getSelectedItemId();
    }

    public void setSelectedItemId(@IdRes int itemId) {
        MenuItem item = this.menu.findItem(itemId);
        if (item != null && !this.menu.performItemAction(item, this.presenter, 0)) {
            item.setChecked(true);
        }
    }

    public void setLabelVisibilityMode(int labelVisibilityMode) {
        if (this.menuView.getLabelVisibilityMode() != labelVisibilityMode) {
            this.menuView.setLabelVisibilityMode(labelVisibilityMode);
            this.presenter.updateMenuView(false);
        }
    }

    public int getLabelVisibilityMode() {
        return this.menuView.getLabelVisibilityMode();
    }

    public void setItemTextAppearanceInactive(@StyleRes int textAppearanceRes) {
        this.menuView.setItemTextAppearanceInactive(textAppearanceRes);
    }

    @StyleRes
    public int getItemTextAppearanceInactive() {
        return this.menuView.getItemTextAppearanceInactive();
    }

    public void setItemTextAppearanceActive(@StyleRes int textAppearanceRes) {
        this.menuView.setItemTextAppearanceActive(textAppearanceRes);
    }

    public void setItemTextAppearanceActiveBoldEnabled(boolean isBold) {
        this.menuView.setItemTextAppearanceActiveBoldEnabled(isBold);
    }

    @StyleRes
    public int getItemTextAppearanceActive() {
        return this.menuView.getItemTextAppearanceActive();
    }

    public void setItemOnTouchListener(int menuItemId, @Nullable View.OnTouchListener onTouchListener) {
        this.menuView.setItemOnTouchListener(menuItemId, onTouchListener);
    }

    @Nullable
    public BadgeDrawable getBadge(int menuItemId) {
        return this.menuView.getBadge(menuItemId);
    }

    @NonNull
    public BadgeDrawable getOrCreateBadge(int menuItemId) {
        return this.menuView.getOrCreateBadge(menuItemId);
    }

    public void removeBadge(int menuItemId) {
        this.menuView.removeBadge(menuItemId);
    }

    public abstract int getMaxItemCount();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected abstract NavigationBarMenuView createNavigationBarMenuView(@NonNull Context var1);

    private MenuInflater getMenuInflater() {
        if (this.menuInflater == null) {
            this.menuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.menuInflater;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public NavigationBarPresenter getPresenter() {
        return this.presenter;
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.menuPresenterState = new Bundle();
        this.menu.savePresenterStates(savedState.menuPresenterState);
        return savedState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.menu.restorePresenterStates(savedState.menuPresenterState);
    }

    static class SavedState
    extends AbsSavedState {
        @Nullable
        Bundle menuPresenterState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.readFromParcel(source, loader);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeBundle(this.menuPresenterState);
        }

        private void readFromParcel(@NonNull Parcel in, ClassLoader loader) {
            this.menuPresenterState = in.readBundle(loader);
        }
    }

    public static interface OnItemReselectedListener {
        public void onNavigationItemReselected(@NonNull MenuItem var1);
    }

    public static interface OnItemSelectedListener {
        public boolean onNavigationItemSelected(@NonNull MenuItem var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LabelVisibility {
    }
}

