/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import com.google.android.material.R;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircularProgressIndicator
extends BaseProgressIndicator<CircularProgressIndicatorSpec> {
    public static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_CircularProgressIndicator;
    public static final int INDICATOR_DIRECTION_CLOCKWISE = 0;
    public static final int INDICATOR_DIRECTION_COUNTERCLOCKWISE = 1;

    public CircularProgressIndicator(@NonNull Context context) {
        this(context, null);
    }

    public CircularProgressIndicator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.circularProgressIndicatorStyle);
    }

    public CircularProgressIndicator(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr, DEF_STYLE_RES);
        this.initializeDrawables();
    }

    @Override
    CircularProgressIndicatorSpec createSpec(@NonNull Context context, @NonNull AttributeSet attrs) {
        return new CircularProgressIndicatorSpec(context, attrs);
    }

    private void initializeDrawables() {
        this.setIndeterminateDrawable(IndeterminateDrawable.createCircularDrawable(this.getContext(), (CircularProgressIndicatorSpec)this.spec));
        this.setProgressDrawable(DeterminateDrawable.createCircularDrawable(this.getContext(), (CircularProgressIndicatorSpec)this.spec));
    }

    @Override
    public void setTrackThickness(int trackThickness) {
        super.setTrackThickness(trackThickness);
        ((CircularProgressIndicatorSpec)this.spec).validateSpec();
    }

    @Px
    public int getIndicatorInset() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorInset;
    }

    public void setIndicatorInset(@Px int indicatorInset) {
        if (((CircularProgressIndicatorSpec)this.spec).indicatorInset != indicatorInset) {
            ((CircularProgressIndicatorSpec)this.spec).indicatorInset = indicatorInset;
            this.invalidate();
        }
    }

    @Px
    public int getIndicatorSize() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorSize;
    }

    public void setIndicatorSize(@Px int indicatorSize) {
        if (((CircularProgressIndicatorSpec)this.spec).indicatorSize != (indicatorSize = Math.max(indicatorSize, this.getTrackThickness() * 2))) {
            ((CircularProgressIndicatorSpec)this.spec).indicatorSize = indicatorSize;
            ((CircularProgressIndicatorSpec)this.spec).validateSpec();
            this.invalidate();
        }
    }

    public int getIndicatorDirection() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorDirection;
    }

    public void setIndicatorDirection(int indicatorDirection) {
        ((CircularProgressIndicatorSpec)this.spec).indicatorDirection = indicatorDirection;
        this.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface IndicatorDirection {
    }
}

