/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularDrawingDelegate;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

public final class DeterminateDrawable<S extends BaseProgressIndicatorSpec>
extends DrawableWithAnimatedVisibilityChange {
    private static final int MAX_DRAWABLE_LEVEL = 10000;
    private static final float SPRING_FORCE_STIFFNESS = 50.0f;
    private DrawingDelegate<S> drawingDelegate;
    private final SpringForce springForce;
    private final SpringAnimation springAnimation;
    private float indicatorFraction;
    private boolean skipAnimationOnLevelChange = false;
    private static final FloatPropertyCompat<DeterminateDrawable> INDICATOR_LENGTH_IN_LEVEL = new FloatPropertyCompat<DeterminateDrawable>("indicatorLevel"){

        public float getValue(DeterminateDrawable drawable2) {
            return drawable2.getIndicatorFraction() * 10000.0f;
        }

        public void setValue(DeterminateDrawable drawable2, float value) {
            drawable2.setIndicatorFraction(value / 10000.0f);
        }
    };

    DeterminateDrawable(@NonNull Context context, @NonNull BaseProgressIndicatorSpec baseSpec, @NonNull DrawingDelegate<S> drawingDelegate) {
        super(context, baseSpec);
        this.setDrawingDelegate(drawingDelegate);
        this.springForce = new SpringForce();
        this.springForce.setDampingRatio(1.0f);
        this.springForce.setStiffness(50.0f);
        this.springAnimation = new SpringAnimation((Object)this, INDICATOR_LENGTH_IN_LEVEL);
        this.springAnimation.setSpring(this.springForce);
        this.setGrowFraction(1.0f);
    }

    @NonNull
    public static DeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec) {
        return new DeterminateDrawable<LinearProgressIndicatorSpec>(context, spec, new LinearDrawingDelegate(spec));
    }

    @NonNull
    public static DeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec) {
        return new DeterminateDrawable<CircularProgressIndicatorSpec>(context, spec, new CircularDrawingDelegate(spec));
    }

    public void addSpringAnimationEndListener(@NonNull DynamicAnimation.OnAnimationEndListener listener) {
        this.springAnimation.addEndListener(listener);
    }

    public void removeSpringAnimationEndListener(@NonNull DynamicAnimation.OnAnimationEndListener listener) {
        this.springAnimation.removeEndListener(listener);
    }

    @Override
    boolean setVisibleInternal(boolean visible, boolean restart, boolean animate) {
        boolean changed = super.setVisibleInternal(visible, restart, animate);
        float systemAnimatorDurationScale = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        if (systemAnimatorDurationScale == 0.0f) {
            this.skipAnimationOnLevelChange = true;
        } else {
            this.skipAnimationOnLevelChange = false;
            this.springForce.setStiffness(50.0f / systemAnimatorDurationScale);
        }
        return changed;
    }

    public void jumpToCurrentState() {
        this.springAnimation.skipToEnd();
        this.setIndicatorFraction((float)this.getLevel() / 10000.0f);
    }

    protected boolean onLevelChange(int level) {
        if (this.skipAnimationOnLevelChange) {
            this.springAnimation.skipToEnd();
            this.setIndicatorFraction((float)level / 10000.0f);
        } else {
            this.springAnimation.setStartValue(this.getIndicatorFraction() * 10000.0f);
            this.springAnimation.animateToFinalPosition((float)level);
        }
        return true;
    }

    public int getIntrinsicWidth() {
        return this.drawingDelegate.getPreferredWidth();
    }

    public int getIntrinsicHeight() {
        return this.drawingDelegate.getPreferredHeight();
    }

    void setLevelByFraction(float fraction) {
        this.setLevel((int)(10000.0f * fraction));
    }

    public void draw(@NonNull Canvas canvas) {
        Rect clipBounds = new Rect();
        if (this.getBounds().isEmpty() || !this.isVisible() || !canvas.getClipBounds(clipBounds)) {
            return;
        }
        canvas.save();
        this.drawingDelegate.validateSpecAndAdjustCanvas(canvas, this.getBounds(), this.getGrowFraction());
        this.drawingDelegate.fillTrack(canvas, this.paint);
        int indicatorColor = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.getAlpha());
        this.drawingDelegate.fillIndicator(canvas, this.paint, 0.0f, this.getIndicatorFraction(), indicatorColor);
        canvas.restore();
    }

    private float getIndicatorFraction() {
        return this.indicatorFraction;
    }

    private void setIndicatorFraction(float indicatorFraction) {
        this.indicatorFraction = indicatorFraction;
        this.invalidateSelf();
    }

    @NonNull
    DrawingDelegate<S> getDrawingDelegate() {
        return this.drawingDelegate;
    }

    void setDrawingDelegate(@NonNull DrawingDelegate<S> drawingDelegate) {
        this.drawingDelegate = drawingDelegate;
        drawingDelegate.registerDrawable(this);
    }
}

