/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Outline;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeableDelegate;

@RequiresApi(value=22)
class ShapeableDelegateV22
extends ShapeableDelegate {
    private boolean canUseViewOutline = false;
    private float cornerRadius = 0.0f;

    ShapeableDelegateV22(@NonNull View view) {
        this.initMaskOutlineProvider(view);
    }

    @Override
    boolean shouldUseCompatClipping() {
        return !this.canUseViewOutline || this.forceCompatClippingEnabled;
    }

    @Override
    void invalidateClippingMethod(@NonNull View view) {
        this.cornerRadius = this.getDefaultCornerRadius();
        this.canUseViewOutline = this.isShapeRoundRect() || this.offsetZeroCornerEdgeBoundsIfPossible();
        view.setClipToOutline(!this.shouldUseCompatClipping());
        if (this.shouldUseCompatClipping()) {
            view.invalidate();
        } else {
            view.invalidateOutline();
        }
    }

    private float getDefaultCornerRadius() {
        if (this.shapeAppearanceModel == null || this.maskBounds == null) {
            return 0.0f;
        }
        return this.shapeAppearanceModel.topRightCornerSize.getCornerSize(this.maskBounds);
    }

    private boolean isShapeRoundRect() {
        if (this.maskBounds.isEmpty() || this.shapeAppearanceModel == null) {
            return false;
        }
        return this.shapeAppearanceModel.isRoundRect(this.maskBounds);
    }

    private boolean offsetZeroCornerEdgeBoundsIfPossible() {
        if (this.maskBounds.isEmpty() || this.shapeAppearanceModel == null || !this.offsetZeroCornerEdgeBoundsEnabled || this.shapeAppearanceModel.isRoundRect(this.maskBounds) || !ShapeableDelegateV22.shapeUsesAllRoundedCornerTreatments(this.shapeAppearanceModel)) {
            return false;
        }
        float topLeft = this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.maskBounds);
        float topRight = this.shapeAppearanceModel.getTopRightCornerSize().getCornerSize(this.maskBounds);
        float bottomLeft = this.shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(this.maskBounds);
        float bottomRight = this.shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(this.maskBounds);
        if (topLeft == 0.0f && bottomLeft == 0.0f && topRight == bottomRight) {
            this.maskBounds.set(this.maskBounds.left - topRight, this.maskBounds.top, this.maskBounds.right, this.maskBounds.bottom);
            this.cornerRadius = topRight;
        } else if (topLeft == 0.0f && topRight == 0.0f && bottomLeft == bottomRight) {
            this.maskBounds.set(this.maskBounds.left, this.maskBounds.top - bottomLeft, this.maskBounds.right, this.maskBounds.bottom);
            this.cornerRadius = bottomLeft;
        } else if (topRight == 0.0f && bottomRight == 0.0f && topLeft == bottomLeft) {
            this.maskBounds.set(this.maskBounds.left, this.maskBounds.top, this.maskBounds.right + topLeft, this.maskBounds.bottom);
            this.cornerRadius = topLeft;
        } else if (bottomLeft == 0.0f && bottomRight == 0.0f && topLeft == topRight) {
            this.maskBounds.set(this.maskBounds.left, this.maskBounds.top, this.maskBounds.right, this.maskBounds.bottom + topLeft);
            this.cornerRadius = topLeft;
        } else {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    float getCornerRadius() {
        return this.cornerRadius;
    }

    private static boolean shapeUsesAllRoundedCornerTreatments(ShapeAppearanceModel model) {
        return model.getTopLeftCorner() instanceof RoundedCornerTreatment && model.getTopRightCorner() instanceof RoundedCornerTreatment && model.getBottomLeftCorner() instanceof RoundedCornerTreatment && model.getBottomRightCorner() instanceof RoundedCornerTreatment;
    }

    @DoNotInline
    private void initMaskOutlineProvider(View view) {
        view.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                if (ShapeableDelegateV22.this.shapeAppearanceModel != null && !ShapeableDelegateV22.this.maskBounds.isEmpty()) {
                    outline.setRoundRect((int)ShapeableDelegateV22.this.maskBounds.left, (int)ShapeableDelegateV22.this.maskBounds.top, (int)ShapeableDelegateV22.this.maskBounds.right, (int)ShapeableDelegateV22.this.maskBounds.bottom, ShapeableDelegateV22.this.cornerRadius);
                }
            }
        });
    }
}

