/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.sidesheet.SheetDelegate;
import com.google.android.material.sidesheet.SheetUtils;
import com.google.android.material.sidesheet.SideSheetBehavior;

final class LeftSheetDelegate
extends SheetDelegate {
    final SideSheetBehavior<? extends View> sheetBehavior;

    LeftSheetDelegate(@NonNull SideSheetBehavior<? extends View> sheetBehavior) {
        this.sheetBehavior = sheetBehavior;
    }

    @Override
    int getSheetEdge() {
        return 1;
    }

    @Override
    int getHiddenOffset() {
        return -this.sheetBehavior.getChildWidth() - this.sheetBehavior.getInnerMargin();
    }

    @Override
    int getExpandedOffset() {
        return Math.max(0, this.sheetBehavior.getParentInnerEdge() + this.sheetBehavior.getInnerMargin());
    }

    @Override
    boolean isReleasedCloseToInnerEdge(@NonNull View releasedChild) {
        return releasedChild.getRight() < (this.getExpandedOffset() - this.getHiddenOffset()) / 2;
    }

    @Override
    boolean isSwipeSignificant(float xVelocity, float yVelocity) {
        return SheetUtils.isSwipeMostlyHorizontal(xVelocity, yVelocity) && Math.abs(xVelocity) > (float)this.sheetBehavior.getSignificantVelocityThreshold();
    }

    @Override
    boolean shouldHide(@NonNull View child, float velocity) {
        float newLeft = (float)child.getLeft() + velocity * this.sheetBehavior.getHideFriction();
        return Math.abs(newLeft) > this.sheetBehavior.getHideThreshold();
    }

    @Override
    <V extends View> int getOuterEdge(@NonNull V child) {
        return child.getRight() + this.sheetBehavior.getInnerMargin();
    }

    @Override
    float calculateSlideOffset(int left) {
        float hiddenOffset = this.getHiddenOffset();
        float sheetWidth = (float)this.getExpandedOffset() - hiddenOffset;
        return ((float)left - hiddenOffset) / sheetWidth;
    }

    @Override
    void updateCoplanarSiblingLayoutParams(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams, int sheetLeft, int sheetRight) {
        int parentWidth = this.sheetBehavior.getParentWidth();
        if (sheetLeft <= parentWidth) {
            coplanarSiblingLayoutParams.leftMargin = sheetRight;
        }
    }

    @Override
    void updateCoplanarSiblingAdjacentMargin(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams, int coplanarSiblingAdjacentMargin) {
        coplanarSiblingLayoutParams.leftMargin = coplanarSiblingAdjacentMargin;
    }

    @Override
    int getCoplanarSiblingAdjacentMargin(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams) {
        return coplanarSiblingLayoutParams.leftMargin;
    }

    @Override
    public int getParentInnerEdge(@NonNull CoordinatorLayout parent) {
        return parent.getLeft();
    }

    @Override
    int calculateInnerMargin(@NonNull ViewGroup.MarginLayoutParams marginLayoutParams) {
        return marginLayoutParams.leftMargin;
    }

    @Override
    int getMinViewPositionHorizontal() {
        return -this.sheetBehavior.getChildWidth();
    }

    @Override
    int getMaxViewPositionHorizontal() {
        return this.sheetBehavior.getInnerMargin();
    }

    @Override
    boolean isExpandingOutwards(float xVelocity) {
        return xVelocity > 0.0f;
    }
}

