/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.google.android.material.R;
import com.google.android.material.sidesheet.Sheet;
import com.google.android.material.sidesheet.SheetDialog;
import com.google.android.material.sidesheet.SideSheetBehavior;
import com.google.android.material.sidesheet.SideSheetCallback;

public class SideSheetDialog
extends SheetDialog<SideSheetCallback> {
    private static final int SIDE_SHEET_DIALOG_THEME_ATTR = R.attr.sideSheetDialogTheme;
    private static final int SIDE_SHEET_DIALOG_DEFAULT_THEME_RES = R.style.Theme_Material3_Light_SideSheetDialog;

    public SideSheetDialog(@NonNull Context context) {
        this(context, 0);
    }

    public SideSheetDialog(@NonNull Context context, @StyleRes int theme) {
        super(context, theme, SIDE_SHEET_DIALOG_THEME_ATTR, SIDE_SHEET_DIALOG_DEFAULT_THEME_RES);
    }

    @Override
    void addSheetCancelOnHideCallback(Sheet<SideSheetCallback> behavior) {
        behavior.addCallback(new SideSheetCallback(){

            @Override
            public void onStateChanged(@NonNull View sheet, int newState) {
                if (newState == 5) {
                    SideSheetDialog.this.cancel();
                }
            }

            @Override
            public void onSlide(@NonNull View sheet, float slideOffset) {
            }
        });
    }

    @Override
    @LayoutRes
    int getLayoutResId() {
        return R.layout.m3_side_sheet_dialog;
    }

    @Override
    @IdRes
    int getDialogId() {
        return R.id.m3_side_sheet;
    }

    @Override
    @NonNull
    Sheet<SideSheetCallback> getBehaviorFromSheet(@NonNull FrameLayout sheet) {
        return SideSheetBehavior.from(sheet);
    }

    @Override
    int getStateOnStart() {
        return 3;
    }

    @Override
    @NonNull
    public SideSheetBehavior<? extends View> getBehavior() {
        Sheet sheetBehavior = super.getBehavior();
        if (!(sheetBehavior instanceof SideSheetBehavior)) {
            throw new IllegalStateException("The view is not associated with SideSheetBehavior");
        }
        return (SideSheetBehavior)sheetBehavior;
    }
}

