/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import android.text.Editable;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Spinner;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityManagerCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.textfield.EditTextUtils;
import com.google.android.material.textfield.EndCompoundLayout;
import com.google.android.material.textfield.EndIconDelegate;

class DropdownMenuEndIconDelegate
extends EndIconDelegate {
    @ChecksSdkIntAtLeast(api=21)
    private static final boolean IS_LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    private static final int DEFAULT_ANIMATION_FADE_OUT_DURATION = 50;
    private static final int DEFAULT_ANIMATION_FADE_IN_DURATION = 67;
    private final int animationFadeOutDuration;
    private final int animationFadeInDuration;
    @NonNull
    private final TimeInterpolator animationFadeInterpolator;
    @Nullable
    private AutoCompleteTextView autoCompleteTextView;
    private final View.OnClickListener onIconClickListener = view -> this.showHideDropdown();
    private final View.OnFocusChangeListener onEditTextFocusChangeListener = (view, hasFocus) -> {
        this.editTextHasFocus = hasFocus;
        this.refreshIconState();
        if (!hasFocus) {
            this.setEndIconChecked(false);
            this.dropdownPopupDirty = false;
        }
    };
    private final AccessibilityManagerCompat.TouchExplorationStateChangeListener touchExplorationStateChangeListener = enabled -> {
        if (this.autoCompleteTextView != null && !EditTextUtils.isEditable((EditText)this.autoCompleteTextView)) {
            ViewCompat.setImportantForAccessibility((View)this.endIconView, (int)(enabled ? 2 : 1));
        }
    };
    private boolean editTextHasFocus;
    private boolean dropdownPopupDirty;
    private boolean isEndIconChecked;
    private long dropdownPopupActivatedAt = Long.MAX_VALUE;
    @Nullable
    private AccessibilityManager accessibilityManager;
    private ValueAnimator fadeOutAnim;
    private ValueAnimator fadeInAnim;

    DropdownMenuEndIconDelegate(@NonNull EndCompoundLayout endLayout) {
        super(endLayout);
        this.animationFadeInDuration = MotionUtils.resolveThemeDuration(endLayout.getContext(), R.attr.motionDurationShort3, 67);
        this.animationFadeOutDuration = MotionUtils.resolveThemeDuration(endLayout.getContext(), R.attr.motionDurationShort3, 50);
        this.animationFadeInterpolator = MotionUtils.resolveThemeInterpolator(endLayout.getContext(), R.attr.motionEasingLinearInterpolator, AnimationUtils.LINEAR_INTERPOLATOR);
    }

    @Override
    void setUp() {
        this.initAnimators();
        this.accessibilityManager = (AccessibilityManager)this.context.getSystemService("accessibility");
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    void tearDown() {
        if (this.autoCompleteTextView != null) {
            this.autoCompleteTextView.setOnTouchListener(null);
            if (IS_LOLLIPOP) {
                this.autoCompleteTextView.setOnDismissListener(null);
            }
        }
    }

    @Override
    public AccessibilityManagerCompat.TouchExplorationStateChangeListener getTouchExplorationStateChangeListener() {
        return this.touchExplorationStateChangeListener;
    }

    @Override
    int getIconDrawableResId() {
        return IS_LOLLIPOP ? R.drawable.mtrl_dropdown_arrow : R.drawable.mtrl_ic_arrow_drop_down;
    }

    @Override
    int getIconContentDescriptionResId() {
        return R.string.exposed_dropdown_menu_content_description;
    }

    @Override
    boolean isIconCheckable() {
        return true;
    }

    @Override
    boolean isIconChecked() {
        return this.isEndIconChecked;
    }

    @Override
    boolean isIconActivable() {
        return true;
    }

    @Override
    boolean isIconActivated() {
        return this.editTextHasFocus;
    }

    @Override
    boolean shouldTintIconOnError() {
        return true;
    }

    @Override
    boolean isBoxBackgroundModeSupported(int boxBackgroundMode) {
        return boxBackgroundMode != 0;
    }

    @Override
    View.OnClickListener getOnIconClickListener() {
        return this.onIconClickListener;
    }

    @Override
    public void onEditTextAttached(@Nullable EditText editText) {
        this.autoCompleteTextView = DropdownMenuEndIconDelegate.castAutoCompleteTextViewOrThrow(editText);
        this.setUpDropdownShowHideBehavior();
        this.textInputLayout.setErrorIconDrawable(null);
        if (!EditTextUtils.isEditable(editText) && this.accessibilityManager.isTouchExplorationEnabled()) {
            ViewCompat.setImportantForAccessibility((View)this.endIconView, (int)2);
        }
        this.textInputLayout.setEndIconVisible(true);
    }

    @Override
    public void afterEditTextChanged(Editable s) {
        if (this.accessibilityManager.isTouchExplorationEnabled() && EditTextUtils.isEditable((EditText)this.autoCompleteTextView) && !this.endIconView.hasFocus()) {
            this.autoCompleteTextView.dismissDropDown();
        }
        this.autoCompleteTextView.post(() -> {
            boolean isPopupShowing = this.autoCompleteTextView.isPopupShowing();
            this.setEndIconChecked(isPopupShowing);
            this.dropdownPopupDirty = isPopupShowing;
        });
    }

    @Override
    View.OnFocusChangeListener getOnEditTextFocusChangeListener() {
        return this.onEditTextFocusChangeListener;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
        if (!EditTextUtils.isEditable((EditText)this.autoCompleteTextView)) {
            info.setClassName((CharSequence)Spinner.class.getName());
        }
        if (info.isShowingHintText()) {
            info.setHintText(null);
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public void onPopulateAccessibilityEvent(View host, @NonNull AccessibilityEvent event) {
        boolean invalidState;
        if (!this.accessibilityManager.isEnabled() || EditTextUtils.isEditable((EditText)this.autoCompleteTextView)) {
            return;
        }
        boolean bl = invalidState = event.getEventType() == 32768 && this.isEndIconChecked && !this.autoCompleteTextView.isPopupShowing();
        if (event.getEventType() == 1 || invalidState) {
            this.showHideDropdown();
            this.updateDropdownPopupDirty();
        }
    }

    private void showHideDropdown() {
        if (this.autoCompleteTextView == null) {
            return;
        }
        if (this.isDropdownPopupActive()) {
            this.dropdownPopupDirty = false;
        }
        if (!this.dropdownPopupDirty) {
            if (IS_LOLLIPOP) {
                this.setEndIconChecked(!this.isEndIconChecked);
            } else {
                this.isEndIconChecked = !this.isEndIconChecked;
                this.refreshIconState();
            }
            if (this.isEndIconChecked) {
                this.autoCompleteTextView.requestFocus();
                this.autoCompleteTextView.showDropDown();
            } else {
                this.autoCompleteTextView.dismissDropDown();
            }
        } else {
            this.dropdownPopupDirty = false;
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setUpDropdownShowHideBehavior() {
        this.autoCompleteTextView.setOnTouchListener((view, event) -> {
            if (event.getAction() == 1) {
                if (this.isDropdownPopupActive()) {
                    this.dropdownPopupDirty = false;
                }
                this.showHideDropdown();
                this.updateDropdownPopupDirty();
            }
            return false;
        });
        if (IS_LOLLIPOP) {
            this.autoCompleteTextView.setOnDismissListener(() -> {
                this.updateDropdownPopupDirty();
                this.setEndIconChecked(false);
            });
        }
        this.autoCompleteTextView.setThreshold(0);
    }

    private boolean isDropdownPopupActive() {
        long activeFor = System.currentTimeMillis() - this.dropdownPopupActivatedAt;
        return activeFor < 0L || activeFor > 300L;
    }

    @NonNull
    private static AutoCompleteTextView castAutoCompleteTextViewOrThrow(EditText editText) {
        if (!(editText instanceof AutoCompleteTextView)) {
            throw new RuntimeException("EditText needs to be an AutoCompleteTextView if an Exposed Dropdown Menu is being used.");
        }
        return (AutoCompleteTextView)editText;
    }

    private void updateDropdownPopupDirty() {
        this.dropdownPopupDirty = true;
        this.dropdownPopupActivatedAt = System.currentTimeMillis();
    }

    private void setEndIconChecked(boolean checked) {
        if (this.isEndIconChecked != checked) {
            this.isEndIconChecked = checked;
            this.fadeInAnim.cancel();
            this.fadeOutAnim.start();
        }
    }

    private void initAnimators() {
        this.fadeInAnim = this.getAlphaAnimator(this.animationFadeInDuration, 0.0f, 1.0f);
        this.fadeOutAnim = this.getAlphaAnimator(this.animationFadeOutDuration, 1.0f, 0.0f);
        this.fadeOutAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DropdownMenuEndIconDelegate.this.refreshIconState();
                DropdownMenuEndIconDelegate.this.fadeInAnim.start();
            }
        });
    }

    private ValueAnimator getAlphaAnimator(int duration, float ... values) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])values);
        animator2.setInterpolator(this.animationFadeInterpolator);
        animator2.setDuration((long)duration);
        animator2.addUpdateListener(animation -> {
            float alpha = ((Float)animation.getAnimatedValue()).floatValue();
            this.endIconView.setAlpha(alpha);
        });
        return animator2;
    }
}

