/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityManagerCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.textfield.ClearTextEndIconDelegate;
import com.google.android.material.textfield.CustomEndIconDelegate;
import com.google.android.material.textfield.DropdownMenuEndIconDelegate;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.IconHelper;
import com.google.android.material.textfield.NoEndIconDelegate;
import com.google.android.material.textfield.PasswordToggleEndIconDelegate;
import com.google.android.material.textfield.TextInputLayout;
import java.util.LinkedHashSet;

@SuppressLint(value={"ViewConstructor"})
class EndCompoundLayout
extends LinearLayout {
    final TextInputLayout textInputLayout;
    @NonNull
    private final FrameLayout endIconFrame;
    @NonNull
    private final CheckableImageButton errorIconView;
    private ColorStateList errorIconTintList;
    private PorterDuff.Mode errorIconTintMode;
    private View.OnLongClickListener errorIconOnLongClickListener;
    @NonNull
    private final CheckableImageButton endIconView;
    private final EndIconDelegates endIconDelegates;
    private int endIconMode = 0;
    private final LinkedHashSet<TextInputLayout.OnEndIconChangedListener> endIconChangedListeners = new LinkedHashSet();
    private ColorStateList endIconTintList;
    private PorterDuff.Mode endIconTintMode;
    private int endIconMinSize;
    @NonNull
    private ImageView.ScaleType endIconScaleType;
    private View.OnLongClickListener endIconOnLongClickListener;
    @Nullable
    private CharSequence suffixText;
    @NonNull
    private final TextView suffixTextView;
    private boolean hintExpanded;
    private EditText editText;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @Nullable
    private AccessibilityManagerCompat.TouchExplorationStateChangeListener touchExplorationStateChangeListener;
    private final TextWatcher editTextWatcher = new TextWatcherAdapter(){

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            EndCompoundLayout.this.getEndIconDelegate().beforeEditTextChanged(s, start, count, after);
        }

        @Override
        public void afterTextChanged(Editable s) {
            EndCompoundLayout.this.getEndIconDelegate().afterEditTextChanged(s);
        }
    };
    private final TextInputLayout.OnEditTextAttachedListener onEditTextAttachedListener = new TextInputLayout.OnEditTextAttachedListener(){

        @Override
        public void onEditTextAttached(@NonNull TextInputLayout textInputLayout) {
            if (EndCompoundLayout.this.editText == textInputLayout.getEditText()) {
                return;
            }
            if (EndCompoundLayout.this.editText != null) {
                EndCompoundLayout.this.editText.removeTextChangedListener(EndCompoundLayout.this.editTextWatcher);
                if (EndCompoundLayout.this.editText.getOnFocusChangeListener() == EndCompoundLayout.this.getEndIconDelegate().getOnEditTextFocusChangeListener()) {
                    EndCompoundLayout.this.editText.setOnFocusChangeListener(null);
                }
            }
            EndCompoundLayout.this.editText = textInputLayout.getEditText();
            if (EndCompoundLayout.this.editText != null) {
                EndCompoundLayout.this.editText.addTextChangedListener(EndCompoundLayout.this.editTextWatcher);
            }
            EndCompoundLayout.this.getEndIconDelegate().onEditTextAttached(EndCompoundLayout.this.editText);
            EndCompoundLayout.this.setOnFocusChangeListenersIfNeeded(EndCompoundLayout.this.getEndIconDelegate());
        }
    };

    EndCompoundLayout(TextInputLayout textInputLayout, TintTypedArray a) {
        super(textInputLayout.getContext());
        this.accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.textInputLayout = textInputLayout;
        this.setVisibility(8);
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        this.endIconFrame = new FrameLayout(this.getContext());
        this.endIconFrame.setVisibility(8);
        this.endIconFrame.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        this.errorIconView = this.createIconView((ViewGroup)this, layoutInflater, R.id.text_input_error_icon);
        this.endIconView = this.createIconView((ViewGroup)this.endIconFrame, layoutInflater, R.id.text_input_end_icon);
        this.endIconDelegates = new EndIconDelegates(this, a);
        this.suffixTextView = new AppCompatTextView(this.getContext());
        this.initErrorIconView(a);
        this.initEndIconView(a);
        this.initSuffixTextView(a);
        this.endIconFrame.addView((View)this.endIconView);
        this.addView((View)this.suffixTextView);
        this.addView((View)this.endIconFrame);
        this.addView((View)this.errorIconView);
        textInputLayout.addOnEditTextAttachedListener(this.onEditTextAttachedListener);
        this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View ignored) {
                EndCompoundLayout.this.addTouchExplorationStateChangeListenerIfNeeded();
            }

            public void onViewDetachedFromWindow(View ignored) {
                EndCompoundLayout.this.removeTouchExplorationStateChangeListenerIfNeeded();
            }
        });
    }

    private CheckableImageButton createIconView(ViewGroup root, LayoutInflater inflater, @IdRes int id2) {
        CheckableImageButton iconView = (CheckableImageButton)inflater.inflate(R.layout.design_text_input_end_icon, root, false);
        iconView.setId(id2);
        IconHelper.setCompatRippleBackgroundIfNeeded(iconView);
        if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)lp, (int)0);
        }
        return iconView;
    }

    private void initErrorIconView(TintTypedArray a) {
        if (a.hasValue(R.styleable.TextInputLayout_errorIconTint)) {
            this.errorIconTintList = MaterialResources.getColorStateList(this.getContext(), a, R.styleable.TextInputLayout_errorIconTint);
        }
        if (a.hasValue(R.styleable.TextInputLayout_errorIconTintMode)) {
            this.errorIconTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_errorIconTintMode, -1), null);
        }
        if (a.hasValue(R.styleable.TextInputLayout_errorIconDrawable)) {
            this.setErrorIconDrawable(a.getDrawable(R.styleable.TextInputLayout_errorIconDrawable));
        }
        this.errorIconView.setContentDescription(this.getResources().getText(R.string.error_icon_content_description));
        ViewCompat.setImportantForAccessibility((View)this.errorIconView, (int)2);
        this.errorIconView.setClickable(false);
        this.errorIconView.setPressable(false);
        this.errorIconView.setFocusable(false);
    }

    private void initEndIconView(TintTypedArray a) {
        if (!a.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            if (a.hasValue(R.styleable.TextInputLayout_endIconTint)) {
                this.endIconTintList = MaterialResources.getColorStateList(this.getContext(), a, R.styleable.TextInputLayout_endIconTint);
            }
            if (a.hasValue(R.styleable.TextInputLayout_endIconTintMode)) {
                this.endIconTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_endIconTintMode, -1), null);
            }
        }
        if (a.hasValue(R.styleable.TextInputLayout_endIconMode)) {
            this.setEndIconMode(a.getInt(R.styleable.TextInputLayout_endIconMode, 0));
            if (a.hasValue(R.styleable.TextInputLayout_endIconContentDescription)) {
                this.setEndIconContentDescription(a.getText(R.styleable.TextInputLayout_endIconContentDescription));
            }
            this.setEndIconCheckable(a.getBoolean(R.styleable.TextInputLayout_endIconCheckable, true));
        } else if (a.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            boolean passwordToggleEnabled;
            if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTint)) {
                this.endIconTintList = MaterialResources.getColorStateList(this.getContext(), a, R.styleable.TextInputLayout_passwordToggleTint);
            }
            if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTintMode)) {
                this.endIconTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_passwordToggleTintMode, -1), null);
            }
            this.setEndIconMode((passwordToggleEnabled = a.getBoolean(R.styleable.TextInputLayout_passwordToggleEnabled, false)) ? 1 : 0);
            this.setEndIconContentDescription(a.getText(R.styleable.TextInputLayout_passwordToggleContentDescription));
        }
        this.setEndIconMinSize(a.getDimensionPixelSize(R.styleable.TextInputLayout_endIconMinSize, this.getResources().getDimensionPixelSize(R.dimen.mtrl_min_touch_target_size)));
        if (a.hasValue(R.styleable.TextInputLayout_endIconScaleType)) {
            this.setEndIconScaleType(IconHelper.convertScaleType(a.getInt(R.styleable.TextInputLayout_endIconScaleType, -1)));
        }
    }

    private void initSuffixTextView(TintTypedArray a) {
        this.suffixTextView.setVisibility(8);
        this.suffixTextView.setId(R.id.textinput_suffix_text);
        this.suffixTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 80.0f));
        ViewCompat.setAccessibilityLiveRegion((View)this.suffixTextView, (int)1);
        this.setSuffixTextAppearance(a.getResourceId(R.styleable.TextInputLayout_suffixTextAppearance, 0));
        if (a.hasValue(R.styleable.TextInputLayout_suffixTextColor)) {
            this.setSuffixTextColor(a.getColorStateList(R.styleable.TextInputLayout_suffixTextColor));
        }
        this.setSuffixText(a.getText(R.styleable.TextInputLayout_suffixText));
    }

    void setErrorIconDrawable(@DrawableRes int resId) {
        this.setErrorIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
        this.refreshErrorIconDrawableState();
    }

    void setErrorIconDrawable(@Nullable Drawable errorIconDrawable) {
        this.errorIconView.setImageDrawable(errorIconDrawable);
        this.updateErrorIconVisibility();
        IconHelper.applyIconTint(this.textInputLayout, this.errorIconView, this.errorIconTintList, this.errorIconTintMode);
    }

    Drawable getErrorIconDrawable() {
        return this.errorIconView.getDrawable();
    }

    void setErrorIconTintList(@Nullable ColorStateList errorIconTintList) {
        if (this.errorIconTintList != errorIconTintList) {
            this.errorIconTintList = errorIconTintList;
            IconHelper.applyIconTint(this.textInputLayout, this.errorIconView, errorIconTintList, this.errorIconTintMode);
        }
    }

    void setErrorIconTintMode(@Nullable PorterDuff.Mode errorIconTintMode) {
        if (this.errorIconTintMode != errorIconTintMode) {
            this.errorIconTintMode = errorIconTintMode;
            IconHelper.applyIconTint(this.textInputLayout, this.errorIconView, this.errorIconTintList, this.errorIconTintMode);
        }
    }

    void setErrorIconOnClickListener(@Nullable View.OnClickListener errorIconOnClickListener) {
        IconHelper.setIconOnClickListener(this.errorIconView, errorIconOnClickListener, this.errorIconOnLongClickListener);
    }

    CheckableImageButton getEndIconView() {
        return this.endIconView;
    }

    EndIconDelegate getEndIconDelegate() {
        return this.endIconDelegates.get(this.endIconMode);
    }

    int getEndIconMode() {
        return this.endIconMode;
    }

    void setEndIconMode(int endIconMode) {
        if (this.endIconMode == endIconMode) {
            return;
        }
        this.tearDownDelegate(this.getEndIconDelegate());
        int previousEndIconMode = this.endIconMode;
        this.endIconMode = endIconMode;
        this.dispatchOnEndIconChanged(previousEndIconMode);
        this.setEndIconVisible(endIconMode != 0);
        EndIconDelegate delegate = this.getEndIconDelegate();
        this.setEndIconDrawable(this.getIconResId(delegate));
        this.setEndIconContentDescription(delegate.getIconContentDescriptionResId());
        this.setEndIconCheckable(delegate.isIconCheckable());
        if (!delegate.isBoxBackgroundModeSupported(this.textInputLayout.getBoxBackgroundMode())) {
            throw new IllegalStateException("The current box background mode " + this.textInputLayout.getBoxBackgroundMode() + " is not supported by the end icon mode " + endIconMode);
        }
        this.setUpDelegate(delegate);
        this.setEndIconOnClickListener(delegate.getOnIconClickListener());
        if (this.editText != null) {
            delegate.onEditTextAttached(this.editText);
            this.setOnFocusChangeListenersIfNeeded(delegate);
        }
        IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
        this.refreshIconState(true);
    }

    void refreshIconState(boolean force) {
        boolean wasActivated;
        boolean wasChecked;
        boolean stateChanged = false;
        EndIconDelegate delegate = this.getEndIconDelegate();
        if (delegate.isIconCheckable() && (wasChecked = this.endIconView.isChecked()) != delegate.isIconChecked()) {
            this.endIconView.setChecked(!wasChecked);
            stateChanged = true;
        }
        if (delegate.isIconActivable() && (wasActivated = this.endIconView.isActivated()) != delegate.isIconActivated()) {
            this.setEndIconActivated(!wasActivated);
            stateChanged = true;
        }
        if (force || stateChanged) {
            this.refreshEndIconDrawableState();
        }
    }

    private void setUpDelegate(@NonNull EndIconDelegate delegate) {
        delegate.setUp();
        this.touchExplorationStateChangeListener = delegate.getTouchExplorationStateChangeListener();
        this.addTouchExplorationStateChangeListenerIfNeeded();
    }

    private void tearDownDelegate(@NonNull EndIconDelegate delegate) {
        this.removeTouchExplorationStateChangeListenerIfNeeded();
        this.touchExplorationStateChangeListener = null;
        delegate.tearDown();
    }

    private void addTouchExplorationStateChangeListenerIfNeeded() {
        if (this.touchExplorationStateChangeListener != null && this.accessibilityManager != null && ViewCompat.isAttachedToWindow((View)this)) {
            AccessibilityManagerCompat.addTouchExplorationStateChangeListener((AccessibilityManager)this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
    }

    private void removeTouchExplorationStateChangeListenerIfNeeded() {
        if (this.touchExplorationStateChangeListener != null && this.accessibilityManager != null) {
            AccessibilityManagerCompat.removeTouchExplorationStateChangeListener((AccessibilityManager)this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
    }

    private int getIconResId(EndIconDelegate delegate) {
        int customIconResId = this.endIconDelegates.customEndIconDrawableId;
        return customIconResId == 0 ? delegate.getIconDrawableResId() : customIconResId;
    }

    void setEndIconOnClickListener(@Nullable View.OnClickListener endIconOnClickListener) {
        IconHelper.setIconOnClickListener(this.endIconView, endIconOnClickListener, this.endIconOnLongClickListener);
    }

    void setEndIconOnLongClickListener(@Nullable View.OnLongClickListener endIconOnLongClickListener) {
        this.endIconOnLongClickListener = endIconOnLongClickListener;
        IconHelper.setIconOnLongClickListener(this.endIconView, endIconOnLongClickListener);
    }

    void setErrorIconOnLongClickListener(@Nullable View.OnLongClickListener errorIconOnLongClickListener) {
        this.errorIconOnLongClickListener = errorIconOnLongClickListener;
        IconHelper.setIconOnLongClickListener(this.errorIconView, errorIconOnLongClickListener);
    }

    private void setOnFocusChangeListenersIfNeeded(EndIconDelegate delegate) {
        if (this.editText == null) {
            return;
        }
        if (delegate.getOnEditTextFocusChangeListener() != null) {
            this.editText.setOnFocusChangeListener(delegate.getOnEditTextFocusChangeListener());
        }
        if (delegate.getOnIconViewFocusChangeListener() != null) {
            this.endIconView.setOnFocusChangeListener(delegate.getOnIconViewFocusChangeListener());
        }
    }

    void refreshErrorIconDrawableState() {
        IconHelper.refreshIconDrawableState(this.textInputLayout, this.errorIconView, this.errorIconTintList);
    }

    void setEndIconVisible(boolean visible) {
        if (this.isEndIconVisible() != visible) {
            this.endIconView.setVisibility(visible ? 0 : 8);
            this.updateEndLayoutVisibility();
            this.updateSuffixTextViewPadding();
            this.textInputLayout.updateDummyDrawables();
        }
    }

    boolean isEndIconVisible() {
        return this.endIconFrame.getVisibility() == 0 && this.endIconView.getVisibility() == 0;
    }

    void setEndIconActivated(boolean endIconActivated) {
        this.endIconView.setActivated(endIconActivated);
    }

    void refreshEndIconDrawableState() {
        IconHelper.refreshIconDrawableState(this.textInputLayout, this.endIconView, this.endIconTintList);
    }

    void setEndIconCheckable(boolean endIconCheckable) {
        this.endIconView.setCheckable(endIconCheckable);
    }

    boolean isEndIconCheckable() {
        return this.endIconView.isCheckable();
    }

    boolean isEndIconChecked() {
        return this.hasEndIcon() && this.endIconView.isChecked();
    }

    void checkEndIcon() {
        this.endIconView.performClick();
        this.endIconView.jumpDrawablesToCurrentState();
    }

    void setEndIconDrawable(@DrawableRes int resId) {
        this.setEndIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    void setEndIconDrawable(@Nullable Drawable endIconDrawable) {
        this.endIconView.setImageDrawable(endIconDrawable);
        if (endIconDrawable != null) {
            IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
            this.refreshEndIconDrawableState();
        }
    }

    @Nullable
    Drawable getEndIconDrawable() {
        return this.endIconView.getDrawable();
    }

    void setEndIconContentDescription(@StringRes int resId) {
        this.setEndIconContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    void setEndIconContentDescription(@Nullable CharSequence endIconContentDescription) {
        if (this.getEndIconContentDescription() != endIconContentDescription) {
            this.endIconView.setContentDescription(endIconContentDescription);
        }
    }

    @Nullable
    CharSequence getEndIconContentDescription() {
        return this.endIconView.getContentDescription();
    }

    void setEndIconTintList(@Nullable ColorStateList endIconTintList) {
        if (this.endIconTintList != endIconTintList) {
            this.endIconTintList = endIconTintList;
            IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
        }
    }

    void setEndIconTintMode(@Nullable PorterDuff.Mode endIconTintMode) {
        if (this.endIconTintMode != endIconTintMode) {
            this.endIconTintMode = endIconTintMode;
            IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
        }
    }

    void setEndIconMinSize(@Px int iconSize) {
        if (iconSize < 0) {
            throw new IllegalArgumentException("endIconSize cannot be less than 0");
        }
        if (iconSize != this.endIconMinSize) {
            this.endIconMinSize = iconSize;
            IconHelper.setIconMinSize(this.endIconView, iconSize);
            IconHelper.setIconMinSize(this.errorIconView, iconSize);
        }
    }

    int getEndIconMinSize() {
        return this.endIconMinSize;
    }

    void setEndIconScaleType(@NonNull ImageView.ScaleType endIconScaleType) {
        this.endIconScaleType = endIconScaleType;
        IconHelper.setIconScaleType(this.endIconView, endIconScaleType);
        IconHelper.setIconScaleType(this.errorIconView, endIconScaleType);
    }

    @NonNull
    ImageView.ScaleType getEndIconScaleType() {
        return this.endIconScaleType;
    }

    void addOnEndIconChangedListener(@NonNull TextInputLayout.OnEndIconChangedListener listener) {
        this.endIconChangedListeners.add(listener);
    }

    void removeOnEndIconChangedListener(@NonNull TextInputLayout.OnEndIconChangedListener listener) {
        this.endIconChangedListeners.remove(listener);
    }

    void clearOnEndIconChangedListeners() {
        this.endIconChangedListeners.clear();
    }

    boolean hasEndIcon() {
        return this.endIconMode != 0;
    }

    TextView getSuffixTextView() {
        return this.suffixTextView;
    }

    void setSuffixText(@Nullable CharSequence suffixText) {
        this.suffixText = TextUtils.isEmpty((CharSequence)suffixText) ? null : suffixText;
        this.suffixTextView.setText(suffixText);
        this.updateSuffixTextVisibility();
    }

    @Nullable
    CharSequence getSuffixText() {
        return this.suffixText;
    }

    void setSuffixTextAppearance(@StyleRes int suffixTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.suffixTextView, (int)suffixTextAppearance);
    }

    void setSuffixTextColor(@NonNull ColorStateList suffixTextColor) {
        this.suffixTextView.setTextColor(suffixTextColor);
    }

    @Nullable
    ColorStateList getSuffixTextColor() {
        return this.suffixTextView.getTextColors();
    }

    void setPasswordVisibilityToggleDrawable(@DrawableRes int resId) {
        this.setPasswordVisibilityToggleDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    void setPasswordVisibilityToggleDrawable(@Nullable Drawable icon) {
        this.endIconView.setImageDrawable(icon);
    }

    void setPasswordVisibilityToggleContentDescription(@StringRes int resId) {
        this.setPasswordVisibilityToggleContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    void setPasswordVisibilityToggleContentDescription(@Nullable CharSequence description) {
        this.endIconView.setContentDescription(description);
    }

    @Nullable
    Drawable getPasswordVisibilityToggleDrawable() {
        return this.endIconView.getDrawable();
    }

    @Nullable
    CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.endIconView.getContentDescription();
    }

    boolean isPasswordVisibilityToggleEnabled() {
        return this.endIconMode == 1;
    }

    void setPasswordVisibilityToggleEnabled(boolean enabled) {
        if (enabled && this.endIconMode != 1) {
            this.setEndIconMode(1);
        } else if (!enabled) {
            this.setEndIconMode(0);
        }
    }

    void setPasswordVisibilityToggleTintList(@Nullable ColorStateList tintList) {
        this.endIconTintList = tintList;
        IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
    }

    void setPasswordVisibilityToggleTintMode(@Nullable PorterDuff.Mode mode) {
        this.endIconTintMode = mode;
        IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
    }

    void togglePasswordVisibilityToggle(boolean shouldSkipAnimations) {
        if (this.endIconMode == 1) {
            this.endIconView.performClick();
            if (shouldSkipAnimations) {
                this.endIconView.jumpDrawablesToCurrentState();
            }
        }
    }

    void onHintStateChanged(boolean hintExpanded) {
        this.hintExpanded = hintExpanded;
        this.updateSuffixTextVisibility();
    }

    void onTextInputBoxStateUpdated() {
        this.updateErrorIconVisibility();
        this.refreshErrorIconDrawableState();
        this.refreshEndIconDrawableState();
        if (this.getEndIconDelegate().shouldTintIconOnError()) {
            this.tintEndIconOnError(this.textInputLayout.shouldShowError());
        }
    }

    private void updateSuffixTextVisibility() {
        int newVisibility;
        int oldVisibility = this.suffixTextView.getVisibility();
        int n = newVisibility = this.suffixText != null && !this.hintExpanded ? 0 : 8;
        if (oldVisibility != newVisibility) {
            this.getEndIconDelegate().onSuffixVisibilityChanged(newVisibility == 0);
        }
        this.updateEndLayoutVisibility();
        this.suffixTextView.setVisibility(newVisibility);
        this.textInputLayout.updateDummyDrawables();
    }

    void updateSuffixTextViewPadding() {
        if (this.textInputLayout.editText == null) {
            return;
        }
        int endPadding = this.isEndIconVisible() || this.isErrorIconVisible() ? 0 : ViewCompat.getPaddingEnd((View)this.textInputLayout.editText);
        ViewCompat.setPaddingRelative((View)this.suffixTextView, (int)this.getContext().getResources().getDimensionPixelSize(R.dimen.material_input_text_to_prefix_suffix_padding), (int)this.textInputLayout.editText.getPaddingTop(), (int)endPadding, (int)this.textInputLayout.editText.getPaddingBottom());
    }

    int getSuffixTextEndOffset() {
        int endIconOffset = this.isEndIconVisible() || this.isErrorIconVisible() ? this.endIconView.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)this.endIconView.getLayoutParams())) : 0;
        return ViewCompat.getPaddingEnd((View)this) + ViewCompat.getPaddingEnd((View)this.suffixTextView) + endIconOffset;
    }

    @Nullable
    CheckableImageButton getCurrentEndIconView() {
        if (this.isErrorIconVisible()) {
            return this.errorIconView;
        }
        if (this.hasEndIcon() && this.isEndIconVisible()) {
            return this.endIconView;
        }
        return null;
    }

    boolean isErrorIconVisible() {
        return this.errorIconView.getVisibility() == 0;
    }

    private void updateErrorIconVisibility() {
        boolean visible = this.getErrorIconDrawable() != null && this.textInputLayout.isErrorEnabled() && this.textInputLayout.shouldShowError();
        this.errorIconView.setVisibility(visible ? 0 : 8);
        this.updateEndLayoutVisibility();
        this.updateSuffixTextViewPadding();
        if (!this.hasEndIcon()) {
            this.textInputLayout.updateDummyDrawables();
        }
    }

    private void updateEndLayoutVisibility() {
        this.endIconFrame.setVisibility(this.endIconView.getVisibility() == 0 && !this.isErrorIconVisible() ? 0 : 8);
        int suffixTextVisibility = this.suffixText != null && !this.hintExpanded ? 0 : 8;
        boolean shouldBeVisible = this.isEndIconVisible() || this.isErrorIconVisible() || suffixTextVisibility == 0;
        this.setVisibility(shouldBeVisible ? 0 : 8);
    }

    private void dispatchOnEndIconChanged(int previousIcon) {
        for (TextInputLayout.OnEndIconChangedListener listener : this.endIconChangedListeners) {
            listener.onEndIconChanged(this.textInputLayout, previousIcon);
        }
    }

    private void tintEndIconOnError(boolean tintEndIconOnError) {
        if (tintEndIconOnError && this.getEndIconDrawable() != null) {
            Drawable endIconDrawable = DrawableCompat.wrap((Drawable)this.getEndIconDrawable()).mutate();
            DrawableCompat.setTint((Drawable)endIconDrawable, (int)this.textInputLayout.getErrorCurrentTextColors());
            this.endIconView.setImageDrawable(endIconDrawable);
        } else {
            IconHelper.applyIconTint(this.textInputLayout, this.endIconView, this.endIconTintList, this.endIconTintMode);
        }
    }

    private static class EndIconDelegates {
        private final SparseArray<EndIconDelegate> delegates = new SparseArray();
        private final EndCompoundLayout endLayout;
        private final int customEndIconDrawableId;
        private final int passwordIconDrawableId;

        EndIconDelegates(EndCompoundLayout endLayout, TintTypedArray a) {
            this.endLayout = endLayout;
            this.customEndIconDrawableId = a.getResourceId(R.styleable.TextInputLayout_endIconDrawable, 0);
            this.passwordIconDrawableId = a.getResourceId(R.styleable.TextInputLayout_passwordToggleDrawable, 0);
        }

        EndIconDelegate get(int endIconMode) {
            EndIconDelegate delegate = (EndIconDelegate)this.delegates.get(endIconMode);
            if (delegate == null) {
                delegate = this.create(endIconMode);
                this.delegates.append(endIconMode, (Object)delegate);
            }
            return delegate;
        }

        private EndIconDelegate create(int endIconMode) {
            switch (endIconMode) {
                case 1: {
                    return new PasswordToggleEndIconDelegate(this.endLayout, this.passwordIconDrawableId);
                }
                case 2: {
                    return new ClearTextEndIconDelegate(this.endLayout);
                }
                case 3: {
                    return new DropdownMenuEndIconDelegate(this.endLayout);
                }
                case -1: {
                    return new CustomEndIconDelegate(this.endLayout);
                }
                case 0: {
                    return new NoEndIconDelegate(this.endLayout);
                }
            }
            throw new IllegalArgumentException("Invalid end icon mode: " + endIconMode);
        }
    }
}

