/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.google.android.material.R;
import com.google.android.material.textfield.EndCompoundLayout;
import com.google.android.material.textfield.EndIconDelegate;

class PasswordToggleEndIconDelegate
extends EndIconDelegate {
    private int iconResId = R.drawable.design_password_eye;
    @Nullable
    private EditText editText;
    private final View.OnClickListener onIconClickListener = view -> {
        if (this.editText == null) {
            return;
        }
        int selection = this.editText.getSelectionEnd();
        if (this.hasPasswordTransformation()) {
            this.editText.setTransformationMethod(null);
        } else {
            this.editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        if (selection >= 0) {
            this.editText.setSelection(selection);
        }
        this.refreshIconState();
    };

    PasswordToggleEndIconDelegate(@NonNull EndCompoundLayout endLayout, @DrawableRes int overrideIconResId) {
        super(endLayout);
        if (overrideIconResId != 0) {
            this.iconResId = overrideIconResId;
        }
    }

    @Override
    void setUp() {
        if (PasswordToggleEndIconDelegate.isInputTypePassword(this.editText)) {
            this.editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
    }

    @Override
    void tearDown() {
        if (this.editText != null) {
            this.editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
    }

    @Override
    @DrawableRes
    int getIconDrawableResId() {
        return this.iconResId;
    }

    @Override
    @StringRes
    int getIconContentDescriptionResId() {
        return R.string.password_toggle_content_description;
    }

    @Override
    boolean isIconCheckable() {
        return true;
    }

    @Override
    boolean isIconChecked() {
        return !this.hasPasswordTransformation();
    }

    @Override
    View.OnClickListener getOnIconClickListener() {
        return this.onIconClickListener;
    }

    @Override
    void onEditTextAttached(@Nullable EditText editText) {
        this.editText = editText;
        this.refreshIconState();
    }

    @Override
    void beforeEditTextChanged(CharSequence s, int start, int count, int after) {
        this.refreshIconState();
    }

    private boolean hasPasswordTransformation() {
        return this.editText != null && this.editText.getTransformationMethod() instanceof PasswordTransformationMethod;
    }

    private static boolean isInputTypePassword(EditText editText) {
        return editText != null && (editText.getInputType() == 16 || editText.getInputType() == 128 || editText.getInputType() == 144 || editText.getInputType() == 224);
    }
}

