/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.chip.Chip;
import com.google.android.material.timepicker.ClockFaceView;
import com.google.android.material.timepicker.ClockHandView;
import com.google.android.material.timepicker.TimePickerControls;
import java.util.Locale;

class TimePickerView
extends ConstraintLayout
implements TimePickerControls {
    static final String GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME = "android.view.View";
    private final Chip minuteView;
    private final Chip hourView;
    private final ClockHandView clockHandView;
    private final ClockFaceView clockFace;
    private final MaterialButtonToggleGroup toggle;
    private final View.OnClickListener selectionListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (TimePickerView.this.onSelectionChangeListener != null) {
                TimePickerView.this.onSelectionChangeListener.onSelectionChanged((Integer)v.getTag(R.id.selection_type));
            }
        }
    };
    private OnPeriodChangeListener onPeriodChangeListener;
    private OnSelectionChange onSelectionChangeListener;
    private OnDoubleTapListener onDoubleTapListener;

    public TimePickerView(Context context) {
        this(context, null);
    }

    public TimePickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimePickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.material_timepicker, (ViewGroup)this);
        this.clockFace = (ClockFaceView)this.findViewById(R.id.material_clock_face);
        this.toggle = (MaterialButtonToggleGroup)this.findViewById(R.id.material_clock_period_toggle);
        this.toggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (!isChecked) {
                return;
            }
            if (this.onPeriodChangeListener != null) {
                int period = checkedId == R.id.material_clock_period_pm_button ? 1 : 0;
                this.onPeriodChangeListener.onPeriodChange(period);
            }
        });
        this.minuteView = (Chip)this.findViewById(R.id.material_minute_tv);
        this.hourView = (Chip)this.findViewById(R.id.material_hour_tv);
        this.clockHandView = (ClockHandView)this.findViewById(R.id.material_clock_hand);
        this.setupDoubleTap();
        this.setUpDisplay();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setupDoubleTap() {
        final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                OnDoubleTapListener listener = TimePickerView.this.onDoubleTapListener;
                if (listener != null) {
                    listener.onDoubleTap();
                    return true;
                }
                return false;
            }
        });
        View.OnTouchListener onTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (((Checkable)v).isChecked()) {
                    return gestureDetector.onTouchEvent(event);
                }
                return false;
            }
        };
        this.minuteView.setOnTouchListener(onTouchListener);
        this.hourView.setOnTouchListener(onTouchListener);
    }

    public void setMinuteHourDelegate(AccessibilityDelegateCompat clickActionDelegate) {
        ViewCompat.setAccessibilityDelegate((View)this.hourView, (AccessibilityDelegateCompat)clickActionDelegate);
    }

    public void setHourClickDelegate(AccessibilityDelegateCompat clickActionDelegate) {
        ViewCompat.setAccessibilityDelegate((View)this.minuteView, (AccessibilityDelegateCompat)clickActionDelegate);
    }

    private void setUpDisplay() {
        this.minuteView.setTag(R.id.selection_type, 12);
        this.hourView.setTag(R.id.selection_type, 10);
        this.minuteView.setOnClickListener(this.selectionListener);
        this.hourView.setOnClickListener(this.selectionListener);
        this.minuteView.setAccessibilityClassName(GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME);
        this.hourView.setAccessibilityClassName(GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME);
    }

    @Override
    public void setValues(String[] values, @StringRes int contentDescription) {
        this.clockFace.setValues(values, contentDescription);
    }

    @Override
    public void setHandRotation(float rotation) {
        this.clockHandView.setHandRotation(rotation);
    }

    public void setHandRotation(float rotation, boolean animate) {
        this.clockHandView.setHandRotation(rotation, animate);
    }

    public void setAnimateOnTouchUp(boolean animating) {
        this.clockHandView.setAnimateOnTouchUp(animating);
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void updateTime(int period, int hourOfDay, int minute) {
        int checkedId = period == 1 ? R.id.material_clock_period_pm_button : R.id.material_clock_period_am_button;
        this.toggle.check(checkedId);
        Locale current = this.getResources().getConfiguration().locale;
        String minuteFormatted = String.format(current, "%02d", minute);
        String hourFormatted = String.format(current, "%02d", hourOfDay);
        if (!TextUtils.equals((CharSequence)this.minuteView.getText(), (CharSequence)minuteFormatted)) {
            this.minuteView.setText(minuteFormatted);
        }
        if (!TextUtils.equals((CharSequence)this.hourView.getText(), (CharSequence)hourFormatted)) {
            this.hourView.setText(hourFormatted);
        }
    }

    @Override
    public void setActiveSelection(int selection) {
        this.updateSelection(this.minuteView, selection == 12);
        this.updateSelection(this.hourView, selection == 10);
    }

    private void updateSelection(Chip chip, boolean isSelected) {
        chip.setChecked(isSelected);
        ViewCompat.setAccessibilityLiveRegion((View)chip, (int)(isSelected ? 2 : 0));
    }

    public void addOnRotateListener(ClockHandView.OnRotateListener onRotateListener) {
        this.clockHandView.addOnRotateListener(onRotateListener);
    }

    public void setOnActionUpListener(ClockHandView.OnActionUpListener onActionUpListener) {
        this.clockHandView.setOnActionUpListener(onActionUpListener);
    }

    void setOnPeriodChangeListener(OnPeriodChangeListener onPeriodChangeListener) {
        this.onPeriodChangeListener = onPeriodChangeListener;
    }

    void setOnSelectionChangeListener(OnSelectionChange onSelectionChangeListener) {
        this.onSelectionChangeListener = onSelectionChangeListener;
    }

    void setOnDoubleTapListener(@Nullable OnDoubleTapListener listener) {
        this.onDoubleTapListener = listener;
    }

    public void showToggle() {
        this.toggle.setVisibility(0);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (changedView == this && visibility == 0) {
            this.hourView.sendAccessibilityEvent(8);
        }
    }

    int getCurrentLevel() {
        return this.clockFace.getCurrentLevel();
    }

    void setCurrentLevel(int level) {
        this.clockFace.setCurrentLevel(level);
    }

    static interface OnDoubleTapListener {
        public void onDoubleTap();
    }

    static interface OnSelectionChange {
        public void onSelectionChanged(int var1);
    }

    static interface OnPeriodChangeListener {
        public void onPeriodChange(int var1);
    }
}

