/*
 * Decompiled with CFR 0.152.
 */
package android.support.customtabs;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface IEngagementSignalsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android$support$customtabs$IEngagementSignalsCallback".replace('$', '.');

    public void onVerticalScrollEvent(boolean var1, Bundle var2) throws RemoteException;

    public void onGreatestScrollPercentageIncreased(int var1, Bundle var2) throws RemoteException;

    public void onSessionEnded(boolean var1, Bundle var2) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IEngagementSignalsCallback {
        static final int TRANSACTION_onVerticalScrollEvent = 2;
        static final int TRANSACTION_onGreatestScrollPercentageIncreased = 3;
        static final int TRANSACTION_onSessionEnded = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IEngagementSignalsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IEngagementSignalsCallback) {
                return (IEngagementSignalsCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    boolean _arg0 = 0 != data.readInt();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onVerticalScrollEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onGreatestScrollPercentageIncreased(_arg0, _arg1);
                    break;
                }
                case 4: {
                    boolean _arg0 = 0 != data.readInt();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onSessionEnded(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IEngagementSignalsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVerticalScrollEvent(boolean isDirectionUp, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(isDirectionUp ? 1 : 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGreatestScrollPercentageIncreased(int scrollPercentage, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(scrollPercentage);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEnded(boolean didUserInteract, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(didUserInteract ? 1 : 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IEngagementSignalsCallback {
        @Override
        public void onVerticalScrollEvent(boolean isDirectionUp, Bundle extras) throws RemoteException {
        }

        @Override
        public void onGreatestScrollPercentageIncreased(int scrollPercentage, Bundle extras) throws RemoteException {
        }

        @Override
        public void onSessionEnded(boolean didUserInteract, Bundle extras) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

