/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.PendingIntent;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsSession;

public class CustomTabsSessionToken {
    private static final String TAG = "CustomTabsSessionToken";
    @Nullable
    final ICustomTabsCallback mCallbackBinder;
    @Nullable
    private final PendingIntent mSessionId;
    @Nullable
    private final CustomTabsCallback mCallback;

    @Nullable
    public static CustomTabsSessionToken getSessionTokenFromIntent(@NonNull Intent intent) {
        Bundle b = intent.getExtras();
        if (b == null) {
            return null;
        }
        IBinder binder = b.getBinder("android.support.customtabs.extra.SESSION");
        PendingIntent sessionId = (PendingIntent)intent.getParcelableExtra("android.support.customtabs.extra.SESSION_ID");
        if (binder == null && sessionId == null) {
            return null;
        }
        ICustomTabsCallback callback = binder == null ? null : ICustomTabsCallback.Stub.asInterface(binder);
        return new CustomTabsSessionToken(callback, sessionId);
    }

    @NonNull
    public static CustomTabsSessionToken createMockSessionTokenForTesting() {
        return new CustomTabsSessionToken(new MockCallback(), null);
    }

    CustomTabsSessionToken(@Nullable ICustomTabsCallback callbackBinder, @Nullable PendingIntent sessionId) {
        if (callbackBinder == null && sessionId == null) {
            throw new IllegalStateException("CustomTabsSessionToken must have either a session id or a callback (or both).");
        }
        this.mCallbackBinder = callbackBinder;
        this.mSessionId = sessionId;
        this.mCallback = this.mCallbackBinder == null ? null : new CustomTabsCallback(){

            @Override
            public void onNavigationEvent(int navigationEvent, @Nullable Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onNavigationEvent(navigationEvent, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void extraCallback(@NonNull String callbackName, @Nullable Bundle args) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.extraCallback(callbackName, args);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            @NonNull
            public Bundle extraCallbackWithResult(@NonNull String callbackName, @Nullable Bundle args) {
                try {
                    return CustomTabsSessionToken.this.mCallbackBinder.extraCallbackWithResult(callbackName, args);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                    return null;
                }
            }

            @Override
            public void onMessageChannelReady(@Nullable Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onMessageChannelReady(extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onPostMessage(@NonNull String message, @Nullable Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onPostMessage(message, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onRelationshipValidationResult(int relation, @NonNull Uri origin, boolean result, @Nullable Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onRelationshipValidationResult(relation, origin, result, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onActivityResized(int height, int width, @NonNull Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onActivityResized(height, width, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onWarmupCompleted(@NonNull Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onWarmupCompleted(extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onActivityLayout(int left, int top, int right, int bottom, int state, @NonNull Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onActivityLayout(left, top, right, bottom, state, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onMinimized(@NonNull Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onMinimized(extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onUnminimized(@NonNull Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onUnminimized(extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }
        };
    }

    @Nullable
    IBinder getCallbackBinder() {
        if (this.mCallbackBinder == null) {
            return null;
        }
        return this.mCallbackBinder.asBinder();
    }

    private IBinder getCallbackBinderAssertNotNull() {
        if (this.mCallbackBinder == null) {
            throw new IllegalStateException("CustomTabSessionToken must have valid binder or pending session");
        }
        return this.mCallbackBinder.asBinder();
    }

    @Nullable
    PendingIntent getId() {
        return this.mSessionId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean hasCallback() {
        return this.mCallbackBinder != null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean hasId() {
        return this.mSessionId != null;
    }

    public int hashCode() {
        if (this.mSessionId != null) {
            return this.mSessionId.hashCode();
        }
        return this.getCallbackBinderAssertNotNull().hashCode();
    }

    public boolean equals(Object o) {
        CustomTabsSessionToken other;
        PendingIntent otherSessionId;
        if (!(o instanceof CustomTabsSessionToken)) {
            return false;
        }
        if (this.mSessionId == null != ((otherSessionId = (other = (CustomTabsSessionToken)o).getId()) == null)) {
            return false;
        }
        if (this.mSessionId != null) {
            return this.mSessionId.equals((Object)otherSessionId);
        }
        return this.getCallbackBinderAssertNotNull().equals(other.getCallbackBinderAssertNotNull());
    }

    @Nullable
    public CustomTabsCallback getCallback() {
        return this.mCallback;
    }

    public boolean isAssociatedWith(@NonNull CustomTabsSession session) {
        return session.getBinder().equals(this.mCallbackBinder);
    }

    static class MockCallback
    extends ICustomTabsCallback.Stub {
        MockCallback() {
        }

        @Override
        public void onNavigationEvent(int navigationEvent, Bundle extras) {
        }

        @Override
        public void extraCallback(String callbackName, Bundle args) {
        }

        @Override
        public Bundle extraCallbackWithResult(String callbackName, Bundle args) {
            return null;
        }

        @Override
        public void onMessageChannelReady(Bundle extras) {
        }

        @Override
        public void onPostMessage(String message, Bundle extras) {
        }

        @Override
        public void onRelationshipValidationResult(int relation, Uri requestedOrigin, boolean result, Bundle extras) {
        }

        @Override
        public void onActivityResized(int height, int width, Bundle extras) {
        }

        @Override
        public void onWarmupCompleted(Bundle extras) {
        }

        @Override
        public void onActivityLayout(int left, int top, int right, int bottom, int state, @NonNull Bundle extras) {
        }

        @Override
        public void onMinimized(@NonNull Bundle extras) {
        }

        @Override
        public void onUnminimized(@NonNull Bundle extras) {
        }

        @Override
        public IBinder asBinder() {
            return this;
        }
    }
}

