/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.IEngagementSignalsCallback;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.EngagementSignalsCallback;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class EngagementSignalsCallbackRemote
implements EngagementSignalsCallback {
    private static final String TAG = "EngagementSigsCallbkRmt";
    private final IEngagementSignalsCallback mCallbackBinder;

    private EngagementSignalsCallbackRemote(@NonNull IEngagementSignalsCallback callbackBinder) {
        this.mCallbackBinder = callbackBinder;
    }

    @NonNull
    static EngagementSignalsCallbackRemote fromBinder(@NonNull IBinder binder) {
        IEngagementSignalsCallback callbackBinder = IEngagementSignalsCallback.Stub.asInterface(binder);
        return new EngagementSignalsCallbackRemote(callbackBinder);
    }

    @Override
    public void onVerticalScrollEvent(boolean isDirectionUp, @NonNull Bundle extras) {
        try {
            this.mCallbackBinder.onVerticalScrollEvent(isDirectionUp, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException during IEngagementSignalsCallback transaction");
        }
    }

    @Override
    public void onGreatestScrollPercentageIncreased(@IntRange(from=1L, to=100L) int scrollPercentage, @NonNull Bundle extras) {
        try {
            this.mCallbackBinder.onGreatestScrollPercentageIncreased(scrollPercentage, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException during IEngagementSignalsCallback transaction");
        }
    }

    @Override
    public void onSessionEnded(boolean didUserInteract, @NonNull Bundle extras) {
        try {
            this.mCallbackBinder.onSessionEnded(didUserInteract, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException during IEngagementSignalsCallback transaction");
        }
    }
}

