/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.customtabs.trusted.ITrustedWebActivityService;
import androidx.annotation.BinderThread;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.browser.trusted.NotificationApiHelperForM;
import androidx.browser.trusted.NotificationApiHelperForO;
import androidx.browser.trusted.Token;
import androidx.browser.trusted.TokenStore;
import androidx.browser.trusted.TrustedWebActivityCallbackRemote;
import androidx.browser.trusted.TrustedWebActivityServiceConnection;
import androidx.core.app.NotificationManagerCompat;
import java.util.Locale;

public abstract class TrustedWebActivityService
extends Service {
    @SuppressLint(value={"ActionValue", "ServiceName"})
    public static final String ACTION_TRUSTED_WEB_ACTIVITY_SERVICE = "android.support.customtabs.trusted.TRUSTED_WEB_ACTIVITY_SERVICE";
    public static final String META_DATA_NAME_SMALL_ICON = "android.support.customtabs.trusted.SMALL_ICON";
    public static final String KEY_SMALL_ICON_BITMAP = "android.support.customtabs.trusted.SMALL_ICON_BITMAP";
    public static final String KEY_SUCCESS = "androidx.browser.trusted.SUCCESS";
    public static final int SMALL_ICON_NOT_SET = -1;
    private NotificationManager mNotificationManager;
    int mVerifiedUid = -1;
    private final ITrustedWebActivityService.Stub mBinder = new ITrustedWebActivityService.Stub(){

        @Override
        public Bundle areNotificationsEnabled(Bundle bundle) {
            this.checkCaller();
            TrustedWebActivityServiceConnection.NotificationsEnabledArgs args = TrustedWebActivityServiceConnection.NotificationsEnabledArgs.fromBundle(bundle);
            boolean result = TrustedWebActivityService.this.onAreNotificationsEnabled(args.channelName);
            return new TrustedWebActivityServiceConnection.ResultArgs(result).toBundle();
        }

        @Override
        @RequiresPermission(value="android.permission.POST_NOTIFICATIONS")
        public Bundle notifyNotificationWithChannel(Bundle bundle) {
            this.checkCaller();
            TrustedWebActivityServiceConnection.NotifyNotificationArgs args = TrustedWebActivityServiceConnection.NotifyNotificationArgs.fromBundle(bundle);
            boolean success = TrustedWebActivityService.this.onNotifyNotificationWithChannel(args.platformTag, args.platformId, args.notification, args.channelName);
            return new TrustedWebActivityServiceConnection.ResultArgs(success).toBundle();
        }

        @Override
        public void cancelNotification(Bundle bundle) {
            this.checkCaller();
            TrustedWebActivityServiceConnection.CancelNotificationArgs args = TrustedWebActivityServiceConnection.CancelNotificationArgs.fromBundle(bundle);
            TrustedWebActivityService.this.onCancelNotification(args.platformTag, args.platformId);
        }

        @Override
        public Bundle getActiveNotifications() {
            this.checkCaller();
            return new TrustedWebActivityServiceConnection.ActiveNotificationsArgs(TrustedWebActivityService.this.onGetActiveNotifications()).toBundle();
        }

        @Override
        public int getSmallIconId() {
            this.checkCaller();
            return TrustedWebActivityService.this.onGetSmallIconId();
        }

        @Override
        public Bundle getSmallIconBitmap() {
            this.checkCaller();
            return TrustedWebActivityService.this.onGetSmallIconBitmap();
        }

        @Override
        public Bundle extraCommand(String commandName, Bundle args, IBinder callback) {
            this.checkCaller();
            return TrustedWebActivityService.this.onExtraCommand(commandName, args, TrustedWebActivityCallbackRemote.fromBinder(callback));
        }

        private void checkCaller() {
            if (TrustedWebActivityService.this.mVerifiedUid == -1) {
                String[] packages = TrustedWebActivityService.this.getPackageManager().getPackagesForUid(1.getCallingUid());
                if (packages == null) {
                    packages = new String[]{};
                }
                Token verifiedProvider = TrustedWebActivityService.this.getTokenStore().load();
                PackageManager pm = TrustedWebActivityService.this.getPackageManager();
                if (verifiedProvider != null) {
                    for (String packageName : packages) {
                        if (!verifiedProvider.matches(packageName, pm)) continue;
                        TrustedWebActivityService.this.mVerifiedUid = 1.getCallingUid();
                        break;
                    }
                }
            }
            if (TrustedWebActivityService.this.mVerifiedUid == 1.getCallingUid()) {
                return;
            }
            throw new SecurityException("Caller is not verified as Trusted Web Activity provider.");
        }
    };

    @CallSuper
    @MainThread
    public void onCreate() {
        super.onCreate();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
    }

    @BinderThread
    public boolean onAreNotificationsEnabled(@NonNull String channelName) {
        this.ensureOnCreateCalled();
        if (!NotificationManagerCompat.from((Context)this).areNotificationsEnabled()) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        return NotificationApiHelperForO.isChannelEnabled(this.mNotificationManager, TrustedWebActivityService.channelNameToId(channelName));
    }

    @RequiresPermission(value="android.permission.POST_NOTIFICATIONS")
    @BinderThread
    public boolean onNotifyNotificationWithChannel(@NonNull String platformTag, int platformId, @NonNull Notification notification, @NonNull String channelName) {
        this.ensureOnCreateCalled();
        if (!NotificationManagerCompat.from((Context)this).areNotificationsEnabled()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = TrustedWebActivityService.channelNameToId(channelName);
            notification = NotificationApiHelperForO.copyNotificationOntoChannel((Context)this, this.mNotificationManager, notification, channelId, channelName);
            if (!NotificationApiHelperForO.isChannelEnabled(this.mNotificationManager, channelId)) {
                return false;
            }
        }
        this.mNotificationManager.notify(platformTag, platformId, notification);
        return true;
    }

    @BinderThread
    public void onCancelNotification(@NonNull String platformTag, int platformId) {
        this.ensureOnCreateCalled();
        this.mNotificationManager.cancel(platformTag, platformId);
    }

    @NonNull
    @BinderThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Parcelable[] onGetActiveNotifications() {
        this.ensureOnCreateCalled();
        if (Build.VERSION.SDK_INT >= 23) {
            return NotificationApiHelperForM.getActiveNotifications(this.mNotificationManager);
        }
        throw new IllegalStateException("onGetActiveNotifications cannot be called pre-M.");
    }

    @BinderThread
    @NonNull
    public Bundle onGetSmallIconBitmap() {
        int id2 = this.onGetSmallIconId();
        Bundle bundle = new Bundle();
        if (id2 == -1) {
            return bundle;
        }
        bundle.putParcelable(KEY_SMALL_ICON_BITMAP, (Parcelable)BitmapFactory.decodeResource((Resources)this.getResources(), (int)id2));
        return bundle;
    }

    @BinderThread
    public int onGetSmallIconId() {
        try {
            ServiceInfo info = this.getPackageManager().getServiceInfo(new ComponentName((Context)this, ((Object)((Object)this)).getClass()), 128);
            if (info.metaData == null) {
                return -1;
            }
            return info.metaData.getInt(META_DATA_NAME_SMALL_ICON, -1);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -1;
        }
    }

    @Nullable
    @MainThread
    public final IBinder onBind(@Nullable Intent intent) {
        return this.mBinder;
    }

    @MainThread
    public final boolean onUnbind(@Nullable Intent intent) {
        this.mVerifiedUid = -1;
        return super.onUnbind(intent);
    }

    @BinderThread
    @NonNull
    public abstract TokenStore getTokenStore();

    @BinderThread
    @Nullable
    public Bundle onExtraCommand(@NonNull String commandName, @NonNull Bundle args, @Nullable TrustedWebActivityCallbackRemote callbackRemote) {
        return null;
    }

    private static String channelNameToId(String name) {
        return name.toLowerCase(Locale.ROOT).replace(' ', '_') + "_channel_id";
    }

    private void ensureOnCreateCalled() {
        if (this.mNotificationManager != null) {
            return;
        }
        throw new IllegalStateException("TrustedWebActivityService has not been properly initialized. Did onCreate() call super.onCreate()?");
    }
}

