/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import androidx.core.util.Pools;
import androidx.recyclerview.widget.OpReorderer;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AdapterHelper
implements OpReorderer.Callback {
    static final int POSITION_TYPE_INVISIBLE = 0;
    static final int POSITION_TYPE_NEW_OR_LAID_OUT = 1;
    private static final boolean DEBUG = false;
    private static final String TAG = "AHT";
    private Pools.Pool<UpdateOp> mUpdateOpPool = new Pools.SimplePool(30);
    final ArrayList<UpdateOp> mPendingUpdates = new ArrayList();
    final ArrayList<UpdateOp> mPostponedList = new ArrayList();
    final Callback mCallback;
    Runnable mOnItemProcessedCallback;
    final boolean mDisableRecycler;
    final OpReorderer mOpReorderer;
    private int mExistingUpdateTypes = 0;

    AdapterHelper(Callback callback) {
        this(callback, false);
    }

    AdapterHelper(Callback callback, boolean disableRecycler) {
        this.mCallback = callback;
        this.mDisableRecycler = disableRecycler;
        this.mOpReorderer = new OpReorderer(this);
    }

    AdapterHelper addUpdateOp(UpdateOp ... ops) {
        Collections.addAll(this.mPendingUpdates, ops);
        return this;
    }

    void reset() {
        this.recycleUpdateOpsAndClearList(this.mPendingUpdates);
        this.recycleUpdateOpsAndClearList(this.mPostponedList);
        this.mExistingUpdateTypes = 0;
    }

    void preProcess() {
        this.mOpReorderer.reorderOps(this.mPendingUpdates);
        int count = this.mPendingUpdates.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    this.applyAdd(op);
                    break;
                }
                case 2: {
                    this.applyRemove(op);
                    break;
                }
                case 4: {
                    this.applyUpdate(op);
                    break;
                }
                case 8: {
                    this.applyMove(op);
                }
            }
            if (this.mOnItemProcessedCallback == null) continue;
            this.mOnItemProcessedCallback.run();
        }
        this.mPendingUpdates.clear();
    }

    void consumePostponedUpdates() {
        int count = this.mPostponedList.size();
        for (int i = 0; i < count; ++i) {
            this.mCallback.onDispatchSecondPass(this.mPostponedList.get(i));
        }
        this.recycleUpdateOpsAndClearList(this.mPostponedList);
        this.mExistingUpdateTypes = 0;
    }

    private void applyMove(UpdateOp op) {
        this.postponeAndUpdateViewHolders(op);
    }

    private void applyRemove(UpdateOp op) {
        int tmpStart = op.positionStart;
        int tmpCount = 0;
        int tmpEnd = op.positionStart + op.itemCount;
        int type = -1;
        for (int position = op.positionStart; position < tmpEnd; ++position) {
            UpdateOp newOp;
            boolean typeChanged = false;
            RecyclerView.ViewHolder vh = this.mCallback.findViewHolder(position);
            if (vh != null || this.canFindInPreLayout(position)) {
                if (type == 0) {
                    newOp = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
                    this.dispatchAndUpdateViewHolders(newOp);
                    typeChanged = true;
                }
                type = 1;
            } else {
                if (type == 1) {
                    newOp = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
                    this.postponeAndUpdateViewHolders(newOp);
                    typeChanged = true;
                }
                type = 0;
            }
            if (typeChanged) {
                position -= tmpCount;
                tmpEnd -= tmpCount;
                tmpCount = 1;
                continue;
            }
            ++tmpCount;
        }
        if (tmpCount != op.itemCount) {
            this.recycleUpdateOp(op);
            op = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
        }
        if (type == 0) {
            this.dispatchAndUpdateViewHolders(op);
        } else {
            this.postponeAndUpdateViewHolders(op);
        }
    }

    private void applyUpdate(UpdateOp op) {
        int tmpStart = op.positionStart;
        int tmpCount = 0;
        int tmpEnd = op.positionStart + op.itemCount;
        int type = -1;
        for (int position = op.positionStart; position < tmpEnd; ++position) {
            UpdateOp newOp;
            RecyclerView.ViewHolder vh = this.mCallback.findViewHolder(position);
            if (vh != null || this.canFindInPreLayout(position)) {
                if (type == 0) {
                    newOp = this.obtainUpdateOp(4, tmpStart, tmpCount, op.payload);
                    this.dispatchAndUpdateViewHolders(newOp);
                    tmpCount = 0;
                    tmpStart = position;
                }
                type = 1;
            } else {
                if (type == 1) {
                    newOp = this.obtainUpdateOp(4, tmpStart, tmpCount, op.payload);
                    this.postponeAndUpdateViewHolders(newOp);
                    tmpCount = 0;
                    tmpStart = position;
                }
                type = 0;
            }
            ++tmpCount;
        }
        if (tmpCount != op.itemCount) {
            Object payload = op.payload;
            this.recycleUpdateOp(op);
            op = this.obtainUpdateOp(4, tmpStart, tmpCount, payload);
        }
        if (type == 0) {
            this.dispatchAndUpdateViewHolders(op);
        } else {
            this.postponeAndUpdateViewHolders(op);
        }
    }

    private void dispatchAndUpdateViewHolders(UpdateOp op) {
        int positionMultiplier;
        if (op.cmd == 1 || op.cmd == 8) {
            throw new IllegalArgumentException("should not dispatch add or move for pre layout");
        }
        int tmpStart = this.updatePositionWithPostponed(op.positionStart, op.cmd);
        int tmpCnt = 1;
        int offsetPositionForPartial = op.positionStart;
        switch (op.cmd) {
            case 4: {
                positionMultiplier = 1;
                break;
            }
            case 2: {
                positionMultiplier = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("op should be remove or update." + op);
            }
        }
        for (int p = 1; p < op.itemCount; ++p) {
            int pos = op.positionStart + positionMultiplier * p;
            int updatedPos = this.updatePositionWithPostponed(pos, op.cmd);
            boolean continuous = false;
            switch (op.cmd) {
                case 4: {
                    continuous = updatedPos == tmpStart + 1;
                    break;
                }
                case 2: {
                    boolean bl = continuous = updatedPos == tmpStart;
                }
            }
            if (continuous) {
                ++tmpCnt;
                continue;
            }
            UpdateOp tmp = this.obtainUpdateOp(op.cmd, tmpStart, tmpCnt, op.payload);
            this.dispatchFirstPassAndUpdateViewHolders(tmp, offsetPositionForPartial);
            this.recycleUpdateOp(tmp);
            if (op.cmd == 4) {
                offsetPositionForPartial += tmpCnt;
            }
            tmpStart = updatedPos;
            tmpCnt = 1;
        }
        Object payload = op.payload;
        this.recycleUpdateOp(op);
        if (tmpCnt > 0) {
            UpdateOp tmp = this.obtainUpdateOp(op.cmd, tmpStart, tmpCnt, payload);
            this.dispatchFirstPassAndUpdateViewHolders(tmp, offsetPositionForPartial);
            this.recycleUpdateOp(tmp);
        }
    }

    void dispatchFirstPassAndUpdateViewHolders(UpdateOp op, int offsetStart) {
        this.mCallback.onDispatchFirstPass(op);
        switch (op.cmd) {
            case 2: {
                this.mCallback.offsetPositionsForRemovingInvisible(offsetStart, op.itemCount);
                break;
            }
            case 4: {
                this.mCallback.markViewHoldersUpdated(offsetStart, op.itemCount, op.payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("only remove and update ops can be dispatched in first pass");
            }
        }
    }

    private int updatePositionWithPostponed(int pos, int cmd) {
        int i;
        int count = this.mPostponedList.size();
        for (i = count - 1; i >= 0; --i) {
            UpdateOp postponed = this.mPostponedList.get(i);
            if (postponed.cmd == 8) {
                int end;
                int start;
                if (postponed.positionStart < postponed.itemCount) {
                    start = postponed.positionStart;
                    end = postponed.itemCount;
                } else {
                    start = postponed.itemCount;
                    end = postponed.positionStart;
                }
                if (pos >= start && pos <= end) {
                    if (start == postponed.positionStart) {
                        if (cmd == 1) {
                            ++postponed.itemCount;
                        } else if (cmd == 2) {
                            --postponed.itemCount;
                        }
                        ++pos;
                        continue;
                    }
                    if (cmd == 1) {
                        ++postponed.positionStart;
                    } else if (cmd == 2) {
                        --postponed.positionStart;
                    }
                    --pos;
                    continue;
                }
                if (pos >= postponed.positionStart) continue;
                if (cmd == 1) {
                    ++postponed.positionStart;
                    ++postponed.itemCount;
                    continue;
                }
                if (cmd != 2) continue;
                --postponed.positionStart;
                --postponed.itemCount;
                continue;
            }
            if (postponed.positionStart <= pos) {
                if (postponed.cmd == 1) {
                    pos -= postponed.itemCount;
                    continue;
                }
                if (postponed.cmd != 2) continue;
                pos += postponed.itemCount;
                continue;
            }
            if (cmd == 1) {
                ++postponed.positionStart;
                continue;
            }
            if (cmd != 2) continue;
            --postponed.positionStart;
        }
        for (i = this.mPostponedList.size() - 1; i >= 0; --i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (op.itemCount != op.positionStart && op.itemCount >= 0) continue;
                this.mPostponedList.remove(i);
                this.recycleUpdateOp(op);
                continue;
            }
            if (op.itemCount > 0) continue;
            this.mPostponedList.remove(i);
            this.recycleUpdateOp(op);
        }
        return pos;
    }

    private boolean canFindInPreLayout(int position) {
        int count = this.mPostponedList.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (this.findPositionOffset(op.itemCount, i + 1) != position) continue;
                return true;
            }
            if (op.cmd != 1) continue;
            int end = op.positionStart + op.itemCount;
            for (int pos = op.positionStart; pos < end; ++pos) {
                if (this.findPositionOffset(pos, i + 1) != position) continue;
                return true;
            }
        }
        return false;
    }

    private void applyAdd(UpdateOp op) {
        this.postponeAndUpdateViewHolders(op);
    }

    private void postponeAndUpdateViewHolders(UpdateOp op) {
        this.mPostponedList.add(op);
        switch (op.cmd) {
            case 1: {
                this.mCallback.offsetPositionsForAdd(op.positionStart, op.itemCount);
                break;
            }
            case 8: {
                this.mCallback.offsetPositionsForMove(op.positionStart, op.itemCount);
                break;
            }
            case 2: {
                this.mCallback.offsetPositionsForRemovingLaidOutOrNewView(op.positionStart, op.itemCount);
                break;
            }
            case 4: {
                this.mCallback.markViewHoldersUpdated(op.positionStart, op.itemCount, op.payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update op type for " + op);
            }
        }
    }

    boolean hasPendingUpdates() {
        return this.mPendingUpdates.size() > 0;
    }

    boolean hasAnyUpdateTypes(int updateTypes) {
        return (this.mExistingUpdateTypes & updateTypes) != 0;
    }

    int findPositionOffset(int position) {
        return this.findPositionOffset(position, 0);
    }

    int findPositionOffset(int position, int firstPostponedItem) {
        int count = this.mPostponedList.size();
        for (int i = firstPostponedItem; i < count; ++i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (op.positionStart == position) {
                    position = op.itemCount;
                    continue;
                }
                if (op.positionStart < position) {
                    --position;
                }
                if (op.itemCount > position) continue;
                ++position;
                continue;
            }
            if (op.positionStart > position) continue;
            if (op.cmd == 2) {
                if (position < op.positionStart + op.itemCount) {
                    return -1;
                }
                position -= op.itemCount;
                continue;
            }
            if (op.cmd != 1) continue;
            position += op.itemCount;
        }
        return position;
    }

    boolean onItemRangeChanged(int positionStart, int itemCount, Object payload) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(4, positionStart, itemCount, payload));
        this.mExistingUpdateTypes |= 4;
        return this.mPendingUpdates.size() == 1;
    }

    boolean onItemRangeInserted(int positionStart, int itemCount) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(1, positionStart, itemCount, null));
        this.mExistingUpdateTypes |= 1;
        return this.mPendingUpdates.size() == 1;
    }

    boolean onItemRangeRemoved(int positionStart, int itemCount) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(2, positionStart, itemCount, null));
        this.mExistingUpdateTypes |= 2;
        return this.mPendingUpdates.size() == 1;
    }

    boolean onItemRangeMoved(int from, int to, int itemCount) {
        if (from == to) {
            return false;
        }
        if (itemCount != 1) {
            throw new IllegalArgumentException("Moving more than 1 item is not supported yet");
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(8, from, to, null));
        this.mExistingUpdateTypes |= 8;
        return this.mPendingUpdates.size() == 1;
    }

    void consumeUpdatesInOnePass() {
        this.consumePostponedUpdates();
        int count = this.mPendingUpdates.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForAdd(op.positionStart, op.itemCount);
                    break;
                }
                case 2: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForRemovingInvisible(op.positionStart, op.itemCount);
                    break;
                }
                case 4: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.markViewHoldersUpdated(op.positionStart, op.itemCount, op.payload);
                    break;
                }
                case 8: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForMove(op.positionStart, op.itemCount);
                }
            }
            if (this.mOnItemProcessedCallback == null) continue;
            this.mOnItemProcessedCallback.run();
        }
        this.recycleUpdateOpsAndClearList(this.mPendingUpdates);
        this.mExistingUpdateTypes = 0;
    }

    public int applyPendingUpdatesToPosition(int position) {
        int size = this.mPendingUpdates.size();
        block5: for (int i = 0; i < size; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    if (op.positionStart > position) continue block5;
                    position += op.itemCount;
                    continue block5;
                }
                case 2: {
                    if (op.positionStart > position) continue block5;
                    int end = op.positionStart + op.itemCount;
                    if (end > position) {
                        return -1;
                    }
                    position -= op.itemCount;
                    continue block5;
                }
                case 8: {
                    if (op.positionStart == position) {
                        position = op.itemCount;
                        continue block5;
                    }
                    if (op.positionStart < position) {
                        --position;
                    }
                    if (op.itemCount > position) continue block5;
                    ++position;
                }
            }
        }
        return position;
    }

    boolean hasUpdates() {
        return !this.mPostponedList.isEmpty() && !this.mPendingUpdates.isEmpty();
    }

    @Override
    public UpdateOp obtainUpdateOp(int cmd, int positionStart, int itemCount, Object payload) {
        UpdateOp op = (UpdateOp)this.mUpdateOpPool.acquire();
        if (op == null) {
            op = new UpdateOp(cmd, positionStart, itemCount, payload);
        } else {
            op.cmd = cmd;
            op.positionStart = positionStart;
            op.itemCount = itemCount;
            op.payload = payload;
        }
        return op;
    }

    @Override
    public void recycleUpdateOp(UpdateOp op) {
        if (!this.mDisableRecycler) {
            op.payload = null;
            this.mUpdateOpPool.release((Object)op);
        }
    }

    void recycleUpdateOpsAndClearList(List<UpdateOp> ops) {
        int count = ops.size();
        for (int i = 0; i < count; ++i) {
            this.recycleUpdateOp(ops.get(i));
        }
        ops.clear();
    }

    static interface Callback {
        public RecyclerView.ViewHolder findViewHolder(int var1);

        public void offsetPositionsForRemovingInvisible(int var1, int var2);

        public void offsetPositionsForRemovingLaidOutOrNewView(int var1, int var2);

        public void markViewHoldersUpdated(int var1, int var2, Object var3);

        public void onDispatchFirstPass(UpdateOp var1);

        public void onDispatchSecondPass(UpdateOp var1);

        public void offsetPositionsForAdd(int var1, int var2);

        public void offsetPositionsForMove(int var1, int var2);
    }

    static final class UpdateOp {
        static final int ADD = 1;
        static final int REMOVE = 2;
        static final int UPDATE = 4;
        static final int MOVE = 8;
        static final int POOL_SIZE = 30;
        int cmd;
        int positionStart;
        Object payload;
        int itemCount;

        UpdateOp(int cmd, int positionStart, int itemCount, Object payload) {
            this.cmd = cmd;
            this.positionStart = positionStart;
            this.itemCount = itemCount;
            this.payload = payload;
        }

        String cmdToString() {
            switch (this.cmd) {
                case 1: {
                    return "add";
                }
                case 2: {
                    return "rm";
                }
                case 4: {
                    return "up";
                }
                case 8: {
                    return "mv";
                }
            }
            return "??";
        }

        public String toString() {
            return Integer.toHexString(System.identityHashCode(this)) + "[" + this.cmdToString() + ",s:" + this.positionStart + "c:" + this.itemCount + ",p:" + this.payload + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateOp)) {
                return false;
            }
            UpdateOp op = (UpdateOp)o;
            if (this.cmd != op.cmd) {
                return false;
            }
            if (this.cmd == 8 && Math.abs(this.itemCount - this.positionStart) == 1 && this.itemCount == op.positionStart && this.positionStart == op.itemCount) {
                return true;
            }
            if (this.itemCount != op.itemCount) {
                return false;
            }
            if (this.positionStart != op.positionStart) {
                return false;
            }
            return !(this.payload != null ? !this.payload.equals(op.payload) : op.payload != null);
        }

        public int hashCode() {
            int result = this.cmd;
            result = 31 * result + this.positionStart;
            result = 31 * result + this.itemCount;
            return result;
        }
    }
}

