/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.util.Log;
import android.util.Pair;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.NestedAdapterWrapper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StableIdStorage;
import androidx.recyclerview.widget.ViewTypeStorage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;

class ConcatAdapterController
implements NestedAdapterWrapper.Callback {
    private final ConcatAdapter mConcatAdapter;
    private final ViewTypeStorage mViewTypeStorage;
    private List<WeakReference<RecyclerView>> mAttachedRecyclerViews = new ArrayList<WeakReference<RecyclerView>>();
    private final IdentityHashMap<RecyclerView.ViewHolder, NestedAdapterWrapper> mBinderLookup = new IdentityHashMap();
    private List<NestedAdapterWrapper> mWrappers = new ArrayList<NestedAdapterWrapper>();
    private WrapperAndLocalPosition mReusableHolder = new WrapperAndLocalPosition();
    @NonNull
    private final ConcatAdapter.Config.StableIdMode mStableIdMode;
    private final StableIdStorage mStableIdStorage;

    ConcatAdapterController(ConcatAdapter concatAdapter, ConcatAdapter.Config config) {
        this.mConcatAdapter = concatAdapter;
        this.mViewTypeStorage = config.isolateViewTypes ? new ViewTypeStorage.IsolatedViewTypeStorage() : new ViewTypeStorage.SharedIdRangeViewTypeStorage();
        this.mStableIdMode = config.stableIdMode;
        if (config.stableIdMode == ConcatAdapter.Config.StableIdMode.NO_STABLE_IDS) {
            this.mStableIdStorage = new StableIdStorage.NoStableIdStorage();
        } else if (config.stableIdMode == ConcatAdapter.Config.StableIdMode.ISOLATED_STABLE_IDS) {
            this.mStableIdStorage = new StableIdStorage.IsolatedStableIdStorage();
        } else if (config.stableIdMode == ConcatAdapter.Config.StableIdMode.SHARED_STABLE_IDS) {
            this.mStableIdStorage = new StableIdStorage.SharedPoolStableIdStorage();
        } else {
            throw new IllegalArgumentException("unknown stable id mode");
        }
    }

    @Nullable
    private NestedAdapterWrapper findWrapperFor(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        int index = this.indexOfWrapper(adapter);
        if (index == -1) {
            return null;
        }
        return this.mWrappers.get(index);
    }

    private int indexOfWrapper(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        int limit = this.mWrappers.size();
        for (int i = 0; i < limit; ++i) {
            if (this.mWrappers.get((int)i).adapter != adapter) continue;
            return i;
        }
        return -1;
    }

    boolean addAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        return this.addAdapter(this.mWrappers.size(), adapter);
    }

    boolean addAdapter(int index, RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        if (index < 0 || index > this.mWrappers.size()) {
            throw new IndexOutOfBoundsException("Index must be between 0 and " + this.mWrappers.size() + ". Given:" + index);
        }
        if (this.hasStableIds()) {
            Preconditions.checkArgument((boolean)adapter.hasStableIds(), (Object)"All sub adapters must have stable ids when stable id mode is ISOLATED_STABLE_IDS or SHARED_STABLE_IDS");
        } else if (adapter.hasStableIds()) {
            Log.w((String)"ConcatAdapter", (String)"Stable ids in the adapter will be ignored as the ConcatAdapter is configured not to have stable ids");
        }
        NestedAdapterWrapper existing = this.findWrapperFor(adapter);
        if (existing != null) {
            return false;
        }
        NestedAdapterWrapper wrapper = new NestedAdapterWrapper(adapter, this, this.mViewTypeStorage, this.mStableIdStorage.createStableIdLookup());
        this.mWrappers.add(index, wrapper);
        for (WeakReference<RecyclerView> reference : this.mAttachedRecyclerViews) {
            RecyclerView recyclerView = (RecyclerView)((Object)reference.get());
            if (recyclerView == null) continue;
            adapter.onAttachedToRecyclerView(recyclerView);
        }
        if (wrapper.getCachedItemCount() > 0) {
            this.mConcatAdapter.notifyItemRangeInserted(this.countItemsBefore(wrapper), wrapper.getCachedItemCount());
        }
        this.calculateAndUpdateStateRestorationPolicy();
        return true;
    }

    boolean removeAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        int index = this.indexOfWrapper(adapter);
        if (index == -1) {
            return false;
        }
        NestedAdapterWrapper wrapper = this.mWrappers.get(index);
        int offset = this.countItemsBefore(wrapper);
        this.mWrappers.remove(index);
        this.mConcatAdapter.notifyItemRangeRemoved(offset, wrapper.getCachedItemCount());
        for (WeakReference<RecyclerView> reference : this.mAttachedRecyclerViews) {
            RecyclerView recyclerView = (RecyclerView)((Object)reference.get());
            if (recyclerView == null) continue;
            adapter.onDetachedFromRecyclerView(recyclerView);
        }
        wrapper.dispose();
        this.calculateAndUpdateStateRestorationPolicy();
        return true;
    }

    private int countItemsBefore(NestedAdapterWrapper wrapper) {
        int count = 0;
        for (NestedAdapterWrapper item : this.mWrappers) {
            if (item == wrapper) break;
            count += item.getCachedItemCount();
        }
        return count;
    }

    public long getItemId(int globalPosition) {
        WrapperAndLocalPosition wrapperAndPos = this.findWrapperAndLocalPosition(globalPosition);
        long globalItemId = wrapperAndPos.mWrapper.getItemId(wrapperAndPos.mLocalPosition);
        this.releaseWrapperAndLocalPosition(wrapperAndPos);
        return globalItemId;
    }

    @Override
    public void onChanged(@NonNull NestedAdapterWrapper wrapper) {
        this.mConcatAdapter.notifyDataSetChanged();
        this.calculateAndUpdateStateRestorationPolicy();
    }

    @Override
    public void onItemRangeChanged(@NonNull NestedAdapterWrapper nestedAdapterWrapper, int positionStart, int itemCount) {
        int offset = this.countItemsBefore(nestedAdapterWrapper);
        this.mConcatAdapter.notifyItemRangeChanged(positionStart + offset, itemCount);
    }

    @Override
    public void onItemRangeChanged(@NonNull NestedAdapterWrapper nestedAdapterWrapper, int positionStart, int itemCount, @Nullable Object payload) {
        int offset = this.countItemsBefore(nestedAdapterWrapper);
        this.mConcatAdapter.notifyItemRangeChanged(positionStart + offset, itemCount, payload);
    }

    @Override
    public void onItemRangeInserted(@NonNull NestedAdapterWrapper nestedAdapterWrapper, int positionStart, int itemCount) {
        int offset = this.countItemsBefore(nestedAdapterWrapper);
        this.mConcatAdapter.notifyItemRangeInserted(positionStart + offset, itemCount);
    }

    @Override
    public void onItemRangeRemoved(@NonNull NestedAdapterWrapper nestedAdapterWrapper, int positionStart, int itemCount) {
        int offset = this.countItemsBefore(nestedAdapterWrapper);
        this.mConcatAdapter.notifyItemRangeRemoved(positionStart + offset, itemCount);
    }

    @Override
    public void onItemRangeMoved(@NonNull NestedAdapterWrapper nestedAdapterWrapper, int fromPosition, int toPosition) {
        int offset = this.countItemsBefore(nestedAdapterWrapper);
        this.mConcatAdapter.notifyItemMoved(fromPosition + offset, toPosition + offset);
    }

    @Override
    public void onStateRestorationPolicyChanged(NestedAdapterWrapper nestedAdapterWrapper) {
        this.calculateAndUpdateStateRestorationPolicy();
    }

    private void calculateAndUpdateStateRestorationPolicy() {
        RecyclerView.Adapter.StateRestorationPolicy newPolicy = this.computeStateRestorationPolicy();
        if (newPolicy != this.mConcatAdapter.getStateRestorationPolicy()) {
            this.mConcatAdapter.internalSetStateRestorationPolicy(newPolicy);
        }
    }

    private RecyclerView.Adapter.StateRestorationPolicy computeStateRestorationPolicy() {
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            RecyclerView.Adapter.StateRestorationPolicy strategy = wrapper.adapter.getStateRestorationPolicy();
            if (strategy == RecyclerView.Adapter.StateRestorationPolicy.PREVENT) {
                return RecyclerView.Adapter.StateRestorationPolicy.PREVENT;
            }
            if (strategy != RecyclerView.Adapter.StateRestorationPolicy.PREVENT_WHEN_EMPTY || wrapper.getCachedItemCount() != 0) continue;
            return RecyclerView.Adapter.StateRestorationPolicy.PREVENT;
        }
        return RecyclerView.Adapter.StateRestorationPolicy.ALLOW;
    }

    public int getTotalCount() {
        int total = 0;
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            total += wrapper.getCachedItemCount();
        }
        return total;
    }

    public int getItemViewType(int globalPosition) {
        WrapperAndLocalPosition wrapperAndPos = this.findWrapperAndLocalPosition(globalPosition);
        int itemViewType = wrapperAndPos.mWrapper.getItemViewType(wrapperAndPos.mLocalPosition);
        this.releaseWrapperAndLocalPosition(wrapperAndPos);
        return itemViewType;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int globalViewType) {
        NestedAdapterWrapper wrapper = this.mViewTypeStorage.getWrapperForGlobalType(globalViewType);
        return wrapper.onCreateViewHolder(parent, globalViewType);
    }

    public Pair<RecyclerView.Adapter<? extends RecyclerView.ViewHolder>, Integer> getWrappedAdapterAndPosition(int globalPosition) {
        WrapperAndLocalPosition wrapper = this.findWrapperAndLocalPosition(globalPosition);
        Pair pair = new Pair(wrapper.mWrapper.adapter, (Object)wrapper.mLocalPosition);
        this.releaseWrapperAndLocalPosition(wrapper);
        return pair;
    }

    @NonNull
    private WrapperAndLocalPosition findWrapperAndLocalPosition(int globalPosition) {
        WrapperAndLocalPosition result;
        if (this.mReusableHolder.mInUse) {
            result = new WrapperAndLocalPosition();
        } else {
            this.mReusableHolder.mInUse = true;
            result = this.mReusableHolder;
        }
        int localPosition = globalPosition;
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            if (wrapper.getCachedItemCount() > localPosition) {
                result.mWrapper = wrapper;
                result.mLocalPosition = localPosition;
                break;
            }
            localPosition -= wrapper.getCachedItemCount();
        }
        if (result.mWrapper == null) {
            throw new IllegalArgumentException("Cannot find wrapper for " + globalPosition);
        }
        return result;
    }

    private void releaseWrapperAndLocalPosition(WrapperAndLocalPosition wrapperAndLocalPosition) {
        wrapperAndLocalPosition.mInUse = false;
        wrapperAndLocalPosition.mWrapper = null;
        wrapperAndLocalPosition.mLocalPosition = -1;
        this.mReusableHolder = wrapperAndLocalPosition;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int globalPosition) {
        WrapperAndLocalPosition wrapperAndPos = this.findWrapperAndLocalPosition(globalPosition);
        this.mBinderLookup.put(holder, wrapperAndPos.mWrapper);
        wrapperAndPos.mWrapper.onBindViewHolder(holder, wrapperAndPos.mLocalPosition);
        this.releaseWrapperAndLocalPosition(wrapperAndPos);
    }

    public boolean canRestoreState() {
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            if (wrapper.adapter.canRestoreState()) continue;
            return false;
        }
        return true;
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        NestedAdapterWrapper wrapper = this.getWrapper(holder);
        wrapper.adapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        NestedAdapterWrapper wrapper = this.getWrapper(holder);
        wrapper.adapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        NestedAdapterWrapper wrapper = this.mBinderLookup.get(holder);
        if (wrapper == null) {
            throw new IllegalStateException("Cannot find wrapper for " + holder + ", seems like it is not bound by this adapter: " + this);
        }
        wrapper.adapter.onViewRecycled(holder);
        this.mBinderLookup.remove(holder);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        NestedAdapterWrapper wrapper = this.mBinderLookup.get(holder);
        if (wrapper == null) {
            throw new IllegalStateException("Cannot find wrapper for " + holder + ", seems like it is not bound by this adapter: " + this);
        }
        boolean result = wrapper.adapter.onFailedToRecycleView(holder);
        this.mBinderLookup.remove(holder);
        return result;
    }

    @NonNull
    private NestedAdapterWrapper getWrapper(RecyclerView.ViewHolder holder) {
        NestedAdapterWrapper wrapper = this.mBinderLookup.get(holder);
        if (wrapper == null) {
            throw new IllegalStateException("Cannot find wrapper for " + holder + ", seems like it is not bound by this adapter: " + this);
        }
        return wrapper;
    }

    private boolean isAttachedTo(RecyclerView recyclerView) {
        for (WeakReference<RecyclerView> reference : this.mAttachedRecyclerViews) {
            if (reference.get() != recyclerView) continue;
            return true;
        }
        return false;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.isAttachedTo(recyclerView)) {
            return;
        }
        this.mAttachedRecyclerViews.add(new WeakReference<RecyclerView>(recyclerView));
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            wrapper.adapter.onAttachedToRecyclerView(recyclerView);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        for (int i = this.mAttachedRecyclerViews.size() - 1; i >= 0; --i) {
            WeakReference<RecyclerView> reference = this.mAttachedRecyclerViews.get(i);
            if (reference.get() == null) {
                this.mAttachedRecyclerViews.remove(i);
                continue;
            }
            if (reference.get() != recyclerView) continue;
            this.mAttachedRecyclerViews.remove(i);
            break;
        }
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            wrapper.adapter.onDetachedFromRecyclerView(recyclerView);
        }
    }

    public int getLocalAdapterPosition(RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter, RecyclerView.ViewHolder viewHolder, int globalPosition) {
        NestedAdapterWrapper wrapper = this.mBinderLookup.get(viewHolder);
        if (wrapper == null) {
            return -1;
        }
        int itemsBefore = this.countItemsBefore(wrapper);
        int localPosition = globalPosition - itemsBefore;
        int itemCount = wrapper.adapter.getItemCount();
        if (localPosition < 0 || localPosition >= itemCount) {
            throw new IllegalStateException("Detected inconsistent adapter updates. The local position of the view holder maps to " + localPosition + " which is out of bounds for the adapter with size " + itemCount + ".Make sure to immediately call notify methods in your adapter when you change the backing dataviewHolder:" + viewHolder + "adapter:" + adapter);
        }
        return wrapper.adapter.findRelativeAdapterPositionIn(adapter, viewHolder, localPosition);
    }

    @Nullable
    public RecyclerView.Adapter<? extends RecyclerView.ViewHolder> getBoundAdapter(RecyclerView.ViewHolder viewHolder) {
        NestedAdapterWrapper wrapper = this.mBinderLookup.get(viewHolder);
        if (wrapper == null) {
            return null;
        }
        return wrapper.adapter;
    }

    public List<RecyclerView.Adapter<? extends RecyclerView.ViewHolder>> getCopyOfAdapters() {
        if (this.mWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RecyclerView.Adapter<? extends RecyclerView.ViewHolder>> adapters = new ArrayList<RecyclerView.Adapter<? extends RecyclerView.ViewHolder>>(this.mWrappers.size());
        for (NestedAdapterWrapper wrapper : this.mWrappers) {
            adapters.add(wrapper.adapter);
        }
        return adapters;
    }

    public boolean hasStableIds() {
        return this.mStableIdMode != ConcatAdapter.Config.StableIdMode.NO_STABLE_IDS;
    }

    static class WrapperAndLocalPosition {
        NestedAdapterWrapper mWrapper;
        int mLocalPosition;
        boolean mInUse;

        WrapperAndLocalPosition() {
        }
    }
}

