/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.annotation.SuppressLint;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public abstract class SimpleItemAnimator
extends RecyclerView.ItemAnimator {
    private static final boolean DEBUG = false;
    private static final String TAG = "SimpleItemAnimator";
    boolean mSupportsChangeAnimations = true;

    public boolean getSupportsChangeAnimations() {
        return this.mSupportsChangeAnimations;
    }

    public void setSupportsChangeAnimations(boolean supportsChangeAnimations) {
        this.mSupportsChangeAnimations = supportsChangeAnimations;
    }

    @Override
    public boolean canReuseUpdatedViewHolder(@NonNull RecyclerView.ViewHolder viewHolder) {
        return !this.mSupportsChangeAnimations || viewHolder.isInvalid();
    }

    @Override
    public boolean animateDisappearance(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, @Nullable RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        int newTop;
        int oldLeft = preLayoutInfo.left;
        int oldTop = preLayoutInfo.top;
        View disappearingItemView = viewHolder.itemView;
        int newLeft = postLayoutInfo == null ? disappearingItemView.getLeft() : postLayoutInfo.left;
        int n = newTop = postLayoutInfo == null ? disappearingItemView.getTop() : postLayoutInfo.top;
        if (!(viewHolder.isRemoved() || oldLeft == newLeft && oldTop == newTop)) {
            disappearingItemView.layout(newLeft, newTop, newLeft + disappearingItemView.getWidth(), newTop + disappearingItemView.getHeight());
            return this.animateMove(viewHolder, oldLeft, oldTop, newLeft, newTop);
        }
        return this.animateRemove(viewHolder);
    }

    @Override
    public boolean animateAppearance(@NonNull RecyclerView.ViewHolder viewHolder, @Nullable RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        if (preLayoutInfo != null && (preLayoutInfo.left != postLayoutInfo.left || preLayoutInfo.top != postLayoutInfo.top)) {
            return this.animateMove(viewHolder, preLayoutInfo.left, preLayoutInfo.top, postLayoutInfo.left, postLayoutInfo.top);
        }
        return this.animateAdd(viewHolder);
    }

    @Override
    public boolean animatePersistence(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        if (preLayoutInfo.left != postLayoutInfo.left || preLayoutInfo.top != postLayoutInfo.top) {
            return this.animateMove(viewHolder, preLayoutInfo.left, preLayoutInfo.top, postLayoutInfo.left, postLayoutInfo.top);
        }
        this.dispatchMoveFinished(viewHolder);
        return false;
    }

    @Override
    public boolean animateChange(@NonNull RecyclerView.ViewHolder oldHolder, @NonNull RecyclerView.ViewHolder newHolder, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        int toTop;
        int toLeft;
        int fromLeft = preLayoutInfo.left;
        int fromTop = preLayoutInfo.top;
        if (newHolder.shouldIgnore()) {
            toLeft = preLayoutInfo.left;
            toTop = preLayoutInfo.top;
        } else {
            toLeft = postLayoutInfo.left;
            toTop = postLayoutInfo.top;
        }
        return this.animateChange(oldHolder, newHolder, fromLeft, fromTop, toLeft, toTop);
    }

    @SuppressLint(value={"UnknownNullness"})
    public abstract boolean animateRemove(RecyclerView.ViewHolder var1);

    @SuppressLint(value={"UnknownNullness"})
    public abstract boolean animateAdd(RecyclerView.ViewHolder var1);

    @SuppressLint(value={"UnknownNullness"})
    public abstract boolean animateMove(RecyclerView.ViewHolder var1, int var2, int var3, int var4, int var5);

    @SuppressLint(value={"UnknownNullness"})
    public abstract boolean animateChange(RecyclerView.ViewHolder var1, RecyclerView.ViewHolder var2, int var3, int var4, int var5, int var6);

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchRemoveFinished(RecyclerView.ViewHolder item) {
        this.onRemoveFinished(item);
        this.dispatchAnimationFinished(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchMoveFinished(RecyclerView.ViewHolder item) {
        this.onMoveFinished(item);
        this.dispatchAnimationFinished(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchAddFinished(RecyclerView.ViewHolder item) {
        this.onAddFinished(item);
        this.dispatchAnimationFinished(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchChangeFinished(RecyclerView.ViewHolder item, boolean oldItem) {
        this.onChangeFinished(item, oldItem);
        this.dispatchAnimationFinished(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchRemoveStarting(RecyclerView.ViewHolder item) {
        this.onRemoveStarting(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchMoveStarting(RecyclerView.ViewHolder item) {
        this.onMoveStarting(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchAddStarting(RecyclerView.ViewHolder item) {
        this.onAddStarting(item);
    }

    @SuppressLint(value={"UnknownNullness"})
    public final void dispatchChangeStarting(RecyclerView.ViewHolder item, boolean oldItem) {
        this.onChangeStarting(item, oldItem);
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onRemoveStarting(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onRemoveFinished(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onAddStarting(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onAddFinished(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onMoveStarting(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onMoveFinished(RecyclerView.ViewHolder item) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onChangeStarting(RecyclerView.ViewHolder item, boolean oldItem) {
    }

    @SuppressLint(value={"UnknownNullness"})
    public void onChangeFinished(RecyclerView.ViewHolder item, boolean oldItem) {
    }
}

