/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.graphics.Rect;
import android.text.method.TransformationMethod;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class EmojiTransformationMethod
implements TransformationMethod {
    @Nullable
    private final TransformationMethod mTransformationMethod;

    EmojiTransformationMethod(@Nullable TransformationMethod transformationMethod) {
        this.mTransformationMethod = transformationMethod;
    }

    public CharSequence getTransformation(@Nullable CharSequence source, @NonNull View view) {
        if (view.isInEditMode()) {
            return source;
        }
        if (this.mTransformationMethod != null) {
            source = this.mTransformationMethod.getTransformation(source, view);
        }
        if (source != null) {
            switch (EmojiCompat.get().getLoadState()) {
                case 1: {
                    return EmojiCompat.get().process(source);
                }
            }
        }
        return source;
    }

    public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.mTransformationMethod != null) {
            this.mTransformationMethod.onFocusChanged(view, sourceText, focused, direction, previouslyFocusedRect);
        }
    }

    public TransformationMethod getOriginalTransformationMethod() {
        return this.mTransformationMethod;
    }
}

