/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.activity.BackEventCompat;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.collection.ArrayMap;
import androidx.core.app.SharedElementCallback;
import androidx.core.os.CancellationSignal;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import androidx.fragment.app.DefaultSpecialEffectsController;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentAnim;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.FragmentTransitionImpl;
import androidx.fragment.app.SpecialEffectsController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\b\u001f !\"#$%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0003J\u001e\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J&\u0010\u001b\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0002\u00a8\u0006'"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController;", "Landroidx/fragment/app/SpecialEffectsController;", "container", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "collectAnimEffects", "", "animationInfos", "", "Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "collectEffects", "operations", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "isPop", "", "createTransitionEffect", "transitionInfos", "Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionInfo;", "firstOut", "lastIn", "findNamedViews", "namedViews", "", "", "Landroid/view/View;", "view", "syncAnimations", "retainMatchingViews", "Landroidx/collection/ArrayMap;", "names", "", "AnimationEffect", "AnimationInfo", "AnimatorEffect", "Api24Impl", "Api26Impl", "SpecialEffectsInfo", "TransitionEffect", "TransitionInfo", "fragment_release"})
@SourceDebugExtension(value={"SMAP\nDefaultSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1129:1\n288#2,2:1130\n533#2,6:1132\n1360#2:1138\n1446#2,5:1139\n819#2:1144\n847#2,2:1145\n766#2:1147\n857#2,2:1148\n1789#2,3:1150\n1726#2,3:1153\n1855#2,2:1156\n*S KotlinDebug\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController\n*L\n52#1:1130,2\n58#1:1132,6\n117#1:1138\n117#1:1139,5\n190#1:1144\n190#1:1145,2\n193#1:1147\n193#1:1148,2\n197#1:1150,3\n355#1:1153,3\n366#1:1156,2\n*E\n"})
public final class DefaultSpecialEffectsController
extends SpecialEffectsController {
    public DefaultSpecialEffectsController(@NotNull ViewGroup container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(container);
    }

    public void collectEffects(@NotNull List<? extends SpecialEffectsController.Operation> operations, boolean isPop) {
        SpecialEffectsController.Operation operation;
        SpecialEffectsController.Operation firstOut;
        block5: {
            Object v2;
            block4: {
                Intrinsics.checkNotNullParameter(operations, (String)"operations");
                Iterable $this$firstOrNull$iv = operations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SpecialEffectsController.Operation operation2 = (SpecialEffectsController.Operation)element$iv;
                    boolean bl = false;
                    View view = operation2.getFragment().mView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
                    SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.Companion.asOperationState(view);
                    boolean bl2 = currentState == SpecialEffectsController.Operation.State.VISIBLE && operation2.getFinalState() != SpecialEffectsController.Operation.State.VISIBLE;
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            firstOut = v2;
            List<? extends SpecialEffectsController.Operation> $this$lastOrNull$iv = operations;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends SpecialEffectsController.Operation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                SpecialEffectsController.Operation operation3;
                SpecialEffectsController.Operation operation32 = operation3 = iterator$iv.previous();
                boolean bl = false;
                View view = operation32.getFragment().mView;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
                SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.Companion.asOperationState(view);
                boolean bl3 = currentState != SpecialEffectsController.Operation.State.VISIBLE && operation32.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE;
                if (!bl3) continue;
                operation = operation3;
                break block5;
            }
            operation = null;
        }
        SpecialEffectsController.Operation lastIn = operation;
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Executing operations from " + firstOut + " to " + lastIn));
        }
        List animations = new ArrayList();
        List transitions = new ArrayList();
        this.syncAnimations(operations);
        for (SpecialEffectsController.Operation operation4 : operations) {
            animations.add(new AnimationInfo(operation4, isPop));
            transitions.add(new TransitionInfo(operation4, isPop, isPop ? operation4 == firstOut : operation4 == lastIn));
            operation4.addCompletionListener(() -> DefaultSpecialEffectsController.collectEffects$lambda$2(this, operation4));
        }
        this.createTransitionEffect(transitions, isPop, firstOut, lastIn);
        this.collectAnimEffects(animations);
    }

    private final void syncAnimations(List<? extends SpecialEffectsController.Operation> operations) {
        Fragment lastOpFragment = ((SpecialEffectsController.Operation)CollectionsKt.last(operations)).getFragment();
        for (SpecialEffectsController.Operation operation : operations) {
            operation.getFragment().mAnimationInfo.mEnterAnim = lastOpFragment.mAnimationInfo.mEnterAnim;
            operation.getFragment().mAnimationInfo.mExitAnim = lastOpFragment.mAnimationInfo.mExitAnim;
            operation.getFragment().mAnimationInfo.mPopEnterAnim = lastOpFragment.mAnimationInfo.mPopEnterAnim;
            operation.getFragment().mAnimationInfo.mPopExitAnim = lastOpFragment.mAnimationInfo.mPopExitAnim;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi", "PrereleaseSdkCoreDependency"})
    private final void collectAnimEffects(List<AnimationInfo> animationInfos) {
        void $this$flatMapTo$iv$iv;
        List animationsToRun = new ArrayList();
        Iterable $this$flatMap$iv = animationInfos;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AnimationInfo it = (AnimationInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getOperation().getEffects$fragment_release();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        boolean startedAnyTransition = !((Collection)((List)destination$iv$iv)).isEmpty();
        boolean startedAnyAnimator = false;
        for (AnimationInfo animatorInfo : animationInfos) {
            boolean isHideOperation;
            boolean startedTransition;
            Context context = this.getContainer().getContext();
            SpecialEffectsController.Operation operation = animatorInfo.getOperation();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            FragmentAnim.AnimationOrAnimator anim = animatorInfo.getAnimation(context);
            if (anim == null) continue;
            AnimatorSet animator2 = anim.animator;
            if (animator2 == null) {
                animationsToRun.add(animatorInfo);
                continue;
            }
            Fragment fragment = operation.getFragment();
            boolean bl = startedTransition = !((Collection)operation.getEffects$fragment_release()).isEmpty();
            if (startedTransition) {
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)"FragmentManager", (String)("Ignoring Animator set on " + fragment + " as this Fragment was involved in a Transition."));
                continue;
            }
            startedAnyAnimator = true;
            boolean bl2 = isHideOperation = operation.getFinalState() == SpecialEffectsController.Operation.State.GONE;
            if (isHideOperation) {
                operation.setAwaitingContainerChanges(false);
            }
            operation.addEffect(new AnimatorEffect(animatorInfo));
        }
        for (AnimationInfo animationInfo : animationsToRun) {
            SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            if (startedAnyTransition) {
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Transitions."));
                continue;
            }
            if (startedAnyAnimator) {
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Animators."));
                continue;
            }
            operation.addEffect(new AnimationEffect(animationInfo));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createTransitionEffect(List<TransitionInfo> transitionInfos, boolean isPop, SpecialEffectsController.Operation firstOut, SpecialEffectsController.Operation lastIn) {
        void $this$fold$iv;
        void initial$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        TransitionInfo transitionInfo;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = transitionInfos;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            transitionInfo = (TransitionInfo)element$iv$iv;
            boolean bl = false;
            if (transitionInfo.isVisibilityUnchanged()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            transitionInfo = (TransitionInfo)element$iv$iv;
            boolean bl = false;
            if (!(transitionInfo.getHandlingImpl() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredInfos = (List)destination$iv$iv;
        $this$filterTo$iv$iv = filteredInfos;
        destination$iv$iv = null;
        boolean $i$f$fold = false;
        FragmentTransitionImpl accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transitionInfo2;
            TransitionInfo bl = (TransitionInfo)element$iv;
            Iterator chosenImpl = accumulator$iv;
            boolean bl2 = false;
            FragmentTransitionImpl handlingImpl = transitionInfo2.getHandlingImpl();
            if (!(chosenImpl == null || handlingImpl == chosenImpl)) {
                boolean $i$a$-require-DefaultSpecialEffectsController$createTransitionEffect$transitionImpl$1$22 = false;
                String $i$a$-require-DefaultSpecialEffectsController$createTransitionEffect$transitionImpl$1$22 = "Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + transitionInfo2.getOperation().getFragment() + " returned Transition " + transitionInfo2.getTransition() + " which uses a different Transition type than other Fragments.";
                throw new IllegalArgumentException($i$a$-require-DefaultSpecialEffectsController$createTransitionEffect$transitionImpl$1$22.toString());
            }
            accumulator$iv = handlingImpl;
        }
        void v0 = accumulator$iv;
        if (v0 == null) {
            return;
        }
        void transitionImpl = v0;
        Object sharedElementTransition = null;
        ArrayList<View> sharedElementFirstOutViews = new ArrayList<View>();
        ArrayList<View> sharedElementLastInViews = new ArrayList<View>();
        ArrayMap sharedElementNameMapping = new ArrayMap();
        ArrayList<String> enteringNames = new ArrayList<String>();
        ArrayList<String> exitingNames = new ArrayList<String>();
        ArrayMap firstOutViews = new ArrayMap();
        ArrayMap lastInViews = new ArrayMap();
        for (TransitionInfo transitionInfo3 : filteredInfos) {
            View view;
            String name;
            int n;
            ArrayList<String> firstOutTargetNames;
            boolean hasSharedElementTransition = transitionInfo3.hasSharedElementTransition();
            if (!hasSharedElementTransition || firstOut == null || lastIn == null) continue;
            sharedElementTransition = transitionImpl.wrapTransitionInSet(transitionImpl.cloneTransition(transitionInfo3.getSharedElementTransition()));
            Intrinsics.checkNotNullExpressionValue(lastIn.getFragment().getSharedElementSourceNames(), (String)"lastIn.fragment.sharedElementSourceNames");
            Intrinsics.checkNotNullExpressionValue(firstOut.getFragment().getSharedElementSourceNames(), (String)"firstOut.fragment.sharedElementSourceNames");
            Intrinsics.checkNotNullExpressionValue(firstOut.getFragment().getSharedElementTargetNames(), (String)"firstOut.fragment.sharedElementTargetNames");
            int n2 = firstOutTargetNames.size();
            for (int index = 0; index < n2; ++index) {
                ArrayList<String> firstOutSourceNames;
                int nameIndex = exitingNames.indexOf(firstOutTargetNames.get(index));
                if (nameIndex == -1) continue;
                exitingNames.set(nameIndex, firstOutSourceNames.get(index));
            }
            Intrinsics.checkNotNullExpressionValue(lastIn.getFragment().getSharedElementTargetNames(), (String)"lastIn.fragment.sharedElementTargetNames");
            Pair index = !isPop ? TuplesKt.to((Object)firstOut.getFragment().getExitTransitionCallback(), (Object)lastIn.getFragment().getEnterTransitionCallback()) : TuplesKt.to((Object)firstOut.getFragment().getEnterTransitionCallback(), (Object)lastIn.getFragment().getExitTransitionCallback());
            SharedElementCallback exitingCallback = (SharedElementCallback)index.component1();
            SharedElementCallback enteringCallback = (SharedElementCallback)index.component2();
            int numSharedElements = exitingNames.size();
            for (int i = 0; i < numSharedElements; ++i) {
                String enteringName;
                String exitingName;
                Intrinsics.checkNotNullExpressionValue((Object)exitingNames.get(i), (String)"exitingNames[i]");
                Intrinsics.checkNotNullExpressionValue((Object)enteringNames.get(i), (String)"enteringNames[i]");
                ((Map)sharedElementNameMapping).put(exitingName, enteringName);
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)">>> entering view names <<<");
                for (String name2 : enteringNames) {
                    Log.v((String)"FragmentManager", (String)("Name: " + name2));
                }
                Log.v((String)"FragmentManager", (String)">>> exiting view names <<<");
                for (String name2 : exitingNames) {
                    Log.v((String)"FragmentManager", (String)("Name: " + name2));
                }
            }
            Map map = (Map)firstOutViews;
            View view2 = firstOut.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"firstOut.fragment.mView");
            this.findNamedViews(map, view2);
            firstOutViews.retainAll((Collection)exitingNames);
            if (exitingCallback != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Executing exit callback for operation " + firstOut));
                }
                exitingCallback.onMapSharedElements((List)exitingNames, (Map)firstOutViews);
                n = exitingNames.size() + -1;
                if (0 <= n) {
                    do {
                        int i = n--;
                        Intrinsics.checkNotNullExpressionValue((Object)exitingNames.get(i), (String)"exitingNames[i]");
                        view = (View)firstOutViews.get((Object)name);
                        if (view == null) {
                            sharedElementNameMapping.remove((Object)name);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)name, (Object)ViewCompat.getTransitionName((View)view))) continue;
                        String targetValue = (String)sharedElementNameMapping.remove((Object)name);
                        ((Map)sharedElementNameMapping).put(ViewCompat.getTransitionName((View)view), targetValue);
                    } while (0 <= n);
                }
            } else {
                sharedElementNameMapping.retainAll((Collection)firstOutViews.keySet());
            }
            Map map2 = (Map)lastInViews;
            View view3 = lastIn.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"lastIn.fragment.mView");
            this.findNamedViews(map2, view3);
            lastInViews.retainAll((Collection)enteringNames);
            lastInViews.retainAll(sharedElementNameMapping.values());
            if (enteringCallback != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Executing enter callback for operation " + lastIn));
                }
                enteringCallback.onMapSharedElements((List)enteringNames, (Map)lastInViews);
                n = enteringNames.size() + -1;
                if (0 <= n) {
                    do {
                        String key;
                        int i = n--;
                        Intrinsics.checkNotNullExpressionValue((Object)enteringNames.get(i), (String)"enteringNames[i]");
                        view = (View)lastInViews.get((Object)name);
                        if (view == null) {
                            key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name);
                            if (key == null) continue;
                            sharedElementNameMapping.remove((Object)key);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)name, (Object)ViewCompat.getTransitionName((View)view)) || (key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name)) == null) continue;
                        ((Map)sharedElementNameMapping).put(key, ViewCompat.getTransitionName((View)view));
                    } while (0 <= n);
                }
            } else {
                FragmentTransition.retainValues((ArrayMap<String, String>)sharedElementNameMapping, (ArrayMap<String, View>)lastInViews);
            }
            Set set = sharedElementNameMapping.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sharedElementNameMapping.keys");
            this.retainMatchingViews((ArrayMap<String, View>)firstOutViews, set);
            Collection collection = sharedElementNameMapping.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sharedElementNameMapping.values");
            this.retainMatchingViews((ArrayMap<String, View>)lastInViews, collection);
            if (!sharedElementNameMapping.isEmpty()) continue;
            Log.i((String)"FragmentManager", (String)("Ignoring shared elements transition " + sharedElementTransition + " between " + firstOut + " and " + lastIn + " as there are no matching elements in both the entering and exiting fragment. In order to run a SharedElementTransition, both fragments involved must have the element."));
            sharedElementTransition = null;
            sharedElementFirstOutViews.clear();
            sharedElementLastInViews.clear();
        }
        if (sharedElementTransition == null) {
            boolean bl;
            block29: {
                Iterable $this$all$iv = filteredInfos;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        TransitionInfo it = (TransitionInfo)element$iv;
                        boolean bl3 = false;
                        if (it.getTransition() == null) continue;
                        bl = false;
                        break block29;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        TransitionEffect transitionEffect = new TransitionEffect(filteredInfos, firstOut, lastIn, (FragmentTransitionImpl)transitionImpl, sharedElementTransition, sharedElementFirstOutViews, sharedElementLastInViews, (ArrayMap<String, String>)sharedElementNameMapping, enteringNames, exitingNames, (ArrayMap<String, View>)firstOutViews, (ArrayMap<String, View>)lastInViews, isPop);
        Iterable $this$forEach$iv = filteredInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransitionInfo transitionInfo4 = (TransitionInfo)element$iv;
            boolean bl = false;
            transitionInfo4.getOperation().addEffect(transitionEffect);
        }
    }

    private final void retainMatchingViews(ArrayMap<String, View> $this$retainMatchingViews, Collection<String> names) {
        Set set = $this$retainMatchingViews.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entries");
        CollectionsKt.retainAll((Iterable)set, (Function1)((Function1)new Function1<Map.Entry<String, View>, Boolean>(names){
            final /* synthetic */ Collection<String> $names;
            {
                this.$names = $names;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, View> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                return CollectionsKt.contains((Iterable)this.$names, (Object)ViewCompat.getTransitionName((View)entry.getValue()));
            }
        }));
    }

    private final void findNamedViews(Map<String, View> namedViews, View view) {
        String transitionName = ViewCompat.getTransitionName((View)view);
        if (transitionName != null) {
            namedViews.put(transitionName, view);
        }
        if (view instanceof ViewGroup) {
            int count = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = ((ViewGroup)view).getChildAt(i);
                if (child.getVisibility() != 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                this.findNamedViews(namedViews, child);
            }
        }
    }

    private static final void collectEffects$lambda$2(DefaultSpecialEffectsController this$0, SpecialEffectsController.Operation $operation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        this$0.applyContainerChangesToOperation$fragment_release($operation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationEffect;", "Landroidx/fragment/app/SpecialEffectsController$Effect;", "animationInfo", "Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "(Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;)V", "getAnimationInfo", "()Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "onCancel", "", "container", "Landroid/view/ViewGroup;", "onCommit", "fragment_release"})
    private static final class AnimationEffect
    extends SpecialEffectsController.Effect {
        @NotNull
        private final AnimationInfo animationInfo;

        public AnimationEffect(@NotNull AnimationInfo animationInfo) {
            Intrinsics.checkNotNullParameter((Object)animationInfo, (String)"animationInfo");
            this.animationInfo = animationInfo;
        }

        @NotNull
        public final AnimationInfo getAnimationInfo() {
            return this.animationInfo;
        }

        @Override
        public void onCommit(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (this.animationInfo.isVisibilityUnchanged()) {
                this.animationInfo.getOperation().completeEffect(this);
                return;
            }
            Context context = container.getContext();
            SpecialEffectsController.Operation operation = this.animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            View viewToAnimate = fragment.mView;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            FragmentAnim.AnimationOrAnimator animationOrAnimator = this.animationInfo.getAnimation(context);
            if (animationOrAnimator == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Animation animation = animationOrAnimator.animation;
            if (animation == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Animation anim = animation;
            SpecialEffectsController.Operation.State finalState = operation.getFinalState();
            if (finalState != SpecialEffectsController.Operation.State.REMOVED) {
                viewToAnimate.startAnimation(anim);
                this.animationInfo.getOperation().completeEffect(this);
            } else {
                container.startViewTransition(viewToAnimate);
                Animation animation2 = (Animation)new FragmentAnim.EndViewTransitionAnimation(anim, container, viewToAnimate);
                animation2.setAnimationListener(new Animation.AnimationListener(operation, container, viewToAnimate, this){
                    final /* synthetic */ SpecialEffectsController.Operation $operation;
                    final /* synthetic */ ViewGroup $container;
                    final /* synthetic */ View $viewToAnimate;
                    final /* synthetic */ AnimationEffect this$0;
                    {
                        this.$operation = $operation;
                        this.$container = $container;
                        this.$viewToAnimate = $viewToAnimate;
                        this.this$0 = $receiver;
                    }

                    public void onAnimationStart(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("Animation from operation " + this.$operation + " has reached onAnimationStart."));
                        }
                    }

                    public void onAnimationEnd(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        this.$container.post(() -> onCommit.1.onAnimationEnd$lambda$0(this.$container, this.$viewToAnimate, this.this$0));
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("Animation from operation " + this.$operation + " has ended."));
                        }
                    }

                    public void onAnimationRepeat(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    }

                    private static final void onAnimationEnd$lambda$0(ViewGroup $container, View $viewToAnimate, AnimationEffect this$0) {
                        Intrinsics.checkNotNullParameter((Object)$container, (String)"$container");
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        $container.endViewTransition($viewToAnimate);
                        this$0.getAnimationInfo().getOperation().completeEffect(this$0);
                    }
                });
                viewToAnimate.startAnimation(animation2);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Animation from operation " + operation + " has started."));
                }
            }
        }

        @Override
        public void onCancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            SpecialEffectsController.Operation operation = this.animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            View viewToAnimate = fragment.mView;
            viewToAnimate.clearAnimation();
            container.endViewTransition(viewToAnimate);
            this.animationInfo.getOperation().completeEffect(this);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Animation from operation " + operation + " has been cancelled."));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "isPop", "", "(Landroidx/fragment/app/SpecialEffectsController$Operation;Z)V", "animation", "Landroidx/fragment/app/FragmentAnim$AnimationOrAnimator;", "isAnimLoaded", "getAnimation", "context", "Landroid/content/Context;", "fragment_release"})
    private static final class AnimationInfo
    extends SpecialEffectsInfo {
        private final boolean isPop;
        private boolean isAnimLoaded;
        @Nullable
        private FragmentAnim.AnimationOrAnimator animation;

        public AnimationInfo(@NotNull SpecialEffectsController.Operation operation, boolean isPop) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            super(operation);
            this.isPop = isPop;
        }

        @Nullable
        public final FragmentAnim.AnimationOrAnimator getAnimation(@NotNull Context context) {
            FragmentAnim.AnimationOrAnimator animationOrAnimator;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.isAnimLoaded) {
                animationOrAnimator = this.animation;
            } else {
                FragmentAnim.AnimationOrAnimator animationOrAnimator2;
                FragmentAnim.AnimationOrAnimator it = animationOrAnimator2 = FragmentAnim.loadAnimation(context, this.getOperation().getFragment(), this.getOperation().getFinalState() == SpecialEffectsController.Operation.State.VISIBLE, this.isPop);
                boolean bl = false;
                this.animation = it;
                this.isAnimLoaded = true;
                animationOrAnimator = animationOrAnimator2;
            }
            return animationOrAnimator;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0019"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$AnimatorEffect;", "Landroidx/fragment/app/SpecialEffectsController$Effect;", "animatorInfo", "Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "(Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;)V", "animator", "Landroid/animation/AnimatorSet;", "getAnimator", "()Landroid/animation/AnimatorSet;", "setAnimator", "(Landroid/animation/AnimatorSet;)V", "getAnimatorInfo", "()Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "isSeekingSupported", "", "()Z", "onCancel", "", "container", "Landroid/view/ViewGroup;", "onCommit", "onProgress", "backEvent", "Landroidx/activity/BackEventCompat;", "onStart", "fragment_release"})
    private static final class AnimatorEffect
    extends SpecialEffectsController.Effect {
        @NotNull
        private final AnimationInfo animatorInfo;
        @Nullable
        private AnimatorSet animator;

        public AnimatorEffect(@NotNull AnimationInfo animatorInfo) {
            Intrinsics.checkNotNullParameter((Object)animatorInfo, (String)"animatorInfo");
            this.animatorInfo = animatorInfo;
        }

        @NotNull
        public final AnimationInfo getAnimatorInfo() {
            return this.animatorInfo;
        }

        @Override
        public boolean isSeekingSupported() {
            return true;
        }

        @Nullable
        public final AnimatorSet getAnimator() {
            return this.animator;
        }

        public final void setAnimator(@Nullable AnimatorSet animatorSet) {
            this.animator = animatorSet;
        }

        @Override
        public void onStart(@NotNull ViewGroup container) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                if (this.animatorInfo.isVisibilityUnchanged()) {
                    return;
                }
                Context context = container.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                FragmentAnim.AnimationOrAnimator animationOrAnimator = this.animatorInfo.getAnimation(context);
                this.animator = animationOrAnimator != null ? animationOrAnimator.animator : null;
                SpecialEffectsController.Operation operation = this.animatorInfo.getOperation();
                Fragment fragment = operation.getFragment();
                boolean isHideOperation = operation.getFinalState() == SpecialEffectsController.Operation.State.GONE;
                View viewToAnimate = fragment.mView;
                container.startViewTransition(viewToAnimate);
                AnimatorSet animatorSet = this.animator;
                if (animatorSet != null) {
                    animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(container, viewToAnimate, isHideOperation, operation, this){
                        final /* synthetic */ ViewGroup $container;
                        final /* synthetic */ View $viewToAnimate;
                        final /* synthetic */ boolean $isHideOperation;
                        final /* synthetic */ SpecialEffectsController.Operation $operation;
                        final /* synthetic */ AnimatorEffect this$0;
                        {
                            this.$container = $container;
                            this.$viewToAnimate = $viewToAnimate;
                            this.$isHideOperation = $isHideOperation;
                            this.$operation = $operation;
                            this.this$0 = $receiver;
                        }

                        public void onAnimationEnd(@NotNull Animator anim) {
                            Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
                            this.$container.endViewTransition(this.$viewToAnimate);
                            if (this.$isHideOperation) {
                                SpecialEffectsController.Operation.State state = this.$operation.getFinalState();
                                View view = this.$viewToAnimate;
                                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewToAnimate");
                                state.applyState(view, this.$container);
                            }
                            this.this$0.getAnimatorInfo().getOperation().completeEffect(this.this$0);
                            if (FragmentManager.isLoggingEnabled(2)) {
                                Log.v((String)"FragmentManager", (String)("Animator from operation " + this.$operation + " has ended."));
                            }
                        }
                    });
                }
                AnimatorSet animatorSet2 = this.animator;
                if (animatorSet2 == null) break block2;
                animatorSet2.setTarget((Object)viewToAnimate);
            }
        }

        @Override
        public void onProgress(@NotNull BackEventCompat backEvent, @NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)backEvent, (String)"backEvent");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            SpecialEffectsController.Operation operation = this.animatorInfo.getOperation();
            AnimatorSet animatorSet = this.animator;
            if (animatorSet == null) {
                this.animatorInfo.getOperation().completeEffect(this);
                return;
            }
            if (Build.VERSION.SDK_INT >= 34 && operation.getFragment().mTransitioning) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Adding BackProgressCallbacks for Animators to operation " + operation));
                }
                long totalDuration = Api24Impl.INSTANCE.totalDuration(animatorSet);
                long time = (long)(backEvent.getProgress() * (float)totalDuration);
                if (time == 0L) {
                    time = 1L;
                }
                if (time == totalDuration) {
                    time = totalDuration - 1L;
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Setting currentPlayTime to " + time + " for Animator " + animatorSet + " on operation " + operation));
                }
                Api26Impl.INSTANCE.setCurrentPlayTime(animatorSet, time);
            }
        }

        @Override
        public void onCommit(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            SpecialEffectsController.Operation operation = this.animatorInfo.getOperation();
            AnimatorSet animatorSet = this.animator;
            if (animatorSet == null) {
                this.animatorInfo.getOperation().completeEffect(this);
                return;
            }
            animatorSet.start();
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Animator from operation " + operation + " has started."));
            }
        }

        @Override
        public void onCancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            AnimatorSet animator2 = this.animator;
            if (animator2 == null) {
                this.animatorInfo.getOperation().completeEffect(this);
            } else {
                SpecialEffectsController.Operation operation = this.animatorInfo.getOperation();
                if (operation.isSeeking()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        Api26Impl.INSTANCE.reverse(animator2);
                    }
                } else {
                    animator2.end();
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Animator from operation " + operation + " has been canceled" + (operation.isSeeking() ? " with seeking." : ".") + ' '));
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$Api24Impl;", "", "()V", "totalDuration", "", "animatorSet", "Landroid/animation/AnimatorSet;", "fragment_release"})
    @RequiresApi(value=24)
    public static final class Api24Impl {
        @NotNull
        public static final Api24Impl INSTANCE = new Api24Impl();

        private Api24Impl() {
        }

        @DoNotInline
        public final long totalDuration(@NotNull AnimatorSet animatorSet) {
            Intrinsics.checkNotNullParameter((Object)animatorSet, (String)"animatorSet");
            return animatorSet.getTotalDuration();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$Api26Impl;", "", "()V", "reverse", "", "animatorSet", "Landroid/animation/AnimatorSet;", "setCurrentPlayTime", "time", "", "fragment_release"})
    @RequiresApi(value=26)
    public static final class Api26Impl {
        @NotNull
        public static final Api26Impl INSTANCE = new Api26Impl();

        private Api26Impl() {
        }

        @DoNotInline
        public final void reverse(@NotNull AnimatorSet animatorSet) {
            Intrinsics.checkNotNullParameter((Object)animatorSet, (String)"animatorSet");
            animatorSet.reverse();
        }

        @DoNotInline
        public final void setCurrentPlayTime(@NotNull AnimatorSet animatorSet, long time) {
            Intrinsics.checkNotNullParameter((Object)animatorSet, (String)"animatorSet");
            animatorSet.setCurrentPlayTime(time);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "(Landroidx/fragment/app/SpecialEffectsController$Operation;)V", "isVisibilityUnchanged", "", "()Z", "getOperation", "()Landroidx/fragment/app/SpecialEffectsController$Operation;", "fragment_release"})
    public static class SpecialEffectsInfo {
        @NotNull
        private final SpecialEffectsController.Operation operation;

        public SpecialEffectsInfo(@NotNull SpecialEffectsController.Operation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.operation = operation;
        }

        @NotNull
        public final SpecialEffectsController.Operation getOperation() {
            return this.operation;
        }

        public final boolean isVisibilityUnchanged() {
            View view = this.operation.getFragment().mView;
            SpecialEffectsController.Operation.State currentState = view != null ? SpecialEffectsController.Operation.State.Companion.asOperationState(view) : null;
            SpecialEffectsController.Operation.State finalState = this.operation.getFinalState();
            return currentState == finalState || currentState != SpecialEffectsController.Operation.State.VISIBLE && finalState != SpecialEffectsController.Operation.State.VISIBLE;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u00dd\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00130\rj\b\u0012\u0004\u0012\u00020\u0013`\u000f\u0012\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00130\rj\b\u0012\u0004\u0012\u00020\u0013`\u000f\u0012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ(\u0010;\u001a\u00020<2\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010>\u001a\u00020\u000eH\u0002J@\u0010?\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u0004\u0012\u00020\u000b0@2\u0006\u0010A\u001a\u00020B2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010C\u001a\u00020<2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020<2\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020G2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010H\u001a\u00020<2\u0006\u0010A\u001a\u00020BH\u0016J6\u0010I\u001a\u00020<2\u0016\u0010J\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010A\u001a\u00020B2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020<0LH\u0002R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00130\rj\b\u0012\u0004\u0012\u00020\u0013`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00130\rj\b\u0012\u0004\u0012\u00020\u0013`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010'R\u0014\u0010(\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010!R!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010!R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010&R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0017\u00103\u001a\u000204\u00a2\u0006\u000e\n\u0000\u0012\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b:\u0010'\u00a8\u0006M"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionEffect;", "Landroidx/fragment/app/SpecialEffectsController$Effect;", "transitionInfos", "", "Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionInfo;", "firstOut", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "lastIn", "transitionImpl", "Landroidx/fragment/app/FragmentTransitionImpl;", "sharedElementTransition", "", "sharedElementFirstOutViews", "Ljava/util/ArrayList;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "sharedElementLastInViews", "sharedElementNameMapping", "Landroidx/collection/ArrayMap;", "", "enteringNames", "exitingNames", "firstOutViews", "lastInViews", "isPop", "", "(Ljava/util/List;Landroidx/fragment/app/SpecialEffectsController$Operation;Landroidx/fragment/app/SpecialEffectsController$Operation;Landroidx/fragment/app/FragmentTransitionImpl;Ljava/lang/Object;Ljava/util/ArrayList;Ljava/util/ArrayList;Landroidx/collection/ArrayMap;Ljava/util/ArrayList;Ljava/util/ArrayList;Landroidx/collection/ArrayMap;Landroidx/collection/ArrayMap;Z)V", "controller", "getController", "()Ljava/lang/Object;", "setController", "(Ljava/lang/Object;)V", "getEnteringNames", "()Ljava/util/ArrayList;", "getExitingNames", "getFirstOut", "()Landroidx/fragment/app/SpecialEffectsController$Operation;", "getFirstOutViews", "()Landroidx/collection/ArrayMap;", "()Z", "isSeekingSupported", "getLastIn", "getLastInViews", "getSharedElementFirstOutViews", "getSharedElementLastInViews", "getSharedElementNameMapping", "getSharedElementTransition", "getTransitionImpl", "()Landroidx/fragment/app/FragmentTransitionImpl;", "getTransitionInfos", "()Ljava/util/List;", "transitionSignal", "Landroidx/core/os/CancellationSignal;", "getTransitionSignal$annotations", "()V", "getTransitionSignal", "()Landroidx/core/os/CancellationSignal;", "transitioning", "getTransitioning", "captureTransitioningViews", "", "transitioningViews", "view", "createMergedTransition", "Lkotlin/Pair;", "container", "Landroid/view/ViewGroup;", "onCancel", "onCommit", "onProgress", "backEvent", "Landroidx/activity/BackEventCompat;", "onStart", "runTransition", "enteringViews", "executeTransition", "Lkotlin/Function0;", "fragment_release"})
    @SourceDebugExtension(value={"SMAP\nDefaultSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController$TransitionEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1129:1\n1726#2,3:1130\n1726#2,3:1133\n1855#2,2:1136\n1549#2:1138\n1620#2,3:1139\n1855#2,2:1142\n1855#2,2:1145\n1549#2:1147\n1620#2,3:1148\n1855#2,2:1151\n1#3:1144\n*S KotlinDebug\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController$TransitionEffect\n*L\n722#1:1130,3\n731#1:1133,3\n739#1:1136,2\n768#1:1138\n768#1:1139,3\n768#1:1142,2\n824#1:1145,2\n845#1:1147\n845#1:1148,3\n845#1:1151,2\n*E\n"})
    private static final class TransitionEffect
    extends SpecialEffectsController.Effect {
        @NotNull
        private final List<TransitionInfo> transitionInfos;
        @Nullable
        private final SpecialEffectsController.Operation firstOut;
        @Nullable
        private final SpecialEffectsController.Operation lastIn;
        @NotNull
        private final FragmentTransitionImpl transitionImpl;
        @Nullable
        private final Object sharedElementTransition;
        @NotNull
        private final ArrayList<View> sharedElementFirstOutViews;
        @NotNull
        private final ArrayList<View> sharedElementLastInViews;
        @NotNull
        private final ArrayMap<String, String> sharedElementNameMapping;
        @NotNull
        private final ArrayList<String> enteringNames;
        @NotNull
        private final ArrayList<String> exitingNames;
        @NotNull
        private final ArrayMap<String, View> firstOutViews;
        @NotNull
        private final ArrayMap<String, View> lastInViews;
        private final boolean isPop;
        @NotNull
        private final CancellationSignal transitionSignal;
        @Nullable
        private Object controller;

        public TransitionEffect(@NotNull List<TransitionInfo> transitionInfos, @Nullable SpecialEffectsController.Operation firstOut, @Nullable SpecialEffectsController.Operation lastIn, @NotNull FragmentTransitionImpl transitionImpl, @Nullable Object sharedElementTransition, @NotNull ArrayList<View> sharedElementFirstOutViews, @NotNull ArrayList<View> sharedElementLastInViews, @NotNull ArrayMap<String, String> sharedElementNameMapping, @NotNull ArrayList<String> enteringNames, @NotNull ArrayList<String> exitingNames, @NotNull ArrayMap<String, View> firstOutViews, @NotNull ArrayMap<String, View> lastInViews, boolean isPop) {
            Intrinsics.checkNotNullParameter(transitionInfos, (String)"transitionInfos");
            Intrinsics.checkNotNullParameter((Object)transitionImpl, (String)"transitionImpl");
            Intrinsics.checkNotNullParameter(sharedElementFirstOutViews, (String)"sharedElementFirstOutViews");
            Intrinsics.checkNotNullParameter(sharedElementLastInViews, (String)"sharedElementLastInViews");
            Intrinsics.checkNotNullParameter(sharedElementNameMapping, (String)"sharedElementNameMapping");
            Intrinsics.checkNotNullParameter(enteringNames, (String)"enteringNames");
            Intrinsics.checkNotNullParameter(exitingNames, (String)"exitingNames");
            Intrinsics.checkNotNullParameter(firstOutViews, (String)"firstOutViews");
            Intrinsics.checkNotNullParameter(lastInViews, (String)"lastInViews");
            this.transitionInfos = transitionInfos;
            this.firstOut = firstOut;
            this.lastIn = lastIn;
            this.transitionImpl = transitionImpl;
            this.sharedElementTransition = sharedElementTransition;
            this.sharedElementFirstOutViews = sharedElementFirstOutViews;
            this.sharedElementLastInViews = sharedElementLastInViews;
            this.sharedElementNameMapping = sharedElementNameMapping;
            this.enteringNames = enteringNames;
            this.exitingNames = exitingNames;
            this.firstOutViews = firstOutViews;
            this.lastInViews = lastInViews;
            this.isPop = isPop;
            this.transitionSignal = new CancellationSignal();
        }

        @NotNull
        public final List<TransitionInfo> getTransitionInfos() {
            return this.transitionInfos;
        }

        @Nullable
        public final SpecialEffectsController.Operation getFirstOut() {
            return this.firstOut;
        }

        @Nullable
        public final SpecialEffectsController.Operation getLastIn() {
            return this.lastIn;
        }

        @NotNull
        public final FragmentTransitionImpl getTransitionImpl() {
            return this.transitionImpl;
        }

        @Nullable
        public final Object getSharedElementTransition() {
            return this.sharedElementTransition;
        }

        @NotNull
        public final ArrayList<View> getSharedElementFirstOutViews() {
            return this.sharedElementFirstOutViews;
        }

        @NotNull
        public final ArrayList<View> getSharedElementLastInViews() {
            return this.sharedElementLastInViews;
        }

        @NotNull
        public final ArrayMap<String, String> getSharedElementNameMapping() {
            return this.sharedElementNameMapping;
        }

        @NotNull
        public final ArrayList<String> getEnteringNames() {
            return this.enteringNames;
        }

        @NotNull
        public final ArrayList<String> getExitingNames() {
            return this.exitingNames;
        }

        @NotNull
        public final ArrayMap<String, View> getFirstOutViews() {
            return this.firstOutViews;
        }

        @NotNull
        public final ArrayMap<String, View> getLastInViews() {
            return this.lastInViews;
        }

        public final boolean isPop() {
            return this.isPop;
        }

        @NotNull
        public final CancellationSignal getTransitionSignal() {
            return this.transitionSignal;
        }

        public static /* synthetic */ void getTransitionSignal$annotations() {
        }

        @Nullable
        public final Object getController() {
            return this.controller;
        }

        public final void setController(@Nullable Object object) {
            this.controller = object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSeekingSupported() {
            boolean bl;
            if (!this.transitionImpl.isSeekingSupported()) return false;
            Iterable $this$all$iv = this.transitionInfos;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TransitionInfo it = (TransitionInfo)element$iv;
                    boolean bl2 = false;
                    if (Build.VERSION.SDK_INT < 34) return false;
                    if (it.getTransition() == null) return false;
                    if (!this.transitionImpl.isSeekingSupported(it.getTransition())) return false;
                    boolean bl3 = true;
                    if (bl3) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
            if (this.sharedElementTransition == null) return true;
            if (!this.transitionImpl.isSeekingSupported(this.sharedElementTransition)) return false;
            return true;
        }

        public final boolean getTransitioning() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.transitionInfos;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        TransitionInfo it = (TransitionInfo)element$iv;
                        boolean bl2 = false;
                        if (it.getOperation().getFragment().mTransitioning) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onStart(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!container.isLaidOut()) {
                Iterable $this$forEach$iv = this.transitionInfos;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TransitionInfo transitionInfo = (TransitionInfo)element$iv;
                    boolean bl = false;
                    SpecialEffectsController.Operation operation = transitionInfo.getOperation();
                    if (!FragmentManager.isLoggingEnabled(2)) continue;
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Container " + container + " has not been laid out. Skipping onStart for operation " + operation));
                }
                return;
            }
            if (this.getTransitioning() && this.sharedElementTransition != null && !this.isSeekingSupported()) {
                Log.i((String)"FragmentManager", (String)("Ignoring shared elements transition " + this.sharedElementTransition + " between " + this.firstOut + " and " + this.lastIn + " as neither fragment has set a Transition. In order to run a SharedElementTransition, you must also set either an enter or exit transition on a fragment involved in the transaction. The sharedElementTransition will run after the back gesture has been committed."));
            }
            if (this.isSeekingSupported() && this.getTransitioning()) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Ref.ObjectRef seekCancelLambda = new Ref.ObjectRef();
                Pair<ArrayList<View>, Object> pair = this.createMergedTransition(container, this.lastIn, this.firstOut);
                ArrayList enteringViews = (ArrayList)pair.component1();
                Object mergedTransition = pair.component2();
                Iterable $this$map$iv = this.transitionInfos;
                boolean $i$f$map = false;
                Iterable operation = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TransitionInfo transitionInfo = (TransitionInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getOperation());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SpecialEffectsController.Operation operation2 = (SpecialEffectsController.Operation)element$iv;
                    boolean bl = false;
                    Runnable cancelRunnable = () -> TransitionEffect.onStart$lambda$6$lambda$4(seekCancelLambda);
                    this.transitionImpl.setListenerForTransitionEnd(operation2.getFragment(), mergedTransition, this.transitionSignal, cancelRunnable, () -> TransitionEffect.onStart$lambda$6$lambda$5(operation2, this));
                }
                this.runTransition(enteringViews, container, (Function0<Unit>)((Function0)new Function0<Unit>(this, container, mergedTransition, (Ref.ObjectRef<Function0<Unit>>)seekCancelLambda){
                    final /* synthetic */ TransitionEffect this$0;
                    final /* synthetic */ ViewGroup $container;
                    final /* synthetic */ Object $mergedTransition;
                    final /* synthetic */ Ref.ObjectRef<Function0<Unit>> $seekCancelLambda;
                    {
                        this.this$0 = $receiver;
                        this.$container = $container;
                        this.$mergedTransition = $mergedTransition;
                        this.$seekCancelLambda = $seekCancelLambda;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.setController(this.this$0.getTransitionImpl().controlDelayedTransition(this.$container, this.$mergedTransition));
                        boolean bl = this.this$0.getController() != null;
                        Object object = this.$mergedTransition;
                        ViewGroup viewGroup = this.$container;
                        if (!bl) {
                            boolean bl2 = false;
                            String string = "Unable to start transition " + object + " for container " + viewGroup + '.';
                            throw new IllegalStateException(string.toString());
                        }
                        this.$seekCancelLambda.element = new Function0<Unit>(this.this$0, this.$container){
                            final /* synthetic */ TransitionEffect this$0;
                            final /* synthetic */ ViewGroup $container;
                            {
                                this.this$0 = $receiver;
                                this.$container = $container;
                                super(0);
                            }

                            public final void invoke() {
                                if (FragmentManager.isLoggingEnabled(2)) {
                                    Log.v((String)"FragmentManager", (String)"Animating to start");
                                }
                                FragmentTransitionImpl fragmentTransitionImpl = this.this$0.getTransitionImpl();
                                Object object = this.this$0.getController();
                                Intrinsics.checkNotNull((Object)object);
                                fragmentTransitionImpl.animateToStart(object, () -> onStart.2.invoke$lambda$1(this.this$0, this.$container));
                            }

                            private static final void invoke$lambda$1(TransitionEffect this$0, ViewGroup $container) {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$container, (String)"$container");
                                Iterable $this$forEach$iv = this$0.getTransitionInfos();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    TransitionInfo transitionInfo = (TransitionInfo)element$iv;
                                    boolean bl = false;
                                    SpecialEffectsController.Operation operation = transitionInfo.getOperation();
                                    View view = operation.getFragment().getView();
                                    if (view == null) continue;
                                    operation.getFinalState().applyState(view, $container);
                                }
                            }
                        };
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("Started executing operations from " + this.this$0.getFirstOut() + " to " + this.this$0.getLastIn()));
                        }
                    }
                }));
            }
        }

        @Override
        public void onProgress(@NotNull BackEventCompat backEvent, @NotNull ViewGroup container) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)backEvent, (String)"backEvent");
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                Object object = this.controller;
                if (object == null) break block0;
                Object it = object;
                boolean bl = false;
                this.transitionImpl.setCurrentPlayTime(it, backEvent.getProgress());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onCommit(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!container.isLaidOut()) {
                Iterable $this$forEach$iv = this.transitionInfos;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TransitionInfo transitionInfo = (TransitionInfo)element$iv;
                    boolean bl = false;
                    SpecialEffectsController.Operation operation = transitionInfo.getOperation();
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Container " + container + " has not been laid out. Completing operation " + operation));
                    }
                    transitionInfo.getOperation().completeEffect(this);
                }
                return;
            }
            if (this.controller != null) {
                Object object = this.controller;
                Intrinsics.checkNotNull((Object)object);
                this.transitionImpl.animateToEnd(object);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ending execution of operations from " + this.firstOut + " to " + this.lastIn));
                }
            } else {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Pair<ArrayList<View>, Object> pair = this.createMergedTransition(container, this.lastIn, this.firstOut);
                ArrayList enteringViews = (ArrayList)pair.component1();
                Object mergedTransition = pair.component2();
                Iterable $this$map$iv = this.transitionInfos;
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TransitionInfo transitionInfo = (TransitionInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getOperation());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SpecialEffectsController.Operation operation = (SpecialEffectsController.Operation)element$iv;
                    boolean bl3 = false;
                    this.transitionImpl.setListenerForTransitionEnd(operation.getFragment(), mergedTransition, this.transitionSignal, () -> TransitionEffect.onCommit$lambda$11$lambda$10(operation, this));
                }
                this.runTransition(enteringViews, container, (Function0<Unit>)((Function0)new Function0<Unit>(this, container, mergedTransition){
                    final /* synthetic */ TransitionEffect this$0;
                    final /* synthetic */ ViewGroup $container;
                    final /* synthetic */ Object $mergedTransition;
                    {
                        this.this$0 = $receiver;
                        this.$container = $container;
                        this.$mergedTransition = $mergedTransition;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getTransitionImpl().beginDelayedTransition(this.$container, this.$mergedTransition);
                    }
                }));
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Completed executing operations from " + this.firstOut + " to " + this.lastIn));
                }
            }
        }

        private final Pair<ArrayList<View>, Object> createMergedTransition(ViewGroup container, SpecialEffectsController.Operation lastIn, SpecialEffectsController.Operation firstOut) {
            View nonExistentView = new View(container.getContext());
            View firstOutEpicenterView = null;
            boolean hasLastInEpicenter = false;
            Rect lastInEpicenterRect = new Rect();
            for (TransitionInfo transitionInfo : this.transitionInfos) {
                String epicenterViewName;
                boolean hasSharedElementTransition = transitionInfo.hasSharedElementTransition();
                if (!hasSharedElementTransition || firstOut == null || lastIn == null || !(!((Map)this.sharedElementNameMapping).isEmpty()) || this.sharedElementTransition == null) continue;
                FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), this.isPop, this.firstOutViews, true);
                OneShotPreDrawListener.add((View)((View)container), () -> TransitionEffect.createMergedTransition$lambda$12(lastIn, firstOut, this));
                this.sharedElementFirstOutViews.addAll(this.firstOutViews.values());
                if (!((Collection)this.exitingNames).isEmpty()) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.exitingNames.get(0), (String)"exitingNames[0]");
                    firstOutEpicenterView = (View)this.firstOutViews.get((Object)epicenterViewName);
                    this.transitionImpl.setEpicenter(this.sharedElementTransition, firstOutEpicenterView);
                }
                this.sharedElementLastInViews.addAll(this.lastInViews.values());
                if (!((Collection)this.enteringNames).isEmpty()) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.enteringNames.get(0), (String)"enteringNames[0]");
                    View lastInEpicenterView = (View)this.lastInViews.get((Object)epicenterViewName);
                    if (lastInEpicenterView != null) {
                        hasLastInEpicenter = true;
                        FragmentTransitionImpl impl = this.transitionImpl;
                        OneShotPreDrawListener.add((View)((View)container), () -> TransitionEffect.createMergedTransition$lambda$13(impl, lastInEpicenterView, lastInEpicenterRect));
                    }
                }
                this.transitionImpl.setSharedElementTargets(this.sharedElementTransition, nonExistentView, this.sharedElementFirstOutViews);
                this.transitionImpl.scheduleRemoveTargets(this.sharedElementTransition, null, null, null, null, this.sharedElementTransition, this.sharedElementLastInViews);
            }
            ArrayList enteringViews = new ArrayList();
            Object mergedTransition = null;
            Object mergedNonOverlappingTransition = null;
            for (TransitionInfo transitionInfo : this.transitionInfos) {
                View view;
                Iterator<View> iterator;
                boolean involvedInSharedElementTransition;
                SpecialEffectsController.Operation operation = transitionInfo.getOperation();
                Object transition = this.transitionImpl.cloneTransition(transitionInfo.getTransition());
                if (transition == null) continue;
                ArrayList<View> transitioningViews = new ArrayList<View>();
                View view2 = operation.getFragment().mView;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"operation.fragment.mView");
                this.captureTransitioningViews(transitioningViews, view2);
                boolean bl = involvedInSharedElementTransition = this.sharedElementTransition != null && (operation == firstOut || operation == lastIn);
                if (involvedInSharedElementTransition) {
                    if (operation == firstOut) {
                        transitioningViews.removeAll(CollectionsKt.toSet((Iterable)this.sharedElementFirstOutViews));
                    } else {
                        transitioningViews.removeAll(CollectionsKt.toSet((Iterable)this.sharedElementLastInViews));
                    }
                }
                if (transitioningViews.isEmpty()) {
                    this.transitionImpl.addTarget(transition, nonExistentView);
                } else {
                    this.transitionImpl.addTargets(transition, transitioningViews);
                    this.transitionImpl.scheduleRemoveTargets(transition, transition, transitioningViews, null, null, null, null);
                    if (operation.getFinalState() == SpecialEffectsController.Operation.State.GONE) {
                        operation.setAwaitingContainerChanges(false);
                        ArrayList<View> transitioningViewsToHide = new ArrayList<View>((Collection)transitioningViews);
                        transitioningViewsToHide.remove(operation.getFragment().mView);
                        this.transitionImpl.scheduleHideFragmentView(transition, operation.getFragment().mView, transitioningViewsToHide);
                        OneShotPreDrawListener.add((View)((View)container), () -> TransitionEffect.createMergedTransition$lambda$14(transitioningViews));
                    }
                }
                if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                    enteringViews.addAll(transitioningViews);
                    if (hasLastInEpicenter) {
                        this.transitionImpl.setEpicenter(transition, lastInEpicenterRect);
                    }
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("Entering Transition: " + transition));
                        Log.v((String)"FragmentManager", (String)">>>>> EnteringViews <<<<<");
                        iterator = transitioningViews.iterator();
                        while (iterator.hasNext()) {
                            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"transitioningViews");
                            Log.v((String)"FragmentManager", (String)("View: " + view));
                        }
                    }
                } else {
                    this.transitionImpl.setEpicenter(transition, firstOutEpicenterView);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("Exiting Transition: " + transition));
                        Log.v((String)"FragmentManager", (String)">>>>> ExitingViews <<<<<");
                        iterator = transitioningViews.iterator();
                        while (iterator.hasNext()) {
                            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"transitioningViews");
                            Log.v((String)"FragmentManager", (String)("View: " + view));
                        }
                    }
                }
                if (transitionInfo.isOverlapAllowed()) {
                    mergedTransition = this.transitionImpl.mergeTransitionsTogether(mergedTransition, transition, null);
                    continue;
                }
                mergedNonOverlappingTransition = this.transitionImpl.mergeTransitionsTogether(mergedNonOverlappingTransition, transition, null);
            }
            mergedTransition = this.transitionImpl.mergeTransitionsInSequence(mergedTransition, mergedNonOverlappingTransition, this.sharedElementTransition);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Final merged transition: " + mergedTransition));
            }
            return new Pair(enteringViews, mergedTransition);
        }

        private final void runTransition(ArrayList<View> enteringViews, ViewGroup container, Function0<Unit> executeTransition) {
            FragmentTransition.setViewVisibility((List<? extends View>)enteringViews, 4);
            ArrayList<String> inNames = this.transitionImpl.prepareSetNameOverridesReordered(this.sharedElementLastInViews);
            if (FragmentManager.isLoggingEnabled(2)) {
                View view;
                Log.v((String)"FragmentManager", (String)">>>>> Beginning transition <<<<<");
                Log.v((String)"FragmentManager", (String)">>>>> SharedElementFirstOutViews <<<<<");
                Iterator<View> iterator = this.sharedElementFirstOutViews.iterator();
                while (iterator.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"sharedElementFirstOutViews");
                    Log.v((String)"FragmentManager", (String)("View: " + view + " Name: " + ViewCompat.getTransitionName((View)view)));
                }
                Log.v((String)"FragmentManager", (String)">>>>> SharedElementLastInViews <<<<<");
                iterator = this.sharedElementLastInViews.iterator();
                while (iterator.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"sharedElementLastInViews");
                    Log.v((String)"FragmentManager", (String)("View: " + view + " Name: " + ViewCompat.getTransitionName((View)view)));
                }
            }
            executeTransition.invoke();
            this.transitionImpl.setNameOverridesReordered((View)container, this.sharedElementFirstOutViews, this.sharedElementLastInViews, inNames, (Map)this.sharedElementNameMapping);
            FragmentTransition.setViewVisibility((List<? extends View>)enteringViews, 0);
            this.transitionImpl.swapSharedElementTargets(this.sharedElementTransition, this.sharedElementFirstOutViews, this.sharedElementLastInViews);
        }

        @Override
        public void onCancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.transitionSignal.cancel();
        }

        private final void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
            if (view instanceof ViewGroup) {
                if (ViewGroupCompat.isTransitionGroup((ViewGroup)((ViewGroup)view))) {
                    if (!transitioningViews.contains(view)) {
                        transitioningViews.add(view);
                    }
                } else {
                    int count = ((ViewGroup)view).getChildCount();
                    for (int i = 0; i < count; ++i) {
                        View child = ((ViewGroup)view).getChildAt(i);
                        if (child.getVisibility() != 0) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                        this.captureTransitioningViews(transitioningViews, child);
                    }
                }
            } else if (!transitioningViews.contains(view)) {
                transitioningViews.add(view);
            }
        }

        private static final void onStart$lambda$6$lambda$4(Ref.ObjectRef $seekCancelLambda) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$seekCancelLambda, (String)"$seekCancelLambda");
                Function0 function0 = (Function0)$seekCancelLambda.element;
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        private static final void onStart$lambda$6$lambda$5(SpecialEffectsController.Operation $operation, TransitionEffect this$0) {
            Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Transition for operation " + $operation + " has completed"));
            }
            $operation.completeEffect(this$0);
        }

        private static final void onCommit$lambda$11$lambda$10(SpecialEffectsController.Operation $operation, TransitionEffect this$0) {
            Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Transition for operation " + $operation + " has completed"));
            }
            $operation.completeEffect(this$0);
        }

        private static final void createMergedTransition$lambda$12(SpecialEffectsController.Operation $lastIn, SpecialEffectsController.Operation $firstOut, TransitionEffect this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            FragmentTransition.callSharedElementStartEnd($lastIn.getFragment(), $firstOut.getFragment(), this$0.isPop, this$0.lastInViews, false);
        }

        private static final void createMergedTransition$lambda$13(FragmentTransitionImpl $impl, View $lastInEpicenterView, Rect $lastInEpicenterRect) {
            Intrinsics.checkNotNullParameter((Object)$impl, (String)"$impl");
            Intrinsics.checkNotNullParameter((Object)$lastInEpicenterRect, (String)"$lastInEpicenterRect");
            $impl.getBoundsOnScreen($lastInEpicenterView, $lastInEpicenterRect);
        }

        private static final void createMergedTransition$lambda$14(ArrayList $transitioningViews) {
            Intrinsics.checkNotNullParameter((Object)$transitioningViews, (String)"$transitioningViews");
            FragmentTransition.setViewVisibility($transitioningViews, 4);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u0014\u001a\u00020\u0005R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0015"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionInfo;", "Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "isPop", "", "providesSharedElementTransition", "(Landroidx/fragment/app/SpecialEffectsController$Operation;ZZ)V", "handlingImpl", "Landroidx/fragment/app/FragmentTransitionImpl;", "getHandlingImpl", "()Landroidx/fragment/app/FragmentTransitionImpl;", "isOverlapAllowed", "()Z", "sharedElementTransition", "", "getSharedElementTransition", "()Ljava/lang/Object;", "transition", "getTransition", "hasSharedElementTransition", "fragment_release"})
    private static final class TransitionInfo
    extends SpecialEffectsInfo {
        @Nullable
        private final Object transition;
        private final boolean isOverlapAllowed;
        @Nullable
        private final Object sharedElementTransition;

        public TransitionInfo(@NotNull SpecialEffectsController.Operation operation, boolean isPop, boolean providesSharedElementTransition) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            super(operation);
            Object object = operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE ? (isPop ? operation.getFragment().getReenterTransition() : operation.getFragment().getEnterTransition()) : (this.transition = isPop ? operation.getFragment().getReturnTransition() : operation.getFragment().getExitTransition());
            boolean bl = operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE ? (isPop ? operation.getFragment().getAllowReturnTransitionOverlap() : operation.getFragment().getAllowEnterTransitionOverlap()) : (this.isOverlapAllowed = true);
            this.sharedElementTransition = providesSharedElementTransition ? (isPop ? operation.getFragment().getSharedElementReturnTransition() : operation.getFragment().getSharedElementEnterTransition()) : null;
        }

        @Nullable
        public final Object getTransition() {
            return this.transition;
        }

        public final boolean isOverlapAllowed() {
            return this.isOverlapAllowed;
        }

        @Nullable
        public final Object getSharedElementTransition() {
            return this.sharedElementTransition;
        }

        public final boolean hasSharedElementTransition() {
            return this.sharedElementTransition != null;
        }

        @Nullable
        public final FragmentTransitionImpl getHandlingImpl() {
            FragmentTransitionImpl transitionImpl = this.getHandlingImpl(this.transition);
            FragmentTransitionImpl sharedElementTransitionImpl = this.getHandlingImpl(this.sharedElementTransition);
            if (!(transitionImpl == null || sharedElementTransitionImpl == null || transitionImpl == sharedElementTransitionImpl)) {
                boolean bl = false;
                String string = "Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + this.getOperation().getFragment() + " returned Transition " + this.transition + " which uses a different Transition  type than its shared element transition " + this.sharedElementTransition;
                throw new IllegalArgumentException(string.toString());
            }
            FragmentTransitionImpl fragmentTransitionImpl = transitionImpl;
            if (fragmentTransitionImpl == null) {
                fragmentTransitionImpl = sharedElementTransitionImpl;
            }
            return fragmentTransitionImpl;
        }

        private final FragmentTransitionImpl getHandlingImpl(Object transition) {
            if (transition == null) {
                return null;
            }
            if (FragmentTransition.PLATFORM_IMPL != null && FragmentTransition.PLATFORM_IMPL.canHandle(transition)) {
                return FragmentTransition.PLATFORM_IMPL;
            }
            if (FragmentTransition.SUPPORT_IMPL != null && FragmentTransition.SUPPORT_IMPL.canHandle(transition)) {
                return FragmentTransition.SUPPORT_IMPL;
            }
            throw new IllegalArgumentException("Transition " + transition + " for fragment " + this.getOperation().getFragment() + " is not a valid framework Transition or AndroidX Transition");
        }
    }
}

