/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.os.CancellationSignal;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransitionImpl;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
class FragmentTransitionCompat21
extends FragmentTransitionImpl {
    FragmentTransitionCompat21() {
    }

    @Override
    public boolean canHandle(@NonNull Object transition) {
        return transition instanceof Transition;
    }

    @Override
    public Object cloneTransition(@Nullable Object transition) {
        Transition copy = null;
        if (transition != null) {
            copy = ((Transition)transition).clone();
        }
        return copy;
    }

    @Override
    public Object wrapTransitionInSet(@Nullable Object transition) {
        if (transition == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition((Transition)transition);
        return transitionSet;
    }

    @Override
    public void setSharedElementTargets(@NonNull Object transitionObj, @NonNull View nonExistentView, @NonNull ArrayList<View> sharedViews) {
        TransitionSet transition = (TransitionSet)transitionObj;
        List views = transition.getTargets();
        views.clear();
        int count = sharedViews.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedViews.get(i);
            FragmentTransitionCompat21.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        this.addTargets(transition, sharedViews);
    }

    @Override
    public void setEpicenter(@NonNull Object transitionObj, @Nullable View view) {
        if (view != null) {
            Transition transition = (Transition)transitionObj;
            final Rect epicenter = new Rect();
            this.getBoundsOnScreen(view, epicenter);
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                public Rect onGetEpicenter(Transition transition) {
                    return epicenter;
                }
            });
        }
    }

    @Override
    public void addTargets(@NonNull Object transitionObj, @NonNull ArrayList<View> views) {
        block4: {
            List targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (transition == null) {
                    return;
                }
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    this.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || !FragmentTransitionCompat21.isNullOrEmpty(targets = transition.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition) {
        return !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetIds()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetNames()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetTypes());
    }

    @Override
    public Object mergeTransitionsTogether(@Nullable Object transition1, @Nullable Object transition2, @Nullable Object transition3) {
        TransitionSet transitionSet = new TransitionSet();
        if (transition1 != null) {
            transitionSet.addTransition((Transition)transition1);
        }
        if (transition2 != null) {
            transitionSet.addTransition((Transition)transition2);
        }
        if (transition3 != null) {
            transitionSet.addTransition((Transition)transition3);
        }
        return transitionSet;
    }

    @Override
    public void scheduleHideFragmentView(@NonNull Object exitTransitionObj, final @NonNull View fragmentView, final @NonNull ArrayList<View> exitingViews) {
        Transition exitTransition = (Transition)exitTransitionObj;
        exitTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
                transition.removeListener((Transition.TransitionListener)this);
                transition.addListener((Transition.TransitionListener)this);
            }

            public void onTransitionEnd(Transition transition) {
                transition.removeListener((Transition.TransitionListener)this);
                fragmentView.setVisibility(8);
                int numViews = exitingViews.size();
                for (int i = 0; i < numViews; ++i) {
                    ((View)exitingViews.get(i)).setVisibility(0);
                }
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    @Override
    public Object mergeTransitionsInSequence(@Nullable Object exitTransitionObj, @Nullable Object enterTransitionObj, @Nullable Object sharedElementTransitionObj) {
        Transition staggered = null;
        Transition exitTransition = (Transition)exitTransitionObj;
        Transition enterTransition = (Transition)enterTransitionObj;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObj;
        if (exitTransition != null && enterTransition != null) {
            staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
        } else if (exitTransition != null) {
            staggered = exitTransition;
        } else if (enterTransition != null) {
            staggered = enterTransition;
        }
        if (sharedElementTransition != null) {
            TransitionSet together = new TransitionSet();
            if (staggered != null) {
                together.addTransition(staggered);
            }
            together.addTransition(sharedElementTransition);
            return together;
        }
        return staggered;
    }

    @Override
    public void beginDelayedTransition(@NonNull ViewGroup sceneRoot, @Nullable Object transition) {
        TransitionManager.beginDelayedTransition((ViewGroup)sceneRoot, (Transition)((Transition)transition));
    }

    @Override
    public boolean isSeekingSupported() {
        if (FragmentManager.isLoggingEnabled(4)) {
            Log.i((String)"FragmentManager", (String)"Predictive back not available using Framework Transitions. Please switch to AndroidX Transition 1.5.0 or higher to enable seeking.");
        }
        return false;
    }

    @Override
    public boolean isSeekingSupported(@NonNull Object transition) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Predictive back not available for framework transition " + transition + ". Please switch to AndroidX Transition 1.5.0 or higher to enable seeking."));
        }
        return false;
    }

    @Override
    public void scheduleRemoveTargets(@NonNull Object overallTransitionObj, final @Nullable Object enterTransition, final @Nullable ArrayList<View> enteringViews, final @Nullable Object exitTransition, final @Nullable ArrayList<View> exitingViews, final @Nullable Object sharedElementTransition, final @Nullable ArrayList<View> sharedElementsIn) {
        Transition overallTransition = (Transition)overallTransitionObj;
        overallTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
                if (enterTransition != null) {
                    FragmentTransitionCompat21.this.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null) {
                    FragmentTransitionCompat21.this.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null) {
                    FragmentTransitionCompat21.this.replaceTargets(sharedElementTransition, sharedElementsIn, null);
                }
            }

            public void onTransitionEnd(Transition transition) {
                transition.removeListener((Transition.TransitionListener)this);
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    @Override
    public void setListenerForTransitionEnd(@NonNull Fragment outFragment, @NonNull Object transition, @NonNull CancellationSignal signal, final @NonNull Runnable transitionCompleteRunnable) {
        ((Transition)transition).addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
            }

            public void onTransitionEnd(Transition transition) {
                transitionCompleteRunnable.run();
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    @Override
    public void swapSharedElementTargets(@Nullable Object sharedElementTransitionObj, @Nullable ArrayList<View> sharedElementsOut, @Nullable ArrayList<View> sharedElementsIn) {
        TransitionSet sharedElementTransition = (TransitionSet)sharedElementTransitionObj;
        if (sharedElementTransition != null) {
            sharedElementTransition.getTargets().clear();
            sharedElementTransition.getTargets().addAll(sharedElementsIn);
            this.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    @Override
    public void replaceTargets(@NonNull Object transitionObj, @SuppressLint(value={"UnknownNullness"}) ArrayList<View> oldTargets, @SuppressLint(value={"UnknownNullness"}) ArrayList<View> newTargets) {
        block4: {
            int i;
            List targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    this.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || (targets = transition.getTargets()) == null || targets.size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition.removeTarget(oldTargets.get(i));
            }
        }
    }

    @Override
    public void addTarget(@NonNull Object transitionObj, @NonNull View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.addTarget(view);
        }
    }

    @Override
    public void removeTarget(@NonNull Object transitionObj, @NonNull View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.removeTarget(view);
        }
    }

    @Override
    public void setEpicenter(@NonNull Object transitionObj, final @NonNull Rect epicenter) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                public Rect onGetEpicenter(Transition transition) {
                    if (epicenter == null || epicenter.isEmpty()) {
                        return null;
                    }
                    return epicenter;
                }
            });
        }
    }
}

