/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager2.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.R;
import androidx.viewpager2.adapter.StatefulAdapter;
import androidx.viewpager2.widget.CompositeOnPageChangeCallback;
import androidx.viewpager2.widget.FakeDrag;
import androidx.viewpager2.widget.PageTransformerAdapter;
import androidx.viewpager2.widget.ScrollEventAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ViewPager2
extends ViewGroup {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    public static final int OFFSCREEN_PAGE_LIMIT_DEFAULT = -1;
    static boolean sFeatureEnhancedA11yEnabled = true;
    private final Rect mTmpContainerRect = new Rect();
    private final Rect mTmpChildRect = new Rect();
    private CompositeOnPageChangeCallback mExternalPageChangeCallbacks = new CompositeOnPageChangeCallback(3);
    int mCurrentItem;
    boolean mCurrentItemDirty = false;
    private RecyclerView.AdapterDataObserver mCurrentItemDataSetChangeObserver = new DataSetChangeObserver(){

        @Override
        public void onChanged() {
            ViewPager2.this.mCurrentItemDirty = true;
            ViewPager2.this.mScrollEventAdapter.notifyDataSetChangeHappened();
        }
    };
    LinearLayoutManager mLayoutManager;
    private int mPendingCurrentItem = -1;
    private Parcelable mPendingAdapterState;
    RecyclerView mRecyclerView;
    private PagerSnapHelper mPagerSnapHelper;
    ScrollEventAdapter mScrollEventAdapter;
    private CompositeOnPageChangeCallback mPageChangeEventDispatcher;
    private FakeDrag mFakeDragger;
    private PageTransformerAdapter mPageTransformerAdapter;
    private RecyclerView.ItemAnimator mSavedItemAnimator = null;
    private boolean mSavedItemAnimatorPresent = false;
    private boolean mUserInputEnabled = true;
    private int mOffscreenPageLimit = -1;
    AccessibilityProvider mAccessibilityProvider;

    public ViewPager2(@NonNull Context context) {
        super(context);
        this.initialize(context, null);
    }

    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    @RequiresApi(value=21)
    @SuppressLint(value={"ClassVerificationFailure"})
    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.mAccessibilityProvider = sFeatureEnhancedA11yEnabled ? new PageAwareAccessibilityProvider() : new BasicAccessibilityProvider();
        this.mRecyclerView = new RecyclerViewImpl(context);
        this.mRecyclerView.setId(View.generateViewId());
        this.mRecyclerView.setDescendantFocusability(131072);
        this.mLayoutManager = new LinearLayoutManagerImpl(context);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.setScrollingTouchSlop(1);
        this.setOrientation(context, attrs);
        this.mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.enforceChildFillListener());
        this.mScrollEventAdapter = new ScrollEventAdapter(this);
        this.mFakeDragger = new FakeDrag(this, this.mScrollEventAdapter, this.mRecyclerView);
        this.mPagerSnapHelper = new PagerSnapHelperImpl();
        this.mPagerSnapHelper.attachToRecyclerView(this.mRecyclerView);
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mScrollEventAdapter);
        this.mPageChangeEventDispatcher = new CompositeOnPageChangeCallback(3);
        this.mScrollEventAdapter.setOnPageChangeCallback(this.mPageChangeEventDispatcher);
        OnPageChangeCallback currentItemUpdater = new OnPageChangeCallback(){

            @Override
            public void onPageSelected(int position) {
                if (ViewPager2.this.mCurrentItem != position) {
                    ViewPager2.this.mCurrentItem = position;
                    ViewPager2.this.mAccessibilityProvider.onSetNewCurrentItem();
                }
            }

            @Override
            public void onPageScrollStateChanged(int newState) {
                if (newState == 0) {
                    ViewPager2.this.updateCurrentItem();
                }
            }
        };
        OnPageChangeCallback focusClearer = new OnPageChangeCallback(){

            @Override
            public void onPageSelected(int position) {
                ViewPager2.this.clearFocus();
                if (ViewPager2.this.hasFocus()) {
                    ViewPager2.this.mRecyclerView.requestFocus(2);
                }
            }
        };
        this.mPageChangeEventDispatcher.addOnPageChangeCallback(currentItemUpdater);
        this.mPageChangeEventDispatcher.addOnPageChangeCallback(focusClearer);
        this.mAccessibilityProvider.onInitialize(this.mPageChangeEventDispatcher, this.mRecyclerView);
        this.mPageChangeEventDispatcher.addOnPageChangeCallback(this.mExternalPageChangeCallbacks);
        this.mPageTransformerAdapter = new PageTransformerAdapter(this.mLayoutManager);
        this.mPageChangeEventDispatcher.addOnPageChangeCallback(this.mPageTransformerAdapter);
        this.attachViewToParent((View)this.mRecyclerView, 0, this.mRecyclerView.getLayoutParams());
    }

    private RecyclerView.OnChildAttachStateChangeListener enforceChildFillListener() {
        return new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(@NonNull View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (layoutParams.width != -1 || layoutParams.height != -1) {
                    throw new IllegalStateException("Pages must fill the whole ViewPager2 (use match_parent)");
                }
            }

            public void onChildViewDetachedFromWindow(@NonNull View view) {
            }
        };
    }

    @RequiresApi(value=23)
    public CharSequence getAccessibilityClassName() {
        if (this.mAccessibilityProvider.handlesGetAccessibilityClassName()) {
            return this.mAccessibilityProvider.onGetAccessibilityClassName();
        }
        return super.getAccessibilityClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrientation(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewPager2);
        ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])R.styleable.ViewPager2, (AttributeSet)attrs, (TypedArray)a, (int)0, (int)0);
        try {
            this.setOrientation(a.getInt(R.styleable.ViewPager2_android_orientation, 0));
        }
        finally {
            a.recycle();
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mRecyclerViewId = this.mRecyclerView.getId();
        int n = ss.mCurrentItem = this.mPendingCurrentItem == -1 ? this.mCurrentItem : this.mPendingCurrentItem;
        if (this.mPendingAdapterState != null) {
            ss.mAdapterState = this.mPendingAdapterState;
        } else {
            RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
            if (adapter instanceof StatefulAdapter) {
                ss.mAdapterState = ((StatefulAdapter)adapter).saveState();
            }
        }
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mPendingCurrentItem = ss.mCurrentItem;
        this.mPendingAdapterState = ss.mAdapterState;
    }

    private void restorePendingState() {
        if (this.mPendingCurrentItem == -1) {
            return;
        }
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            return;
        }
        if (this.mPendingAdapterState != null) {
            if (adapter instanceof StatefulAdapter) {
                ((StatefulAdapter)adapter).restoreState(this.mPendingAdapterState);
            }
            this.mPendingAdapterState = null;
        }
        this.mCurrentItem = Math.max(0, Math.min(this.mPendingCurrentItem, adapter.getItemCount() - 1));
        this.mPendingCurrentItem = -1;
        this.mRecyclerView.scrollToPosition(this.mCurrentItem);
        this.mAccessibilityProvider.onRestorePendingState();
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable state = (Parcelable)container.get(this.getId());
        if (state instanceof SavedState) {
            int previousRvId = ((SavedState)state).mRecyclerViewId;
            int currentRvId = this.mRecyclerView.getId();
            container.put(currentRvId, (Object)((Parcelable)container.get(previousRvId)));
            container.remove(previousRvId);
        }
        super.dispatchRestoreInstanceState(container);
        this.restorePendingState();
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        RecyclerView.Adapter currentAdapter = this.mRecyclerView.getAdapter();
        this.mAccessibilityProvider.onDetachAdapter(currentAdapter);
        this.unregisterCurrentItemDataSetTracker(currentAdapter);
        this.mRecyclerView.setAdapter(adapter);
        this.mCurrentItem = 0;
        this.restorePendingState();
        this.mAccessibilityProvider.onAttachAdapter(adapter);
        this.registerCurrentItemDataSetTracker(adapter);
    }

    private void registerCurrentItemDataSetTracker(@Nullable RecyclerView.Adapter<?> adapter) {
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mCurrentItemDataSetChangeObserver);
        }
    }

    private void unregisterCurrentItemDataSetTracker(@Nullable RecyclerView.Adapter<?> adapter) {
        if (adapter != null) {
            adapter.unregisterAdapterDataObserver(this.mCurrentItemDataSetChangeObserver);
        }
    }

    @Nullable
    public RecyclerView.Adapter getAdapter() {
        return this.mRecyclerView.getAdapter();
    }

    public void onViewAdded(View child) {
        throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " does not support direct child views");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChild((View)this.mRecyclerView, widthMeasureSpec, heightMeasureSpec);
        int width = this.mRecyclerView.getMeasuredWidth();
        int height = this.mRecyclerView.getMeasuredHeight();
        int childState = this.mRecyclerView.getMeasuredState();
        width += this.getPaddingLeft() + this.getPaddingRight();
        height += this.getPaddingTop() + this.getPaddingBottom();
        width = Math.max(width, this.getSuggestedMinimumWidth());
        height = Math.max(height, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(ViewPager2.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)childState), ViewPager2.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.mRecyclerView.getMeasuredWidth();
        int height = this.mRecyclerView.getMeasuredHeight();
        this.mTmpContainerRect.left = this.getPaddingLeft();
        this.mTmpContainerRect.right = r - l - this.getPaddingRight();
        this.mTmpContainerRect.top = this.getPaddingTop();
        this.mTmpContainerRect.bottom = b - t - this.getPaddingBottom();
        Gravity.apply((int)0x800033, (int)width, (int)height, (Rect)this.mTmpContainerRect, (Rect)this.mTmpChildRect);
        this.mRecyclerView.layout(this.mTmpChildRect.left, this.mTmpChildRect.top, this.mTmpChildRect.right, this.mTmpChildRect.bottom);
        if (this.mCurrentItemDirty) {
            this.updateCurrentItem();
        }
    }

    void updateCurrentItem() {
        if (this.mPagerSnapHelper == null) {
            throw new IllegalStateException("Design assumption violated.");
        }
        View snapView = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this.mLayoutManager);
        if (snapView == null) {
            return;
        }
        int snapPosition = this.mLayoutManager.getPosition(snapView);
        if (snapPosition != this.mCurrentItem && this.getScrollState() == 0) {
            this.mPageChangeEventDispatcher.onPageSelected(snapPosition);
        }
        this.mCurrentItemDirty = false;
    }

    int getPageSize() {
        RecyclerView rv = this.mRecyclerView;
        return this.getOrientation() == 0 ? rv.getWidth() - rv.getPaddingLeft() - rv.getPaddingRight() : rv.getHeight() - rv.getPaddingTop() - rv.getPaddingBottom();
    }

    public void setOrientation(int orientation) {
        this.mLayoutManager.setOrientation(orientation);
        this.mAccessibilityProvider.onSetOrientation();
    }

    public int getOrientation() {
        return this.mLayoutManager.getOrientation() == 1 ? 1 : 0;
    }

    boolean isRtl() {
        return this.mLayoutManager.getLayoutDirection() == 1;
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.isFakeDragging()) {
            throw new IllegalStateException("Cannot change current item when ViewPager2 is fake dragging");
        }
        this.setCurrentItemInternal(item, smoothScroll);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll) {
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            if (this.mPendingCurrentItem != -1) {
                this.mPendingCurrentItem = Math.max(item, 0);
            }
            return;
        }
        if (adapter.getItemCount() <= 0) {
            return;
        }
        item = Math.max(item, 0);
        if ((item = Math.min(item, adapter.getItemCount() - 1)) == this.mCurrentItem && this.mScrollEventAdapter.isIdle()) {
            return;
        }
        if (item == this.mCurrentItem && smoothScroll) {
            return;
        }
        double previousItem = this.mCurrentItem;
        this.mCurrentItem = item;
        this.mAccessibilityProvider.onSetNewCurrentItem();
        if (!this.mScrollEventAdapter.isIdle()) {
            previousItem = this.mScrollEventAdapter.getRelativeScrollPosition();
        }
        this.mScrollEventAdapter.notifyProgrammaticScroll(item, smoothScroll);
        if (!smoothScroll) {
            this.mRecyclerView.scrollToPosition(item);
            return;
        }
        if (Math.abs((double)item - previousItem) > 3.0) {
            this.mRecyclerView.scrollToPosition((double)item > previousItem ? item - 3 : item + 3);
            this.mRecyclerView.post((Runnable)new SmoothScrollToPosition(item, this.mRecyclerView));
        } else {
            this.mRecyclerView.smoothScrollToPosition(item);
        }
    }

    public int getCurrentItem() {
        return this.mCurrentItem;
    }

    public int getScrollState() {
        return this.mScrollEventAdapter.getScrollState();
    }

    public boolean beginFakeDrag() {
        return this.mFakeDragger.beginFakeDrag();
    }

    public boolean fakeDragBy(@SuppressLint(value={"SupportAnnotationUsage"}) @Px float offsetPxFloat) {
        return this.mFakeDragger.fakeDragBy(offsetPxFloat);
    }

    public boolean endFakeDrag() {
        return this.mFakeDragger.endFakeDrag();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragger.isFakeDragging();
    }

    void snapToPage() {
        View view = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this.mLayoutManager);
        if (view == null) {
            return;
        }
        int[] snapDistance = this.mPagerSnapHelper.calculateDistanceToFinalSnap((RecyclerView.LayoutManager)this.mLayoutManager, view);
        if (snapDistance[0] != 0 || snapDistance[1] != 0) {
            this.mRecyclerView.smoothScrollBy(snapDistance[0], snapDistance[1]);
        }
    }

    public void setUserInputEnabled(boolean enabled) {
        this.mUserInputEnabled = enabled;
        this.mAccessibilityProvider.onSetUserInputEnabled();
    }

    public boolean isUserInputEnabled() {
        return this.mUserInputEnabled;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1 && limit != -1) {
            throw new IllegalArgumentException("Offscreen page limit must be OFFSCREEN_PAGE_LIMIT_DEFAULT or a number > 0");
        }
        this.mOffscreenPageLimit = limit;
        this.mRecyclerView.requestLayout();
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mRecyclerView.canScrollHorizontally(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.mRecyclerView.canScrollVertically(direction);
    }

    public void registerOnPageChangeCallback(@NonNull OnPageChangeCallback callback) {
        this.mExternalPageChangeCallbacks.addOnPageChangeCallback(callback);
    }

    public void unregisterOnPageChangeCallback(@NonNull OnPageChangeCallback callback) {
        this.mExternalPageChangeCallbacks.removeOnPageChangeCallback(callback);
    }

    public void setPageTransformer(@Nullable PageTransformer transformer) {
        if (transformer != null) {
            if (!this.mSavedItemAnimatorPresent) {
                this.mSavedItemAnimator = this.mRecyclerView.getItemAnimator();
                this.mSavedItemAnimatorPresent = true;
            }
            this.mRecyclerView.setItemAnimator(null);
        } else if (this.mSavedItemAnimatorPresent) {
            this.mRecyclerView.setItemAnimator(this.mSavedItemAnimator);
            this.mSavedItemAnimator = null;
            this.mSavedItemAnimatorPresent = false;
        }
        if (transformer == this.mPageTransformerAdapter.getPageTransformer()) {
            return;
        }
        this.mPageTransformerAdapter.setPageTransformer(transformer);
        this.requestTransform();
    }

    public void requestTransform() {
        if (this.mPageTransformerAdapter.getPageTransformer() == null) {
            return;
        }
        double relativePosition = this.mScrollEventAdapter.getRelativeScrollPosition();
        int position = (int)relativePosition;
        float positionOffset = (float)(relativePosition - (double)position);
        int positionOffsetPx = Math.round((float)this.getPageSize() * positionOffset);
        this.mPageTransformerAdapter.onPageScrolled(position, positionOffset, positionOffsetPx);
    }

    public void setLayoutDirection(int layoutDirection) {
        super.setLayoutDirection(layoutDirection);
        this.mAccessibilityProvider.onSetLayoutDirection();
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        this.mAccessibilityProvider.onInitializeAccessibilityNodeInfo(info);
    }

    public boolean performAccessibilityAction(int action, @Nullable Bundle arguments) {
        if (this.mAccessibilityProvider.handlesPerformAccessibilityAction(action, arguments)) {
            return this.mAccessibilityProvider.onPerformAccessibilityAction(action, arguments);
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.addItemDecoration(decor);
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        this.mRecyclerView.addItemDecoration(decor, index);
    }

    @NonNull
    public RecyclerView.ItemDecoration getItemDecorationAt(int index) {
        return this.mRecyclerView.getItemDecorationAt(index);
    }

    public int getItemDecorationCount() {
        return this.mRecyclerView.getItemDecorationCount();
    }

    public void invalidateItemDecorations() {
        this.mRecyclerView.invalidateItemDecorations();
    }

    public void removeItemDecorationAt(int index) {
        this.mRecyclerView.removeItemDecorationAt(index);
    }

    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.removeItemDecoration(decor);
    }

    class PageAwareAccessibilityProvider
    extends AccessibilityProvider {
        private final AccessibilityViewCommand mActionPageForward;
        private final AccessibilityViewCommand mActionPageBackward;
        private RecyclerView.AdapterDataObserver mAdapterDataObserver;

        PageAwareAccessibilityProvider() {
            this.mActionPageForward = new AccessibilityViewCommand(){

                public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                    ViewPager2 viewPager = (ViewPager2)view;
                    PageAwareAccessibilityProvider.this.setCurrentItemFromAccessibilityCommand(viewPager.getCurrentItem() + 1);
                    return true;
                }
            };
            this.mActionPageBackward = new AccessibilityViewCommand(){

                public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                    ViewPager2 viewPager = (ViewPager2)view;
                    PageAwareAccessibilityProvider.this.setCurrentItemFromAccessibilityCommand(viewPager.getCurrentItem() - 1);
                    return true;
                }
            };
        }

        @Override
        public void onInitialize(@NonNull CompositeOnPageChangeCallback pageChangeEventDispatcher, @NonNull RecyclerView recyclerView) {
            recyclerView.setImportantForAccessibility(2);
            this.mAdapterDataObserver = new DataSetChangeObserver(){

                @Override
                public void onChanged() {
                    PageAwareAccessibilityProvider.this.updatePageAccessibilityActions();
                }
            };
            if (ViewPager2.this.getImportantForAccessibility() == 0) {
                ViewPager2.this.setImportantForAccessibility(1);
            }
        }

        @Override
        public boolean handlesGetAccessibilityClassName() {
            return true;
        }

        @Override
        public String onGetAccessibilityClassName() {
            if (!this.handlesGetAccessibilityClassName()) {
                throw new IllegalStateException();
            }
            return "androidx.viewpager.widget.ViewPager";
        }

        @Override
        public void onRestorePendingState() {
            this.updatePageAccessibilityActions();
        }

        @Override
        public void onAttachAdapter(@Nullable RecyclerView.Adapter<?> newAdapter) {
            this.updatePageAccessibilityActions();
            if (newAdapter != null) {
                newAdapter.registerAdapterDataObserver(this.mAdapterDataObserver);
            }
        }

        @Override
        public void onDetachAdapter(@Nullable RecyclerView.Adapter<?> oldAdapter) {
            if (oldAdapter != null) {
                oldAdapter.unregisterAdapterDataObserver(this.mAdapterDataObserver);
            }
        }

        @Override
        public void onSetOrientation() {
            this.updatePageAccessibilityActions();
        }

        @Override
        public void onSetNewCurrentItem() {
            this.updatePageAccessibilityActions();
        }

        @Override
        public void onSetUserInputEnabled() {
            this.updatePageAccessibilityActions();
            if (Build.VERSION.SDK_INT < 21) {
                ViewPager2.this.sendAccessibilityEvent(2048);
            }
        }

        @Override
        public void onSetLayoutDirection() {
            this.updatePageAccessibilityActions();
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
            this.addCollectionInfo(infoCompat);
            this.addScrollActions(infoCompat);
        }

        @Override
        void onLmInitializeAccessibilityNodeInfoForItem(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
            this.addCollectionItemInfo(host, info);
        }

        @Override
        public boolean handlesPerformAccessibilityAction(int action, Bundle arguments) {
            return action == 8192 || action == 4096;
        }

        @Override
        public boolean onPerformAccessibilityAction(int action, Bundle arguments) {
            if (!this.handlesPerformAccessibilityAction(action, arguments)) {
                throw new IllegalStateException();
            }
            int nextItem = action == 8192 ? ViewPager2.this.getCurrentItem() - 1 : ViewPager2.this.getCurrentItem() + 1;
            this.setCurrentItemFromAccessibilityCommand(nextItem);
            return true;
        }

        @Override
        public void onRvInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
            event.setSource((View)ViewPager2.this);
            event.setClassName((CharSequence)this.onGetAccessibilityClassName());
        }

        void setCurrentItemFromAccessibilityCommand(int item) {
            if (ViewPager2.this.isUserInputEnabled()) {
                ViewPager2.this.setCurrentItemInternal(item, true);
            }
        }

        void updatePageAccessibilityActions() {
            ViewPager2 viewPager = ViewPager2.this;
            int actionIdPageLeft = 16908360;
            int actionIdPageRight = 16908361;
            int actionIdPageUp = 16908358;
            int actionIdPageDown = 16908359;
            ViewCompat.removeAccessibilityAction((View)viewPager, (int)16908360);
            ViewCompat.removeAccessibilityAction((View)viewPager, (int)16908361);
            ViewCompat.removeAccessibilityAction((View)viewPager, (int)16908358);
            ViewCompat.removeAccessibilityAction((View)viewPager, (int)16908359);
            if (ViewPager2.this.getAdapter() == null) {
                return;
            }
            int itemCount = ViewPager2.this.getAdapter().getItemCount();
            if (itemCount == 0) {
                return;
            }
            if (!ViewPager2.this.isUserInputEnabled()) {
                return;
            }
            if (ViewPager2.this.getOrientation() == 0) {
                int actionIdPageBackward;
                boolean isLayoutRtl = ViewPager2.this.isRtl();
                int actionIdPageForward = isLayoutRtl ? 16908360 : 16908361;
                int n = actionIdPageBackward = isLayoutRtl ? 16908361 : 16908360;
                if (ViewPager2.this.mCurrentItem < itemCount - 1) {
                    ViewCompat.replaceAccessibilityAction((View)viewPager, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)new AccessibilityNodeInfoCompat.AccessibilityActionCompat(actionIdPageForward, null), null, (AccessibilityViewCommand)this.mActionPageForward);
                }
                if (ViewPager2.this.mCurrentItem > 0) {
                    ViewCompat.replaceAccessibilityAction((View)viewPager, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)new AccessibilityNodeInfoCompat.AccessibilityActionCompat(actionIdPageBackward, null), null, (AccessibilityViewCommand)this.mActionPageBackward);
                }
            } else {
                if (ViewPager2.this.mCurrentItem < itemCount - 1) {
                    ViewCompat.replaceAccessibilityAction((View)viewPager, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16908359, null), null, (AccessibilityViewCommand)this.mActionPageForward);
                }
                if (ViewPager2.this.mCurrentItem > 0) {
                    ViewCompat.replaceAccessibilityAction((View)viewPager, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16908358, null), null, (AccessibilityViewCommand)this.mActionPageBackward);
                }
            }
        }

        private void addCollectionInfo(AccessibilityNodeInfoCompat infoCompat) {
            int rowCount = 0;
            int colCount = 0;
            if (ViewPager2.this.getAdapter() != null) {
                if (ViewPager2.this.getOrientation() == 1) {
                    rowCount = ViewPager2.this.getAdapter().getItemCount();
                    colCount = 1;
                } else {
                    colCount = ViewPager2.this.getAdapter().getItemCount();
                    rowCount = 1;
                }
            }
            AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfo = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)rowCount, (int)colCount, (boolean)false, (int)0);
            infoCompat.setCollectionInfo((Object)collectionInfo);
        }

        private void addCollectionItemInfo(View host, AccessibilityNodeInfoCompat infoCompat) {
            int rowIndex = ViewPager2.this.getOrientation() == 1 ? ViewPager2.this.mLayoutManager.getPosition(host) : 0;
            int colIndex = ViewPager2.this.getOrientation() == 0 ? ViewPager2.this.mLayoutManager.getPosition(host) : 0;
            AccessibilityNodeInfoCompat.CollectionItemInfoCompat collectionItemInfoCompat = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)rowIndex, (int)1, (int)colIndex, (int)1, (boolean)false, (boolean)false);
            infoCompat.setCollectionItemInfo((Object)collectionItemInfoCompat);
        }

        private void addScrollActions(AccessibilityNodeInfoCompat infoCompat) {
            RecyclerView.Adapter adapter = ViewPager2.this.getAdapter();
            if (adapter == null) {
                return;
            }
            int itemCount = adapter.getItemCount();
            if (itemCount == 0 || !ViewPager2.this.isUserInputEnabled()) {
                return;
            }
            if (ViewPager2.this.mCurrentItem > 0) {
                infoCompat.addAction(8192);
            }
            if (ViewPager2.this.mCurrentItem < itemCount - 1) {
                infoCompat.addAction(4096);
            }
            infoCompat.setScrollable(true);
        }
    }

    class BasicAccessibilityProvider
    extends AccessibilityProvider {
        BasicAccessibilityProvider() {
        }

        @Override
        public boolean handlesLmPerformAccessibilityAction(int action) {
            return (action == 8192 || action == 4096) && !ViewPager2.this.isUserInputEnabled();
        }

        @Override
        public boolean onLmPerformAccessibilityAction(int action) {
            if (!this.handlesLmPerformAccessibilityAction(action)) {
                throw new IllegalStateException();
            }
            return false;
        }

        @Override
        public void onLmInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfoCompat info) {
            if (!ViewPager2.this.isUserInputEnabled()) {
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD);
                info.setScrollable(false);
            }
        }

        @Override
        public boolean handlesRvGetAccessibilityClassName() {
            return true;
        }

        @Override
        public CharSequence onRvGetAccessibilityClassName() {
            if (!this.handlesRvGetAccessibilityClassName()) {
                throw new IllegalStateException();
            }
            return "androidx.viewpager.widget.ViewPager";
        }
    }

    private abstract class AccessibilityProvider {
        private AccessibilityProvider() {
        }

        void onInitialize(@NonNull CompositeOnPageChangeCallback pageChangeEventDispatcher, @NonNull RecyclerView recyclerView) {
        }

        boolean handlesGetAccessibilityClassName() {
            return false;
        }

        String onGetAccessibilityClassName() {
            throw new IllegalStateException("Not implemented.");
        }

        void onRestorePendingState() {
        }

        void onAttachAdapter(@Nullable RecyclerView.Adapter<?> newAdapter) {
        }

        void onDetachAdapter(@Nullable RecyclerView.Adapter<?> oldAdapter) {
        }

        void onSetOrientation() {
        }

        void onSetNewCurrentItem() {
        }

        void onSetUserInputEnabled() {
        }

        void onSetLayoutDirection() {
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        }

        boolean handlesPerformAccessibilityAction(int action, Bundle arguments) {
            return false;
        }

        boolean onPerformAccessibilityAction(int action, Bundle arguments) {
            throw new IllegalStateException("Not implemented.");
        }

        void onRvInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        }

        boolean handlesLmPerformAccessibilityAction(int action) {
            return false;
        }

        boolean onLmPerformAccessibilityAction(int action) {
            throw new IllegalStateException("Not implemented.");
        }

        void onLmInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfoCompat info) {
        }

        void onLmInitializeAccessibilityNodeInfoForItem(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
        }

        boolean handlesRvGetAccessibilityClassName() {
            return false;
        }

        CharSequence onRvGetAccessibilityClassName() {
            throw new IllegalStateException("Not implemented.");
        }
    }

    private class RecyclerViewImpl
    extends RecyclerView {
        RecyclerViewImpl(Context context) {
            super(context);
        }

        @RequiresApi(value=23)
        public CharSequence getAccessibilityClassName() {
            if (ViewPager2.this.mAccessibilityProvider.handlesRvGetAccessibilityClassName()) {
                return ViewPager2.this.mAccessibilityProvider.onRvGetAccessibilityClassName();
            }
            return super.getAccessibilityClassName();
        }

        public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setFromIndex(ViewPager2.this.mCurrentItem);
            event.setToIndex(ViewPager2.this.mCurrentItem);
            ViewPager2.this.mAccessibilityProvider.onRvInitializeAccessibilityEvent(event);
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(MotionEvent event) {
            return ViewPager2.this.isUserInputEnabled() && super.onTouchEvent(event);
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return ViewPager2.this.isUserInputEnabled() && super.onInterceptTouchEvent(ev);
        }
    }

    private class LinearLayoutManagerImpl
    extends LinearLayoutManager {
        LinearLayoutManagerImpl(Context context) {
            super(context);
        }

        public boolean performAccessibilityAction(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, int action, @Nullable Bundle args) {
            if (ViewPager2.this.mAccessibilityProvider.handlesLmPerformAccessibilityAction(action)) {
                return ViewPager2.this.mAccessibilityProvider.onLmPerformAccessibilityAction(action);
            }
            return super.performAccessibilityAction(recycler, state, action, args);
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(recycler, state, info);
            ViewPager2.this.mAccessibilityProvider.onLmInitializeAccessibilityNodeInfo(info);
        }

        public void onInitializeAccessibilityNodeInfoForItem(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
            ViewPager2.this.mAccessibilityProvider.onLmInitializeAccessibilityNodeInfoForItem(host, info);
        }

        protected void calculateExtraLayoutSpace(@NonNull RecyclerView.State state, @NonNull int[] extraLayoutSpace) {
            int offscreenSpace;
            int pageLimit = ViewPager2.this.getOffscreenPageLimit();
            if (pageLimit == -1) {
                super.calculateExtraLayoutSpace(state, extraLayoutSpace);
                return;
            }
            extraLayoutSpace[0] = offscreenSpace = ViewPager2.this.getPageSize() * pageLimit;
            extraLayoutSpace[1] = offscreenSpace;
        }

        public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
            return false;
        }
    }

    private class PagerSnapHelperImpl
    extends PagerSnapHelper {
        PagerSnapHelperImpl() {
        }

        @Nullable
        public View findSnapView(RecyclerView.LayoutManager layoutManager) {
            return ViewPager2.this.isFakeDragging() ? null : super.findSnapView(layoutManager);
        }
    }

    public static abstract class OnPageChangeCallback {
        public void onPageScrolled(int position, float positionOffset, @Px int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int mRecyclerViewId;
        int mCurrentItem;
        Parcelable mAdapterState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return Build.VERSION.SDK_INT >= 24 ? new SavedState(source, loader) : new SavedState(source);
            }

            public SavedState createFromParcel(Parcel source) {
                return this.createFromParcel(source, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        @RequiresApi(value=24)
        @SuppressLint(value={"ClassVerificationFailure"})
        SavedState(Parcel source, ClassLoader loader) {
            super(source, loader);
            this.readValues(source, loader);
        }

        SavedState(Parcel source) {
            super(source);
            this.readValues(source, null);
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        private void readValues(Parcel source, ClassLoader loader) {
            this.mRecyclerViewId = source.readInt();
            this.mCurrentItem = source.readInt();
            this.mAdapterState = source.readParcelable(loader);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mRecyclerViewId);
            out.writeInt(this.mCurrentItem);
            out.writeParcelable(this.mAdapterState, flags);
        }
    }

    private static class SmoothScrollToPosition
    implements Runnable {
        private final int mPosition;
        private final RecyclerView mRecyclerView;

        SmoothScrollToPosition(int position, RecyclerView recyclerView) {
            this.mPosition = position;
            this.mRecyclerView = recyclerView;
        }

        @Override
        public void run() {
            this.mRecyclerView.smoothScrollToPosition(this.mPosition);
        }
    }

    public static interface PageTransformer {
        public void transformPage(@NonNull View var1, float var2);
    }

    private static abstract class DataSetChangeObserver
    extends RecyclerView.AdapterDataObserver {
        private DataSetChangeObserver() {
        }

        public abstract void onChanged();

        public final void onItemRangeChanged(int positionStart, int itemCount) {
            this.onChanged();
        }

        public final void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            this.onChanged();
        }

        public final void onItemRangeInserted(int positionStart, int itemCount) {
            this.onChanged();
        }

        public final void onItemRangeRemoved(int positionStart, int itemCount) {
            this.onChanged();
        }

        public final void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.onChanged();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @IntRange(from=1L)
    public static @interface OffscreenPageLimit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface ScrollState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Orientation {
    }
}

