/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager2.widget;

import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

public final class WindowInsetsApplier
implements OnApplyWindowInsetsListener {
    private WindowInsetsApplier() {
    }

    public static boolean install(@NonNull ViewPager2 viewPager) {
        ApplicationInfo appInfo = viewPager.getContext().getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 30 && appInfo.targetSdkVersion >= 30) {
            return false;
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)viewPager, (OnApplyWindowInsetsListener)new WindowInsetsApplier());
        return true;
    }

    @NonNull
    public WindowInsetsCompat onApplyWindowInsets(@NonNull View v, @NonNull WindowInsetsCompat insets) {
        ViewPager2 viewPager = (ViewPager2)v;
        WindowInsetsCompat applied = ViewCompat.onApplyWindowInsets((View)viewPager, (WindowInsetsCompat)insets);
        if (applied.isConsumed()) {
            return applied;
        }
        RecyclerView rv = viewPager.mRecyclerView;
        int count = rv.getChildCount();
        for (int i = 0; i < count; ++i) {
            ViewCompat.dispatchApplyWindowInsets((View)rv.getChildAt(i), (WindowInsetsCompat)new WindowInsetsCompat(applied));
        }
        return this.consumeAllInsets(applied);
    }

    private WindowInsetsCompat consumeAllInsets(@NonNull WindowInsetsCompat insets) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (WindowInsetsCompat.CONSUMED.toWindowInsets() != null) {
                return WindowInsetsCompat.CONSUMED;
            }
            return insets.consumeSystemWindowInsets().consumeStableInsets();
        }
        return insets;
    }
}

