/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class CanvasUtils {
    private static Method sReorderBarrierMethod;
    private static Method sInorderBarrierMethod;
    private static boolean sOrderMethodsFetched;

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    static void enableZ(@NonNull Canvas canvas, boolean enable) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (enable) {
                    Api29Impl.enableZ(canvas);
                } else {
                    Api29Impl.disableZ(canvas);
                }
            } else {
                if (Build.VERSION.SDK_INT == 28) {
                    throw new IllegalStateException("This method doesn't work on Pie!");
                }
                if (!sOrderMethodsFetched) {
                    try {
                        sReorderBarrierMethod = Canvas.class.getDeclaredMethod("insertReorderBarrier", new Class[0]);
                        sReorderBarrierMethod.setAccessible(true);
                        sInorderBarrierMethod = Canvas.class.getDeclaredMethod("insertInorderBarrier", new Class[0]);
                        sInorderBarrierMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    sOrderMethodsFetched = true;
                }
                try {
                    if (enable && sReorderBarrierMethod != null) {
                        sReorderBarrierMethod.invoke((Object)canvas, new Object[0]);
                    }
                    if (!enable && sInorderBarrierMethod != null) {
                        sInorderBarrierMethod.invoke((Object)canvas, new Object[0]);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }
    }

    private CanvasUtils() {
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void enableZ(Canvas canvas) {
            canvas.enableZ();
        }

        @DoNotInline
        static void disableZ(Canvas canvas) {
            canvas.disableZ();
        }
    }
}

