/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.transition.R;
import androidx.transition.RectEvaluator;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;
import androidx.transition.ViewUtils;

public class ChangeClipBounds
extends Transition {
    private static final String PROPNAME_CLIP = "android:clipBounds:clip";
    private static final String PROPNAME_BOUNDS = "android:clipBounds:bounds";
    private static final String[] sTransitionProperties = new String[]{"android:clipBounds:clip"};
    static final Rect NULL_SENTINEL = new Rect();

    @Override
    @NonNull
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public ChangeClipBounds() {
    }

    public ChangeClipBounds(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean isSeekingSupported() {
        return true;
    }

    private void captureValues(TransitionValues values, boolean clipFromTag) {
        View view = values.view;
        if (view.getVisibility() == 8) {
            return;
        }
        Rect clip = null;
        if (clipFromTag) {
            clip = (Rect)view.getTag(R.id.transition_clip);
        }
        if (clip == null) {
            clip = view.getClipBounds();
        }
        if (clip == NULL_SENTINEL) {
            clip = null;
        }
        values.values.put(PROPNAME_CLIP, clip);
        if (clip == null) {
            Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
            values.values.put(PROPNAME_BOUNDS, bounds);
        }
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues, true);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues, false);
    }

    @Override
    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        Rect endClip;
        if (startValues == null || endValues == null || !startValues.values.containsKey(PROPNAME_CLIP) || !endValues.values.containsKey(PROPNAME_CLIP)) {
            return null;
        }
        Rect start = (Rect)startValues.values.get(PROPNAME_CLIP);
        Rect end = (Rect)endValues.values.get(PROPNAME_CLIP);
        if (start == null && end == null) {
            return null;
        }
        Rect startClip = start == null ? (Rect)startValues.values.get(PROPNAME_BOUNDS) : start;
        Rect rect = endClip = end == null ? (Rect)endValues.values.get(PROPNAME_BOUNDS) : end;
        if (startClip.equals((Object)endClip)) {
            return null;
        }
        endValues.view.setClipBounds(start);
        RectEvaluator evaluator = new RectEvaluator(new Rect());
        ObjectAnimator animator = ObjectAnimator.ofObject((Object)endValues.view, ViewUtils.CLIP_BOUNDS, (TypeEvaluator)evaluator, (Object[])new Rect[]{startClip, endClip});
        View view = endValues.view;
        Listener listener = new Listener(view, start, end);
        animator.addListener((Animator.AnimatorListener)listener);
        this.addListener(listener);
        return animator;
    }

    private static class Listener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final Rect mStart;
        private final Rect mEnd;
        private final View mView;

        Listener(View view, Rect start, Rect end) {
            this.mView = view;
            this.mStart = start;
            this.mEnd = end;
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            Rect clipBounds = this.mView.getClipBounds();
            if (clipBounds == null) {
                clipBounds = NULL_SENTINEL;
            }
            this.mView.setTag(R.id.transition_clip, (Object)clipBounds);
            this.mView.setClipBounds(this.mEnd);
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            Rect clipBounds = (Rect)this.mView.getTag(R.id.transition_clip);
            this.mView.setClipBounds(clipBounds);
            this.mView.setTag(R.id.transition_clip, null);
        }

        public void onAnimationEnd(Animator animation) {
            this.onAnimationEnd(animation, false);
        }

        public void onAnimationEnd(Animator animation, boolean isReverse) {
            if (!isReverse) {
                this.mView.setClipBounds(this.mEnd);
            } else {
                this.mView.setClipBounds(this.mStart);
            }
        }
    }
}

