/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.TypedArrayUtils;
import androidx.transition.R;
import androidx.transition.Styleable;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;
import androidx.transition.ViewUtils;
import androidx.transition.Visibility;
import org.xmlpull.v1.XmlPullParser;

public class Fade
extends Visibility {
    private static final String PROPNAME_TRANSITION_ALPHA = "android:fade:transitionAlpha";
    private static final String LOG_TAG = "Fade";
    public static final int IN = 1;
    public static final int OUT = 2;

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    public Fade() {
    }

    public Fade(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.FADE);
        int fadingMode = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)((XmlResourceParser)attrs), (String)"fadingMode", (int)0, (int)this.getMode());
        this.setMode(fadingMode);
        a.recycle();
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        Float alpha = (Float)transitionValues.view.getTag(R.id.transition_pause_alpha);
        if (alpha == null) {
            alpha = transitionValues.view.getVisibility() == 0 ? Float.valueOf(ViewUtils.getTransitionAlpha(transitionValues.view)) : Float.valueOf(0.0f);
        }
        transitionValues.values.put(PROPNAME_TRANSITION_ALPHA, alpha);
    }

    @Override
    public boolean isSeekingSupported() {
        return true;
    }

    private Animator createAnimation(View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        ViewUtils.setTransitionAlpha(view, startAlpha);
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, ViewUtils.TRANSITION_ALPHA, (float[])new float[]{endAlpha});
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim.addListener((Animator.AnimatorListener)listener);
        this.getRootTransition().addListener(listener);
        return anim;
    }

    @Override
    @Nullable
    public Animator onAppear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        ViewUtils.saveNonTransitionAlpha(view);
        float startAlpha = Fade.getStartAlpha(startValues, 0.0f);
        return this.createAnimation(view, startAlpha, 1.0f);
    }

    @Override
    @Nullable
    public Animator onDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        ViewUtils.saveNonTransitionAlpha(view);
        float startAlpha = Fade.getStartAlpha(startValues, 1.0f);
        Animator animator = this.createAnimation(view, startAlpha, 0.0f);
        if (animator == null) {
            ViewUtils.setTransitionAlpha(view, Fade.getStartAlpha(endValues, 1.0f));
        }
        return animator;
    }

    private static float getStartAlpha(TransitionValues startValues, float fallbackValue) {
        Float startAlphaFloat;
        float startAlpha = fallbackValue;
        if (startValues != null && (startAlphaFloat = (Float)startValues.values.get(PROPNAME_TRANSITION_ALPHA)) != null) {
            startAlpha = startAlphaFloat.floatValue();
        }
        return startAlpha;
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final View mView;
        private boolean mLayerTypeChanged = false;

        FadeAnimatorListener(View view) {
            this.mView = view;
        }

        public void onAnimationStart(Animator animation) {
            if (this.mView.hasOverlappingRendering() && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }

        public void onAnimationEnd(Animator animation) {
            this.onAnimationEnd(animation, false);
        }

        public void onAnimationEnd(@NonNull Animator animation, boolean isReverse) {
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
            if (!isReverse) {
                ViewUtils.setTransitionAlpha(this.mView, 1.0f);
                ViewUtils.clearNonTransitionAlpha(this.mView);
            }
        }

        public void onAnimationCancel(Animator animation) {
            ViewUtils.setTransitionAlpha(this.mView, 1.0f);
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition, boolean isReverse) {
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            float pauseAlpha = this.mView.getVisibility() == 0 ? ViewUtils.getTransitionAlpha(this.mView) : 0.0f;
            this.mView.setTag(R.id.transition_pause_alpha, (Object)Float.valueOf(pauseAlpha));
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            this.mView.setTag(R.id.transition_pause_alpha, null);
        }
    }
}

