/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.transition.GhostViewPort;
import androidx.transition.R;
import androidx.transition.ViewGroupUtils;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
class GhostViewHolder
extends FrameLayout {
    @NonNull
    private ViewGroup mParent;
    private boolean mAttached;

    GhostViewHolder(ViewGroup parent) {
        super(parent.getContext());
        this.setClipChildren(false);
        this.mParent = parent;
        this.mParent.setTag(R.id.ghost_view_holder, (Object)this);
        this.mParent.getOverlay().add((View)this);
        this.mAttached = true;
    }

    public void onViewAdded(View child) {
        if (!this.mAttached) {
            throw new IllegalStateException("This GhostViewHolder is detached!");
        }
        super.onViewAdded(child);
    }

    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
        if (this.getChildCount() == 1 && this.getChildAt(0) == child || this.getChildCount() == 0) {
            this.mParent.setTag(R.id.ghost_view_holder, null);
            this.mParent.getOverlay().remove((View)this);
            this.mAttached = false;
        }
    }

    static GhostViewHolder getHolder(@NonNull ViewGroup parent) {
        return (GhostViewHolder)((Object)parent.getTag(R.id.ghost_view_holder));
    }

    void popToOverlayTop() {
        if (!this.mAttached) {
            throw new IllegalStateException("This GhostViewHolder is detached!");
        }
        this.mParent.getOverlay().remove((View)this);
        this.mParent.getOverlay().add((View)this);
    }

    void addGhostView(GhostViewPort ghostView) {
        ArrayList<View> viewParents = new ArrayList<View>();
        GhostViewHolder.getParents(ghostView.mView, viewParents);
        int index = this.getInsertIndex(viewParents);
        if (index < 0 || index >= this.getChildCount()) {
            this.addView((View)ghostView);
        } else {
            this.addView((View)ghostView, index);
        }
    }

    private int getInsertIndex(ArrayList<View> viewParents) {
        ArrayList<View> tempParents = new ArrayList<View>();
        int low = 0;
        int high = this.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            GhostViewPort midView = (GhostViewPort)this.getChildAt(mid);
            GhostViewHolder.getParents(midView.mView, tempParents);
            if (GhostViewHolder.isOnTop(viewParents, tempParents)) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
            tempParents.clear();
        }
        return low;
    }

    private static boolean isOnTop(ArrayList<View> viewParents, ArrayList<View> comparedWith) {
        if (viewParents.isEmpty() || comparedWith.isEmpty() || viewParents.get(0) != comparedWith.get(0)) {
            return true;
        }
        int depth = Math.min(viewParents.size(), comparedWith.size());
        for (int i = 1; i < depth; ++i) {
            View comparedWithParent;
            View viewParent = viewParents.get(i);
            if (viewParent == (comparedWithParent = comparedWith.get(i))) continue;
            return GhostViewHolder.isOnTop(viewParent, comparedWithParent);
        }
        return comparedWith.size() == depth;
    }

    private static void getParents(View view, ArrayList<View> parents) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            GhostViewHolder.getParents((View)parent, parents);
        }
        parents.add(view);
    }

    private static boolean isOnTop(View view, View comparedWith) {
        ViewGroup parent = (ViewGroup)view.getParent();
        int childrenCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 21 && Api21Impl.getZ(view) != Api21Impl.getZ(comparedWith)) {
            return Api21Impl.getZ(view) > Api21Impl.getZ(comparedWith);
        }
        boolean isOnTop = true;
        for (int i = 0; i < childrenCount; ++i) {
            int childIndex = ViewGroupUtils.getChildDrawingOrder(parent, i);
            View child = parent.getChildAt(childIndex);
            if (child == view) {
                isOnTop = false;
                break;
            }
            if (child != comparedWith) continue;
            isOnTop = true;
            break;
        }
        return isOnTop;
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static float getZ(View view) {
            return view.getZ();
        }
    }
}

