/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.transition.R;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;

class TranslationAnimationCreator {
    @Nullable
    static Animator createAnimation(@NonNull View view, @NonNull TransitionValues values, int viewPosX, int viewPosY, float startX, float startY, float endX, float endY, @Nullable TimeInterpolator interpolator, @NonNull Transition transition) {
        float terminalX = view.getTranslationX();
        float terminalY = view.getTranslationY();
        int[] startPosition = (int[])values.view.getTag(R.id.transition_position);
        if (startPosition != null) {
            startX = (float)(startPosition[0] - viewPosX) + terminalX;
            startY = (float)(startPosition[1] - viewPosY) + terminalY;
        }
        view.setTranslationX(startX);
        view.setTranslationY(startY);
        if (startX == endX && startY == endY) {
            return null;
        }
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{startX, endX}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{startY, endY})});
        TransitionPositionListener listener = new TransitionPositionListener(view, values.view, terminalX, terminalY);
        transition.addListener(listener);
        anim.addListener((Animator.AnimatorListener)listener);
        anim.setInterpolator(interpolator);
        return anim;
    }

    private TranslationAnimationCreator() {
    }

    private static class TransitionPositionListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final View mViewInHierarchy;
        private final View mMovingView;
        private int[] mTransitionPosition;
        private float mPausedX;
        private float mPausedY;
        private final float mTerminalX;
        private final float mTerminalY;
        private boolean mIsTransitionCanceled;

        TransitionPositionListener(View movingView, View viewInHierarchy, float terminalX, float terminalY) {
            this.mMovingView = movingView;
            this.mViewInHierarchy = viewInHierarchy;
            this.mTerminalX = terminalX;
            this.mTerminalY = terminalY;
            this.mTransitionPosition = (int[])this.mViewInHierarchy.getTag(R.id.transition_position);
            if (this.mTransitionPosition != null) {
                this.mViewInHierarchy.setTag(R.id.transition_position, null);
            }
        }

        public void onAnimationCancel(Animator animation) {
            this.mIsTransitionCanceled = true;
            this.mMovingView.setTranslationX(this.mTerminalX);
            this.mMovingView.setTranslationY(this.mTerminalY);
        }

        public void onAnimationEnd(@NonNull Animator animation, boolean isReverse) {
            if (!isReverse) {
                this.mMovingView.setTranslationX(this.mTerminalX);
                this.mMovingView.setTranslationY(this.mTerminalY);
            }
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            this.onAnimationEnd(animation, false);
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition, boolean isReverse) {
            if (!this.mIsTransitionCanceled) {
                this.mViewInHierarchy.setTag(R.id.transition_position, null);
            }
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
            this.onTransitionEnd(transition, false);
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
            this.mIsTransitionCanceled = true;
            this.mMovingView.setTranslationX(this.mTerminalX);
            this.mMovingView.setTranslationY(this.mTerminalY);
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            this.setInterruptedPosition();
            this.mPausedX = this.mMovingView.getTranslationX();
            this.mPausedY = this.mMovingView.getTranslationY();
            this.mMovingView.setTranslationX(this.mTerminalX);
            this.mMovingView.setTranslationY(this.mTerminalY);
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            this.mMovingView.setTranslationX(this.mPausedX);
            this.mMovingView.setTranslationY(this.mPausedY);
        }

        private void setInterruptedPosition() {
            if (this.mTransitionPosition == null) {
                this.mTransitionPosition = new int[2];
            }
            this.mMovingView.getLocationOnScreen(this.mTransitionPosition);
            this.mViewInHierarchy.setTag(R.id.transition_position, (Object)this.mTransitionPosition);
        }
    }
}

