/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area;

import android.content.Context;
import android.view.View;
import androidx.window.area.WindowAreaSessionPresenter;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.extensions.area.ExtensionWindowAreaPresentation;
import androidx.window.extensions.area.WindowAreaComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/window/area/RearDisplayPresentationSessionPresenterImpl;", "Landroidx/window/area/WindowAreaSessionPresenter;", "windowAreaComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "presentation", "Landroidx/window/extensions/area/ExtensionWindowAreaPresentation;", "(Landroidx/window/extensions/area/WindowAreaComponent;Landroidx/window/extensions/area/ExtensionWindowAreaPresentation;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "close", "", "setContentView", "view", "Landroid/view/View;", "window_release"})
@ExperimentalWindowApi
public final class RearDisplayPresentationSessionPresenterImpl
implements WindowAreaSessionPresenter {
    @NotNull
    private final WindowAreaComponent windowAreaComponent;
    @NotNull
    private final ExtensionWindowAreaPresentation presentation;
    @NotNull
    private final Context context;

    public RearDisplayPresentationSessionPresenterImpl(@NotNull WindowAreaComponent windowAreaComponent, @NotNull ExtensionWindowAreaPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)windowAreaComponent, (String)"windowAreaComponent");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        this.windowAreaComponent = windowAreaComponent;
        this.presentation = presentation;
        Context context = this.presentation.getPresentationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"presentation.presentationContext");
        this.context = context;
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContentView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.presentation.setPresentationView(view);
    }

    @Override
    public void close() {
        this.windowAreaComponent.endRearDisplayPresentationSession();
    }
}

