/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area;

import androidx.window.SafeWindowExtensionsProvider;
import androidx.window.area.reflectionguard.WindowAreaComponentValidator;
import androidx.window.core.ExtensionsUtil;
import androidx.window.extensions.WindowExtensions;
import androidx.window.extensions.area.WindowAreaComponent;
import androidx.window.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0001H\u0002R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/window/area/SafeWindowAreaComponentProvider;", "", "loader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "extensionWindowAreaPresentationClass", "Ljava/lang/Class;", "getExtensionWindowAreaPresentationClass", "()Ljava/lang/Class;", "extensionWindowAreaStatusClass", "getExtensionWindowAreaStatusClass", "windowAreaComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "getWindowAreaComponent", "()Landroidx/window/extensions/area/WindowAreaComponent;", "windowAreaComponentClass", "getWindowAreaComponentClass", "windowExtensions", "Landroidx/window/extensions/WindowExtensions;", "isValidExtensionWindowPresentation", "", "isWindowAreaProviderValid", "window_release"})
public final class SafeWindowAreaComponentProvider {
    @NotNull
    private final ClassLoader loader;
    @Nullable
    private final WindowExtensions windowExtensions;

    public SafeWindowAreaComponentProvider(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader = loader;
        this.windowExtensions = new SafeWindowExtensionsProvider(this.loader).getWindowExtensions();
    }

    @Nullable
    public final WindowAreaComponent getWindowAreaComponent() {
        WindowAreaComponent windowAreaComponent;
        try {
            windowAreaComponent = this.windowExtensions != null && this.isWindowAreaProviderValid(this.windowExtensions) && WindowAreaComponentValidator.INSTANCE.isWindowAreaComponentValid$window_release(this.getWindowAreaComponentClass(), ExtensionsUtil.INSTANCE.getSafeVendorApiLevel()) && WindowAreaComponentValidator.INSTANCE.isExtensionWindowAreaStatusValid$window_release(this.getExtensionWindowAreaStatusClass(), ExtensionsUtil.INSTANCE.getSafeVendorApiLevel()) && this.isValidExtensionWindowPresentation() ? this.windowExtensions.getWindowAreaComponent() : null;
        }
        catch (Exception e) {
            windowAreaComponent = null;
        }
        return windowAreaComponent;
    }

    private final boolean isWindowAreaProviderValid(Object windowExtensions) {
        return ReflectionUtils.validateReflection$window_release("WindowExtensions#getWindowAreaComponent is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(windowExtensions, this){
            final /* synthetic */ Object $windowExtensions;
            final /* synthetic */ SafeWindowAreaComponentProvider this$0;
            {
                this.$windowExtensions = $windowExtensions;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Method getWindowAreaComponentMethod = this.$windowExtensions.getClass().getMethod("getWindowAreaComponent", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowAreaComponentMethod, (String)"getWindowAreaComponentMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(getWindowAreaComponentMethod) && ReflectionUtils.INSTANCE.doesReturn$window_release(getWindowAreaComponentMethod, SafeWindowAreaComponentProvider.access$getWindowAreaComponentClass(this.this$0));
            }
        }));
    }

    private final boolean isValidExtensionWindowPresentation() {
        return ExtensionsUtil.INSTANCE.getSafeVendorApiLevel() <= 2 || WindowAreaComponentValidator.INSTANCE.isExtensionWindowAreaPresentationValid$window_release(this.getExtensionWindowAreaPresentationClass(), ExtensionsUtil.INSTANCE.getSafeVendorApiLevel());
    }

    private final Class<?> getWindowAreaComponentClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.area.WindowAreaComponent");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WindowE\u2026DOW_AREA_COMPONENT_CLASS)");
        return clazz;
    }

    private final Class<?> getExtensionWindowAreaStatusClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.area.ExtensionWindowAreaStatus");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WindowE\u2026WINDOW_AREA_STATUS_CLASS)");
        return clazz;
    }

    private final Class<?> getExtensionWindowAreaPresentationClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.area.ExtensionWindowAreaPresentation");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(\n      \u2026ATION_CLASS\n            )");
        return clazz;
    }

    public static final /* synthetic */ Class access$getWindowAreaComponentClass(SafeWindowAreaComponentProvider $this) {
        return $this.getWindowAreaComponentClass();
    }
}

