/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.core.util.Consumer;
import androidx.window.RequiresWindowSdkExtension;
import androidx.window.core.BuildConfig;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExtensionsUtil;
import androidx.window.core.PredicateAdapter;
import androidx.window.core.VerificationMode;
import androidx.window.embedding.ActivityStack;
import androidx.window.embedding.EmbeddingAdapter;
import androidx.window.embedding.EmbeddingBackend;
import androidx.window.embedding.EmbeddingCompat;
import androidx.window.embedding.EmbeddingInterfaceCompat;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitAttributesCalculatorParams;
import androidx.window.embedding.SplitController;
import androidx.window.embedding.SplitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 E2\u00020\u0001:\u0005DEFGHB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J,\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0&H\u0016J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001dH\u0017J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001f0/H\u0017J\b\u00100\u001a\u00020\u001dH\u0017J\u0010\u00101\u001a\u00020*2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001c\u00103\u001a\u00020\u001d2\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0&H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000209H\u0017J\u0016\u0010:\u001a\u00020\u001d2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001f0/H\u0017J\u001c\u0010<\u001a\u00020\u001d2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020@0>H\u0017J\u0018\u0010A\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020@H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006I"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend;", "Landroidx/window/embedding/EmbeddingBackend;", "applicationContext", "Landroid/content/Context;", "embeddingExtension", "Landroidx/window/embedding/EmbeddingInterfaceCompat;", "(Landroid/content/Context;Landroidx/window/embedding/EmbeddingInterfaceCompat;)V", "getEmbeddingExtension", "()Landroidx/window/embedding/EmbeddingInterfaceCompat;", "setEmbeddingExtension", "(Landroidx/window/embedding/EmbeddingInterfaceCompat;)V", "ruleTracker", "Landroidx/window/embedding/ExtensionEmbeddingBackend$RuleTracker;", "splitChangeCallbacks", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Landroidx/window/embedding/ExtensionEmbeddingBackend$SplitListenerWrapper;", "getSplitChangeCallbacks$annotations", "()V", "getSplitChangeCallbacks", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "splitInfoEmbeddingCallback", "Landroidx/window/embedding/ExtensionEmbeddingBackend$EmbeddingCallbackImpl;", "splitSupportStatus", "Landroidx/window/embedding/SplitController$SplitSupportStatus;", "getSplitSupportStatus", "()Landroidx/window/embedding/SplitController$SplitSupportStatus;", "splitSupportStatus$delegate", "Lkotlin/Lazy;", "addRule", "", "rule", "Landroidx/window/embedding/EmbeddingRule;", "addSplitListenerForActivity", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/core/util/Consumer;", "", "Landroidx/window/embedding/SplitInfo;", "areExtensionsAvailable", "", "clearSplitAttributesCalculator", "getActivityStack", "Landroidx/window/embedding/ActivityStack;", "getRules", "", "invalidateTopVisibleSplitAttributes", "isActivityEmbedded", "removeRule", "removeSplitListenerForActivity", "consumer", "setLaunchingActivityStack", "Landroid/app/ActivityOptions;", "options", "token", "Landroid/os/IBinder;", "setRules", "rules", "setSplitAttributesCalculator", "calculator", "Lkotlin/Function1;", "Landroidx/window/embedding/SplitAttributesCalculatorParams;", "Landroidx/window/embedding/SplitAttributes;", "updateSplitAttributes", "splitInfo", "splitAttributes", "Api31Impl", "Companion", "EmbeddingCallbackImpl", "RuleTracker", "SplitListenerWrapper", "window_release"})
@SourceDebugExtension(value={"SMAP\nExtensionEmbeddingBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionEmbeddingBackend.kt\nandroidx/window/embedding/ExtensionEmbeddingBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n1#2:434\n*E\n"})
public final class ExtensionEmbeddingBackend
implements EmbeddingBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @VisibleForTesting
    @GuardedBy(value="globalLock")
    @Nullable
    private EmbeddingInterfaceCompat embeddingExtension;
    @NotNull
    private final CopyOnWriteArrayList<SplitListenerWrapper> splitChangeCallbacks;
    @NotNull
    private final EmbeddingCallbackImpl splitInfoEmbeddingCallback;
    @GuardedBy(value="globalLock")
    @NotNull
    private final RuleTracker ruleTracker;
    @NotNull
    private final Lazy splitSupportStatus$delegate;
    @Nullable
    private static volatile ExtensionEmbeddingBackend globalInstance;
    @NotNull
    private static final ReentrantLock globalLock;
    @NotNull
    private static final String TAG = "EmbeddingBackend";

    @VisibleForTesting
    public ExtensionEmbeddingBackend(@NotNull Context applicationContext, @Nullable EmbeddingInterfaceCompat embeddingExtension) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        this.embeddingExtension = embeddingExtension;
        this.splitInfoEmbeddingCallback = new EmbeddingCallbackImpl();
        this.splitChangeCallbacks = new CopyOnWriteArrayList();
        EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
        if (embeddingInterfaceCompat != null) {
            embeddingInterfaceCompat.setEmbeddingCallback(this.splitInfoEmbeddingCallback);
        }
        this.ruleTracker = new RuleTracker();
        this.splitSupportStatus$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SplitController.SplitSupportStatus>(this){
            final /* synthetic */ ExtensionEmbeddingBackend this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SplitController.SplitSupportStatus invoke() {
                return !ExtensionEmbeddingBackend.access$areExtensionsAvailable(this.this$0) ? SplitController.SplitSupportStatus.SPLIT_UNAVAILABLE : (Build.VERSION.SDK_INT >= 31 ? Api31Impl.INSTANCE.isSplitPropertyEnabled(ExtensionEmbeddingBackend.access$getApplicationContext$p(this.this$0)) : SplitController.SplitSupportStatus.SPLIT_AVAILABLE);
            }
        }));
    }

    @Nullable
    public final EmbeddingInterfaceCompat getEmbeddingExtension() {
        return this.embeddingExtension;
    }

    public final void setEmbeddingExtension(@Nullable EmbeddingInterfaceCompat embeddingInterfaceCompat) {
        this.embeddingExtension = embeddingInterfaceCompat;
    }

    @NotNull
    public final CopyOnWriteArrayList<SplitListenerWrapper> getSplitChangeCallbacks() {
        return this.splitChangeCallbacks;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSplitChangeCallbacks$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="globalLock")
    @NotNull
    public Set<EmbeddingRule> getRules() {
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            Set set = CollectionsKt.toSet((Iterable)((Iterable)this.ruleTracker.getSplitRules()));
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="globalLock")
    public void setRules(@NotNull Set<? extends EmbeddingRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Lock lock = globalLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            this.ruleTracker.setRules(rules);
            EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
            if (embeddingInterfaceCompat != null) {
                embeddingInterfaceCompat.setRules(this.getRules());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="globalLock")
    public void addRule(@NotNull EmbeddingRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.ruleTracker.contains(rule)) {
                RuleTracker.addOrUpdateRule$default(this.ruleTracker, rule, false, 2, null);
                EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
                if (embeddingInterfaceCompat != null) {
                    embeddingInterfaceCompat.setRules(this.getRules());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="globalLock")
    public void removeRule(@NotNull EmbeddingRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.ruleTracker.contains(rule)) {
                this.ruleTracker.removeRule(rule);
                EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
                if (embeddingInterfaceCompat != null) {
                    embeddingInterfaceCompat.setRules(this.getRules());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSplitListenerForActivity(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<List<SplitInfo>> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.embeddingExtension == null) {
                Log.v((String)TAG, (String)"Extension not loaded, skipping callback registration.");
                callback.accept((Object)CollectionsKt.emptyList());
                return;
            }
            SplitListenerWrapper callbackWrapper = new SplitListenerWrapper(activity, executor, callback);
            this.splitChangeCallbacks.add(callbackWrapper);
            if (this.splitInfoEmbeddingCallback.getLastInfo() != null) {
                List<SplitInfo> list = this.splitInfoEmbeddingCallback.getLastInfo();
                Intrinsics.checkNotNull(list);
                callbackWrapper.accept(list);
            } else {
                callbackWrapper.accept(CollectionsKt.emptyList());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSplitListenerForActivity(@NotNull Consumer<List<SplitInfo>> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            for (SplitListenerWrapper callbackWrapper : this.splitChangeCallbacks) {
                if (!Intrinsics.areEqual(callbackWrapper.getCallback(), consumer)) continue;
                this.splitChangeCallbacks.remove(callbackWrapper);
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean areExtensionsAvailable() {
        return this.embeddingExtension != null;
    }

    @Override
    @NotNull
    public SplitController.SplitSupportStatus getSplitSupportStatus() {
        Lazy lazy = this.splitSupportStatus$delegate;
        return (SplitController.SplitSupportStatus)lazy.getValue();
    }

    @Override
    public boolean isActivityEmbedded(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
        return embeddingInterfaceCompat != null ? embeddingInterfaceCompat.isActivityEmbedded(activity) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresWindowSdkExtension(version=2)
    public void setSplitAttributesCalculator(@NotNull Function1<? super SplitAttributesCalculatorParams, SplitAttributes> calculator) {
        Intrinsics.checkNotNullParameter(calculator, (String)"calculator");
        Lock lock = globalLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
            if (embeddingInterfaceCompat != null) {
                embeddingInterfaceCompat.setSplitAttributesCalculator(calculator);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresWindowSdkExtension(version=2)
    public void clearSplitAttributesCalculator() {
        Lock lock = globalLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
            if (embeddingInterfaceCompat != null) {
                embeddingInterfaceCompat.clearSplitAttributesCalculator();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ActivityStack getActivityStack(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Lock lock = globalLock;
        lock.lock();
        try {
            List<SplitInfo> list;
            boolean bl = false;
            if (this.splitInfoEmbeddingCallback.getLastInfo() == null) {
                ActivityStack activityStack = null;
                return activityStack;
            }
            List<SplitInfo> lastInfo = list;
            for (SplitInfo info : lastInfo) {
                if (!info.contains(activity)) continue;
                if (info.getPrimaryActivityStack().contains(activity)) {
                    ActivityStack activityStack = info.getPrimaryActivityStack();
                    return activityStack;
                }
                if (!info.getSecondaryActivityStack().contains(activity)) continue;
                ActivityStack activityStack = info.getSecondaryActivityStack();
                return activityStack;
            }
            ActivityStack activityStack = null;
            return activityStack;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @RequiresWindowSdkExtension(version=3)
    @NotNull
    public ActivityOptions setLaunchingActivityStack(@NotNull ActivityOptions options, @NotNull IBinder token) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
        if (embeddingInterfaceCompat == null || (embeddingInterfaceCompat = embeddingInterfaceCompat.setLaunchingActivityStack(options, token)) == null) {
            embeddingInterfaceCompat = options;
        }
        return embeddingInterfaceCompat;
    }

    @Override
    @RequiresWindowSdkExtension(version=3)
    public void invalidateTopVisibleSplitAttributes() {
        block0: {
            EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
            if (embeddingInterfaceCompat == null) break block0;
            embeddingInterfaceCompat.invalidateTopVisibleSplitAttributes();
        }
    }

    @Override
    @RequiresWindowSdkExtension(version=3)
    public void updateSplitAttributes(@NotNull SplitInfo splitInfo, @NotNull SplitAttributes splitAttributes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)splitInfo, (String)"splitInfo");
            Intrinsics.checkNotNullParameter((Object)splitAttributes, (String)"splitAttributes");
            EmbeddingInterfaceCompat embeddingInterfaceCompat = this.embeddingExtension;
            if (embeddingInterfaceCompat == null) break block0;
            embeddingInterfaceCompat.updateSplitAttributes(splitInfo, splitAttributes);
        }
    }

    public static final /* synthetic */ boolean access$areExtensionsAvailable(ExtensionEmbeddingBackend $this) {
        return $this.areExtensionsAvailable();
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(ExtensionEmbeddingBackend $this) {
        return $this.applicationContext;
    }

    static {
        globalLock = new ReentrantLock();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend$Api31Impl;", "", "()V", "isSplitPropertyEnabled", "Landroidx/window/embedding/SplitController$SplitSupportStatus;", "context", "Landroid/content/Context;", "window_release"})
    @RequiresApi(value=31)
    private static final class Api31Impl {
        @NotNull
        public static final Api31Impl INSTANCE = new Api31Impl();

        private Api31Impl() {
        }

        @DoNotInline
        @NotNull
        public final SplitController.SplitSupportStatus isSplitPropertyEnabled(@NotNull Context context) {
            PackageManager.Property property;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                property = context.getPackageManager().getProperty("android.window.PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED", context.getPackageName());
            }
            catch (PackageManager.NameNotFoundException e) {
                if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                    Log.w((String)ExtensionEmbeddingBackend.TAG, (String)"android.window.PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED must be set and enabled in AndroidManifest.xml to use splits APIs.");
                }
                return SplitController.SplitSupportStatus.SPLIT_ERROR_PROPERTY_NOT_DECLARED;
            }
            catch (Exception e) {
                if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                    Log.e((String)ExtensionEmbeddingBackend.TAG, (String)"PackageManager.getProperty is not supported", (Throwable)e);
                }
                return SplitController.SplitSupportStatus.SPLIT_ERROR_PROPERTY_NOT_DECLARED;
            }
            PackageManager.Property property2 = property;
            Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"try {\n                co\u2026OT_DECLARED\n            }");
            PackageManager.Property property3 = property2;
            if (!property3.isBoolean()) {
                if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                    Log.w((String)ExtensionEmbeddingBackend.TAG, (String)"android.window.PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED must have a boolean value");
                }
                return SplitController.SplitSupportStatus.SPLIT_ERROR_PROPERTY_NOT_DECLARED;
            }
            return property3.getBoolean() ? SplitController.SplitSupportStatus.SPLIT_AVAILABLE : SplitController.SplitSupportStatus.SPLIT_UNAVAILABLE;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0017\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend$Companion;", "", "()V", "TAG", "", "globalInstance", "Landroidx/window/embedding/ExtensionEmbeddingBackend;", "globalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getInstance", "Landroidx/window/embedding/EmbeddingBackend;", "context", "Landroid/content/Context;", "initAndVerifyEmbeddingExtension", "Landroidx/window/embedding/EmbeddingInterfaceCompat;", "applicationContext", "isExtensionVersionSupported", "", "extensionVersion", "", "(Ljava/lang/Integer;)Z", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final EmbeddingBackend getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (globalInstance == null) {
                Lock lock = globalLock;
                lock.lock();
                try {
                    boolean bl = false;
                    if (globalInstance == null) {
                        Context applicationContext = context.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
                        EmbeddingInterfaceCompat embeddingExtension = Companion.initAndVerifyEmbeddingExtension(applicationContext);
                        globalInstance = new ExtensionEmbeddingBackend(applicationContext, embeddingExtension);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            ExtensionEmbeddingBackend extensionEmbeddingBackend = globalInstance;
            Intrinsics.checkNotNull((Object)extensionEmbeddingBackend);
            return extensionEmbeddingBackend;
        }

        private final EmbeddingInterfaceCompat initAndVerifyEmbeddingExtension(Context applicationContext) {
            EmbeddingInterfaceCompat impl = null;
            try {
                if (this.isExtensionVersionSupported(ExtensionsUtil.INSTANCE.getSafeVendorApiLevel()) && EmbeddingCompat.Companion.isEmbeddingAvailable()) {
                    EmbeddingCompat embeddingCompat;
                    ClassLoader classLoader = EmbeddingBackend.class.getClassLoader();
                    if (classLoader != null) {
                        ClassLoader loader = classLoader;
                        boolean bl = false;
                        embeddingCompat = new EmbeddingCompat(EmbeddingCompat.Companion.embeddingComponent(), new EmbeddingAdapter(new PredicateAdapter(loader)), new ConsumerAdapter(loader), applicationContext);
                    } else {
                        embeddingCompat = null;
                    }
                    impl = embeddingCompat;
                }
            }
            catch (Throwable t) {
                Log.d((String)ExtensionEmbeddingBackend.TAG, (String)("Failed to load embedding extension: " + t));
                impl = null;
            }
            if (impl == null) {
                Log.d((String)ExtensionEmbeddingBackend.TAG, (String)"No supported embedding extension found");
            }
            return impl;
        }

        @VisibleForTesting
        public final boolean isExtensionVersionSupported(@Nullable Integer extensionVersion) {
            if (extensionVersion == null) {
                return false;
            }
            return extensionVersion >= 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend$EmbeddingCallbackImpl;", "Landroidx/window/embedding/EmbeddingInterfaceCompat$EmbeddingCallbackInterface;", "(Landroidx/window/embedding/ExtensionEmbeddingBackend;)V", "lastInfo", "", "Landroidx/window/embedding/SplitInfo;", "getLastInfo", "()Ljava/util/List;", "setLastInfo", "(Ljava/util/List;)V", "onSplitInfoChanged", "", "splitInfo", "window_release"})
    public final class EmbeddingCallbackImpl
    implements EmbeddingInterfaceCompat.EmbeddingCallbackInterface {
        @Nullable
        private List<SplitInfo> lastInfo;

        @Nullable
        public final List<SplitInfo> getLastInfo() {
            return this.lastInfo;
        }

        public final void setLastInfo(@Nullable List<SplitInfo> list) {
            this.lastInfo = list;
        }

        @Override
        public void onSplitInfoChanged(@NotNull List<SplitInfo> splitInfo) {
            Intrinsics.checkNotNullParameter(splitInfo, (String)"splitInfo");
            this.lastInfo = splitInfo;
            for (SplitListenerWrapper callbackWrapper : ExtensionEmbeddingBackend.this.getSplitChangeCallbacks()) {
                callbackWrapper.accept(splitInfo);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\rJ\u0011\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend$RuleTracker;", "", "()V", "splitRules", "Landroidx/collection/ArraySet;", "Landroidx/window/embedding/EmbeddingRule;", "getSplitRules", "()Landroidx/collection/ArraySet;", "tagRuleMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addOrUpdateRule", "", "rule", "throwOnDuplicateTag", "", "clearRules", "contains", "removeRule", "setRules", "rules", "", "window_release"})
    @SourceDebugExtension(value={"SMAP\nExtensionEmbeddingBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionEmbeddingBackend.kt\nandroidx/window/embedding/ExtensionEmbeddingBackend$RuleTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n1855#2,2:434\n*S KotlinDebug\n*F\n+ 1 ExtensionEmbeddingBackend.kt\nandroidx/window/embedding/ExtensionEmbeddingBackend$RuleTracker\n*L\n187#1:434,2\n*E\n"})
    private static final class RuleTracker {
        @NotNull
        private final ArraySet<EmbeddingRule> splitRules = new ArraySet();
        @NotNull
        private final HashMap<String, EmbeddingRule> tagRuleMap = new HashMap();

        @NotNull
        public final ArraySet<EmbeddingRule> getSplitRules() {
            return this.splitRules;
        }

        public final void setRules(@NotNull Set<? extends EmbeddingRule> rules) {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            this.clearRules();
            Iterable $this$forEach$iv = rules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EmbeddingRule rule = (EmbeddingRule)element$iv;
                boolean bl = false;
                this.addOrUpdateRule(rule, true);
            }
        }

        public final void clearRules() {
            this.splitRules.clear();
            this.tagRuleMap.clear();
        }

        public final void addOrUpdateRule(@NotNull EmbeddingRule rule, boolean throwOnDuplicateTag) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            if (this.splitRules.contains((Object)rule)) {
                return;
            }
            String tag = rule.getTag();
            if (tag == null) {
                this.splitRules.add((Object)rule);
            } else if (this.tagRuleMap.containsKey(tag)) {
                if (throwOnDuplicateTag) {
                    throw new IllegalArgumentException("Duplicated tag: " + tag + ". Tag must be unique among all registered rules");
                }
                EmbeddingRule oldRule = this.tagRuleMap.get(tag);
                this.splitRules.remove((Object)oldRule);
                ((Map)this.tagRuleMap).put(tag, rule);
                this.splitRules.add((Object)rule);
            } else {
                ((Map)this.tagRuleMap).put(tag, rule);
                this.splitRules.add((Object)rule);
            }
        }

        public static /* synthetic */ void addOrUpdateRule$default(RuleTracker ruleTracker, EmbeddingRule embeddingRule, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            ruleTracker.addOrUpdateRule(embeddingRule, bl);
        }

        public final void removeRule(@NotNull EmbeddingRule rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            if (!this.splitRules.contains((Object)rule)) {
                return;
            }
            this.splitRules.remove((Object)rule);
            String tag = rule.getTag();
            if (tag != null) {
                this.tagRuleMap.remove(rule.getTag());
            }
        }

        public final boolean contains(@NotNull EmbeddingRule rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            return this.splitRules.contains((Object)rule);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/embedding/ExtensionEmbeddingBackend$SplitListenerWrapper;", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/core/util/Consumer;", "", "Landroidx/window/embedding/SplitInfo;", "(Landroid/app/Activity;Ljava/util/concurrent/Executor;Landroidx/core/util/Consumer;)V", "getCallback", "()Landroidx/core/util/Consumer;", "lastValue", "accept", "", "splitInfoList", "window_release"})
    @SourceDebugExtension(value={"SMAP\nExtensionEmbeddingBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionEmbeddingBackend.kt\nandroidx/window/embedding/ExtensionEmbeddingBackend$SplitListenerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n766#2:434\n857#2,2:435\n*S KotlinDebug\n*F\n+ 1 ExtensionEmbeddingBackend.kt\nandroidx/window/embedding/ExtensionEmbeddingBackend$SplitListenerWrapper\n*L\n254#1:434\n254#1:435,2\n*E\n"})
    public static final class SplitListenerWrapper {
        @NotNull
        private final Activity activity;
        @NotNull
        private final Executor executor;
        @NotNull
        private final Consumer<List<SplitInfo>> callback;
        @Nullable
        private List<SplitInfo> lastValue;

        public SplitListenerWrapper(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<List<SplitInfo>> callback) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.activity = activity;
            this.executor = executor;
            this.callback = callback;
        }

        @NotNull
        public final Consumer<List<SplitInfo>> getCallback() {
            return this.callback;
        }

        /*
         * WARNING - void declaration
         */
        public final void accept(@NotNull List<SplitInfo> splitInfoList2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(splitInfoList2, (String)"splitInfoList");
            Iterable $this$filter$iv = splitInfoList2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SplitInfo splitState = (SplitInfo)element$iv$iv;
                boolean bl = false;
                if (!splitState.contains(this.activity)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List splitsWithActivity = (List)destination$iv$iv;
            if (Intrinsics.areEqual((Object)splitsWithActivity, this.lastValue)) {
                return;
            }
            this.lastValue = splitsWithActivity;
            this.executor.execute(() -> SplitListenerWrapper.accept$lambda$1(this, splitsWithActivity));
        }

        private static final void accept$lambda$1(SplitListenerWrapper this$0, List $splitsWithActivity) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$splitsWithActivity, (String)"$splitsWithActivity");
            this$0.callback.accept((Object)$splitsWithActivity);
        }
    }
}

