/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ActivityComponentInfo;
import androidx.window.embedding.MatcherUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018J\b\u0010\u001d\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001e"}, d2={"Landroidx/window/embedding/SplitPairFilter;", "", "primaryActivityName", "Landroid/content/ComponentName;", "secondaryActivityName", "secondaryActivityIntentAction", "", "(Landroid/content/ComponentName;Landroid/content/ComponentName;Ljava/lang/String;)V", "_primaryActivityName", "Landroidx/window/core/ActivityComponentInfo;", "_secondaryActivityName", "(Landroidx/window/core/ActivityComponentInfo;Landroidx/window/core/ActivityComponentInfo;Ljava/lang/String;)V", "getPrimaryActivityName", "()Landroid/content/ComponentName;", "getSecondaryActivityIntentAction", "()Ljava/lang/String;", "getSecondaryActivityName", "equals", "", "other", "hashCode", "", "matchesActivityIntentPair", "primaryActivity", "Landroid/app/Activity;", "secondaryActivityIntent", "Landroid/content/Intent;", "matchesActivityPair", "secondaryActivity", "toString", "window_release"})
public final class SplitPairFilter {
    @NotNull
    private final ActivityComponentInfo _primaryActivityName;
    @NotNull
    private final ActivityComponentInfo _secondaryActivityName;
    @Nullable
    private final String secondaryActivityIntentAction;

    public SplitPairFilter(@NotNull ActivityComponentInfo _primaryActivityName, @NotNull ActivityComponentInfo _secondaryActivityName, @Nullable String secondaryActivityIntentAction) {
        Intrinsics.checkNotNullParameter((Object)_primaryActivityName, (String)"_primaryActivityName");
        Intrinsics.checkNotNullParameter((Object)_secondaryActivityName, (String)"_secondaryActivityName");
        this._primaryActivityName = _primaryActivityName;
        this._secondaryActivityName = _secondaryActivityName;
        this.secondaryActivityIntentAction = secondaryActivityIntentAction;
        MatcherUtils.INSTANCE.validateComponentName$window_release(this._primaryActivityName.getPackageName(), this._primaryActivityName.getClassName());
        MatcherUtils.INSTANCE.validateComponentName$window_release(this._secondaryActivityName.getPackageName(), this._secondaryActivityName.getClassName());
    }

    @Nullable
    public final String getSecondaryActivityIntentAction() {
        return this.secondaryActivityIntentAction;
    }

    public SplitPairFilter(@NotNull ComponentName primaryActivityName, @NotNull ComponentName secondaryActivityName, @Nullable String secondaryActivityIntentAction) {
        Intrinsics.checkNotNullParameter((Object)primaryActivityName, (String)"primaryActivityName");
        Intrinsics.checkNotNullParameter((Object)secondaryActivityName, (String)"secondaryActivityName");
        this(new ActivityComponentInfo(primaryActivityName), new ActivityComponentInfo(secondaryActivityName), secondaryActivityIntentAction);
    }

    @NotNull
    public final ComponentName getPrimaryActivityName() {
        return new ComponentName(this._primaryActivityName.getPackageName(), this._primaryActivityName.getClassName());
    }

    @NotNull
    public final ComponentName getSecondaryActivityName() {
        return new ComponentName(this._secondaryActivityName.getPackageName(), this._secondaryActivityName.getClassName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesActivityPair(@NotNull Activity primaryActivity, @NotNull Activity secondaryActivity) {
        Intrinsics.checkNotNullParameter((Object)primaryActivity, (String)"primaryActivity");
        Intrinsics.checkNotNullParameter((Object)secondaryActivity, (String)"secondaryActivity");
        if (!MatcherUtils.INSTANCE.isActivityMatching$window_release(primaryActivity, this._primaryActivityName)) {
            return false;
        }
        if (!MatcherUtils.INSTANCE.isActivityMatching$window_release(secondaryActivity, this._secondaryActivityName)) {
            return false;
        }
        if (this.secondaryActivityIntentAction == null) return true;
        Intent intent = secondaryActivity.getIntent();
        if (!Intrinsics.areEqual((Object)this.secondaryActivityIntentAction, (Object)(intent != null ? intent.getAction() : null))) return false;
        return true;
    }

    public final boolean matchesActivityIntentPair(@NotNull Activity primaryActivity, @NotNull Intent secondaryActivityIntent) {
        Intrinsics.checkNotNullParameter((Object)primaryActivity, (String)"primaryActivity");
        Intrinsics.checkNotNullParameter((Object)secondaryActivityIntent, (String)"secondaryActivityIntent");
        boolean match = !MatcherUtils.INSTANCE.isActivityMatching$window_release(primaryActivity, this._primaryActivityName) ? false : (!MatcherUtils.INSTANCE.isIntentMatching$window_release(secondaryActivityIntent, this._secondaryActivityName) ? false : this.secondaryActivityIntentAction == null || Intrinsics.areEqual((Object)this.secondaryActivityIntentAction, (Object)secondaryActivityIntent.getAction()));
        return match;
    }

    @NotNull
    public String toString() {
        return "SplitPairFilter{primaryActivityName=" + this.getPrimaryActivityName() + ", secondaryActivityName=" + this.getSecondaryActivityName() + ", secondaryActivityAction=" + this.secondaryActivityIntentAction + '}';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.window.embedding.SplitPairFilter");
        SplitPairFilter cfr_ignored_0 = (SplitPairFilter)other;
        if (!Intrinsics.areEqual((Object)this._primaryActivityName, (Object)((SplitPairFilter)other)._primaryActivityName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._secondaryActivityName, (Object)((SplitPairFilter)other)._secondaryActivityName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.secondaryActivityIntentAction, (Object)((SplitPairFilter)other).secondaryActivityIntentAction);
    }

    public int hashCode() {
        int result = this._primaryActivityName.hashCode();
        result = 31 * result + this._secondaryActivityName.hashCode();
        String string = this.secondaryActivityIntentAction;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }
}

