/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.core.util.Preconditions;
import androidx.window.embedding.ActivityFilter;
import androidx.window.embedding.EmbeddingAspectRatio;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitRule;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001&Bu\b\u0010\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0003\u0010\r\u001a\u00020\u000e\u0012\b\b\u0003\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u000eH\u0016J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0006H\u0080\u0002\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Landroidx/window/embedding/SplitPlaceholderRule;", "Landroidx/window/embedding/SplitRule;", "tag", "", "filters", "", "Landroidx/window/embedding/ActivityFilter;", "placeholderIntent", "Landroid/content/Intent;", "isSticky", "", "finishPrimaryWithPlaceholder", "Landroidx/window/embedding/SplitRule$FinishBehavior;", "minWidthDp", "", "minHeightDp", "minSmallestWidthDp", "maxAspectRatioInPortrait", "Landroidx/window/embedding/EmbeddingAspectRatio;", "maxAspectRatioInLandscape", "defaultSplitAttributes", "Landroidx/window/embedding/SplitAttributes;", "(Ljava/lang/String;Ljava/util/Set;Landroid/content/Intent;ZLandroidx/window/embedding/SplitRule$FinishBehavior;IIILandroidx/window/embedding/EmbeddingAspectRatio;Landroidx/window/embedding/EmbeddingAspectRatio;Landroidx/window/embedding/SplitAttributes;)V", "getFilters", "()Ljava/util/Set;", "getFinishPrimaryWithPlaceholder", "()Landroidx/window/embedding/SplitRule$FinishBehavior;", "()Z", "getPlaceholderIntent", "()Landroid/content/Intent;", "equals", "other", "", "hashCode", "plus", "filter", "plus$window_release", "toString", "Builder", "window_release"})
public final class SplitPlaceholderRule
extends SplitRule {
    @NotNull
    private final Set<ActivityFilter> filters;
    @NotNull
    private final Intent placeholderIntent;
    private final boolean isSticky;
    @NotNull
    private final SplitRule.FinishBehavior finishPrimaryWithPlaceholder;

    @NotNull
    public final Set<ActivityFilter> getFilters() {
        return this.filters;
    }

    @NotNull
    public final Intent getPlaceholderIntent() {
        return this.placeholderIntent;
    }

    public final boolean isSticky() {
        return this.isSticky;
    }

    @NotNull
    public final SplitRule.FinishBehavior getFinishPrimaryWithPlaceholder() {
        return this.finishPrimaryWithPlaceholder;
    }

    public SplitPlaceholderRule(@Nullable String tag, @NotNull Set<ActivityFilter> filters, @NotNull Intent placeholderIntent, boolean isSticky, @NotNull SplitRule.FinishBehavior finishPrimaryWithPlaceholder, @IntRange(from=0L) int minWidthDp, @IntRange(from=0L) int minHeightDp, @IntRange(from=0L) int minSmallestWidthDp, @NotNull EmbeddingAspectRatio maxAspectRatioInPortrait, @NotNull EmbeddingAspectRatio maxAspectRatioInLandscape, @NotNull SplitAttributes defaultSplitAttributes) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)placeholderIntent, (String)"placeholderIntent");
        Intrinsics.checkNotNullParameter((Object)finishPrimaryWithPlaceholder, (String)"finishPrimaryWithPlaceholder");
        Intrinsics.checkNotNullParameter((Object)maxAspectRatioInPortrait, (String)"maxAspectRatioInPortrait");
        Intrinsics.checkNotNullParameter((Object)maxAspectRatioInLandscape, (String)"maxAspectRatioInLandscape");
        Intrinsics.checkNotNullParameter((Object)defaultSplitAttributes, (String)"defaultSplitAttributes");
        super(tag, minWidthDp, minHeightDp, minSmallestWidthDp, maxAspectRatioInPortrait, maxAspectRatioInLandscape, defaultSplitAttributes);
        Preconditions.checkArgument((!Intrinsics.areEqual((Object)finishPrimaryWithPlaceholder, (Object)SplitRule.FinishBehavior.NEVER) ? 1 : 0) != 0, (String)"NEVER is not a valid configuration for SplitPlaceholderRule. Please use FINISH_ALWAYS or FINISH_ADJACENT instead or refer to the current API.", (Object[])new Object[0]);
        this.filters = CollectionsKt.toSet((Iterable)filters);
        this.placeholderIntent = placeholderIntent;
        this.isSticky = isSticky;
        this.finishPrimaryWithPlaceholder = finishPrimaryWithPlaceholder;
    }

    public /* synthetic */ SplitPlaceholderRule(String string, Set set, Intent intent, boolean bl, SplitRule.FinishBehavior finishBehavior, int n, int n2, int n3, EmbeddingAspectRatio embeddingAspectRatio, EmbeddingAspectRatio embeddingAspectRatio2, SplitAttributes splitAttributes, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = null;
        }
        if ((n4 & 0x10) != 0) {
            finishBehavior = SplitRule.FinishBehavior.ALWAYS;
        }
        if ((n4 & 0x20) != 0) {
            n = 600;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 600;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 600;
        }
        if ((n4 & 0x100) != 0) {
            embeddingAspectRatio = SplitRule.SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT;
        }
        if ((n4 & 0x200) != 0) {
            embeddingAspectRatio2 = SplitRule.SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT;
        }
        this(string, set, intent, bl, finishBehavior, n, n2, n3, embeddingAspectRatio, embeddingAspectRatio2, splitAttributes);
    }

    @NotNull
    public final SplitPlaceholderRule plus$window_release(@NotNull ActivityFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Set newSet = new LinkedHashSet();
        newSet.addAll((Collection)this.filters);
        newSet.add(filter);
        return new Builder(CollectionsKt.toSet((Iterable)newSet), this.placeholderIntent).setTag(this.getTag()).setMinWidthDp(this.getMinWidthDp()).setMinHeightDp(this.getMinHeightDp()).setMinSmallestWidthDp(this.getMinSmallestWidthDp()).setMaxAspectRatioInPortrait(this.getMaxAspectRatioInPortrait()).setMaxAspectRatioInLandscape(this.getMaxAspectRatioInLandscape()).setSticky(this.isSticky).setFinishPrimaryWithPlaceholder(this.finishPrimaryWithPlaceholder).setDefaultSplitAttributes(this.getDefaultSplitAttributes()).build();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitPlaceholderRule)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.placeholderIntent, (Object)((SplitPlaceholderRule)other).placeholderIntent)) {
            return false;
        }
        if (this.isSticky != ((SplitPlaceholderRule)other).isSticky) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.finishPrimaryWithPlaceholder, (Object)((SplitPlaceholderRule)other).finishPrimaryWithPlaceholder)) {
            return false;
        }
        return Intrinsics.areEqual(this.filters, ((SplitPlaceholderRule)other).filters);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.placeholderIntent.hashCode();
        result = 31 * result + Boolean.hashCode(this.isSticky);
        result = 31 * result + this.finishPrimaryWithPlaceholder.hashCode();
        result = 31 * result + ((Object)this.filters).hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SplitPlaceholderRule{tag=").append(this.getTag()).append(", defaultSplitAttributes=").append(this.getDefaultSplitAttributes()).append(", minWidthDp=").append(this.getMinWidthDp()).append(", minHeightDp=").append(this.getMinHeightDp()).append(", minSmallestWidthDp=").append(this.getMinSmallestWidthDp()).append(", maxAspectRatioInPortrait=").append(this.getMaxAspectRatioInPortrait()).append(", maxAspectRatioInLandscape=").append(this.getMaxAspectRatioInLandscape()).append(", placeholderIntent=").append(this.placeholderIntent).append(", isSticky=").append(this.isSticky).append(", finishPrimaryWithPlaceholder=").append(this.finishPrimaryWithPlaceholder).append(", filters=").append(this.filters).append('}');
        return stringBuilder.toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\u0012J\u0010\u0010 \u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0012J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\"\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/window/embedding/SplitPlaceholderRule$Builder;", "", "filters", "", "Landroidx/window/embedding/ActivityFilter;", "placeholderIntent", "Landroid/content/Intent;", "(Ljava/util/Set;Landroid/content/Intent;)V", "defaultSplitAttributes", "Landroidx/window/embedding/SplitAttributes;", "finishPrimaryWithPlaceholder", "Landroidx/window/embedding/SplitRule$FinishBehavior;", "isSticky", "", "maxAspectRatioInLandscape", "Landroidx/window/embedding/EmbeddingAspectRatio;", "maxAspectRatioInPortrait", "minHeightDp", "", "minSmallestWidthDp", "minWidthDp", "tag", "", "build", "Landroidx/window/embedding/SplitPlaceholderRule;", "setDefaultSplitAttributes", "setFinishPrimaryWithPlaceholder", "setMaxAspectRatioInLandscape", "aspectRatio", "setMaxAspectRatioInPortrait", "setMinHeightDp", "setMinSmallestWidthDp", "setMinWidthDp", "setSticky", "setTag", "window_release"})
    @SourceDebugExtension(value={"SMAP\nSplitPlaceholderRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitPlaceholderRule.kt\nandroidx/window/embedding/SplitPlaceholderRule$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Set<ActivityFilter> filters;
        @NotNull
        private final Intent placeholderIntent;
        @Nullable
        private String tag;
        @IntRange(from=0L)
        private int minWidthDp;
        @IntRange(from=0L)
        private int minHeightDp;
        @IntRange(from=0L)
        private int minSmallestWidthDp;
        @NotNull
        private EmbeddingAspectRatio maxAspectRatioInPortrait;
        @NotNull
        private EmbeddingAspectRatio maxAspectRatioInLandscape;
        @NotNull
        private SplitRule.FinishBehavior finishPrimaryWithPlaceholder;
        private boolean isSticky;
        @NotNull
        private SplitAttributes defaultSplitAttributes;

        public Builder(@NotNull Set<ActivityFilter> filters, @NotNull Intent placeholderIntent) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)placeholderIntent, (String)"placeholderIntent");
            this.filters = filters;
            this.placeholderIntent = placeholderIntent;
            this.minWidthDp = 600;
            this.minHeightDp = 600;
            this.minSmallestWidthDp = 600;
            this.maxAspectRatioInPortrait = SplitRule.SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT;
            this.maxAspectRatioInLandscape = SplitRule.SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT;
            this.finishPrimaryWithPlaceholder = SplitRule.FinishBehavior.ALWAYS;
            this.defaultSplitAttributes = new SplitAttributes.Builder().build();
        }

        @NotNull
        public final Builder setMinWidthDp(@IntRange(from=0L) int minWidthDp) {
            Builder builder;
            Builder $this$setMinWidthDp_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setMinWidthDp_u24lambda_u240.minWidthDp = minWidthDp;
            return builder;
        }

        @NotNull
        public final Builder setMinHeightDp(@IntRange(from=0L) int minHeightDp) {
            Builder builder;
            Builder $this$setMinHeightDp_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setMinHeightDp_u24lambda_u241.minHeightDp = minHeightDp;
            return builder;
        }

        @NotNull
        public final Builder setMinSmallestWidthDp(@IntRange(from=0L) int minSmallestWidthDp) {
            Builder builder;
            Builder $this$setMinSmallestWidthDp_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setMinSmallestWidthDp_u24lambda_u242.minSmallestWidthDp = minSmallestWidthDp;
            return builder;
        }

        @NotNull
        public final Builder setMaxAspectRatioInPortrait(@NotNull EmbeddingAspectRatio aspectRatio) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
            Builder $this$setMaxAspectRatioInPortrait_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setMaxAspectRatioInPortrait_u24lambda_u243.maxAspectRatioInPortrait = aspectRatio;
            return builder;
        }

        @NotNull
        public final Builder setMaxAspectRatioInLandscape(@NotNull EmbeddingAspectRatio aspectRatio) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
            Builder $this$setMaxAspectRatioInLandscape_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setMaxAspectRatioInLandscape_u24lambda_u244.maxAspectRatioInLandscape = aspectRatio;
            return builder;
        }

        @NotNull
        public final Builder setFinishPrimaryWithPlaceholder(@NotNull SplitRule.FinishBehavior finishPrimaryWithPlaceholder) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)finishPrimaryWithPlaceholder, (String)"finishPrimaryWithPlaceholder");
            Builder $this$setFinishPrimaryWithPlaceholder_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$setFinishPrimaryWithPlaceholder_u24lambda_u245.finishPrimaryWithPlaceholder = finishPrimaryWithPlaceholder;
            return builder;
        }

        @NotNull
        public final Builder setSticky(boolean isSticky) {
            Builder builder;
            Builder $this$setSticky_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$setSticky_u24lambda_u246.isSticky = isSticky;
            return builder;
        }

        @NotNull
        public final Builder setDefaultSplitAttributes(@NotNull SplitAttributes defaultSplitAttributes) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)defaultSplitAttributes, (String)"defaultSplitAttributes");
            Builder $this$setDefaultSplitAttributes_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$setDefaultSplitAttributes_u24lambda_u247.defaultSplitAttributes = defaultSplitAttributes;
            return builder;
        }

        @NotNull
        public final Builder setTag(@Nullable String tag) {
            Builder builder;
            Builder $this$setTag_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$setTag_u24lambda_u248.tag = tag;
            return builder;
        }

        @NotNull
        public final SplitPlaceholderRule build() {
            return new SplitPlaceholderRule(this.tag, this.filters, this.placeholderIntent, this.isSticky, this.finishPrimaryWithPlaceholder, this.minWidthDp, this.minHeightDp, this.minSmallestWidthDp, this.maxAspectRatioInPortrait, this.maxAspectRatioInLandscape, this.defaultSplitAttributes);
        }
    }
}

