/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.WindowMetrics;
import androidx.annotation.DoNotInline;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import androidx.window.embedding.EmbeddingAspectRatio;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitAttributes;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0016\u0018\u0000 -2\u00020\u0001:\u0004+,-.BM\b\u0000\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u001a\u0010$\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010%\u001a\u00020\u0005H\u0002J\u0013\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0005H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006/"}, d2={"Landroidx/window/embedding/SplitRule;", "Landroidx/window/embedding/EmbeddingRule;", "tag", "", "minWidthDp", "", "minHeightDp", "minSmallestWidthDp", "maxAspectRatioInPortrait", "Landroidx/window/embedding/EmbeddingAspectRatio;", "maxAspectRatioInLandscape", "defaultSplitAttributes", "Landroidx/window/embedding/SplitAttributes;", "(Ljava/lang/String;IIILandroidx/window/embedding/EmbeddingAspectRatio;Landroidx/window/embedding/EmbeddingAspectRatio;Landroidx/window/embedding/SplitAttributes;)V", "getDefaultSplitAttributes", "()Landroidx/window/embedding/SplitAttributes;", "getMaxAspectRatioInLandscape", "()Landroidx/window/embedding/EmbeddingAspectRatio;", "getMaxAspectRatioInPortrait", "getMinHeightDp", "()I", "getMinSmallestWidthDp", "getMinWidthDp", "checkParentBounds", "", "density", "", "bounds", "Landroid/graphics/Rect;", "checkParentBounds$window_release", "checkParentMetrics", "context", "Landroid/content/Context;", "parentMetrics", "Landroid/view/WindowMetrics;", "checkParentMetrics$window_release", "convertDpToPx", "dimensionDp", "equals", "other", "", "hashCode", "toString", "Api30Impl", "Api34Impl", "Companion", "FinishBehavior", "window_release"})
public class SplitRule
extends EmbeddingRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minWidthDp;
    private final int minHeightDp;
    private final int minSmallestWidthDp;
    @NotNull
    private final EmbeddingAspectRatio maxAspectRatioInPortrait;
    @NotNull
    private final EmbeddingAspectRatio maxAspectRatioInLandscape;
    @NotNull
    private final SplitAttributes defaultSplitAttributes;
    public static final int SPLIT_MIN_DIMENSION_ALWAYS_ALLOW = 0;
    public static final int SPLIT_MIN_DIMENSION_DP_DEFAULT = 600;
    @JvmField
    @NotNull
    public static final EmbeddingAspectRatio SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT = EmbeddingAspectRatio.Companion.ratio(1.4f);
    @JvmField
    @NotNull
    public static final EmbeddingAspectRatio SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT = EmbeddingAspectRatio.ALWAYS_ALLOW;

    public SplitRule(@Nullable String tag, @IntRange(from=0L) int minWidthDp, @IntRange(from=0L) int minHeightDp, @IntRange(from=0L) int minSmallestWidthDp, @NotNull EmbeddingAspectRatio maxAspectRatioInPortrait, @NotNull EmbeddingAspectRatio maxAspectRatioInLandscape, @NotNull SplitAttributes defaultSplitAttributes) {
        Intrinsics.checkNotNullParameter((Object)maxAspectRatioInPortrait, (String)"maxAspectRatioInPortrait");
        Intrinsics.checkNotNullParameter((Object)maxAspectRatioInLandscape, (String)"maxAspectRatioInLandscape");
        Intrinsics.checkNotNullParameter((Object)defaultSplitAttributes, (String)"defaultSplitAttributes");
        super(tag);
        this.minWidthDp = minWidthDp;
        this.minHeightDp = minHeightDp;
        this.minSmallestWidthDp = minSmallestWidthDp;
        this.maxAspectRatioInPortrait = maxAspectRatioInPortrait;
        this.maxAspectRatioInLandscape = maxAspectRatioInLandscape;
        this.defaultSplitAttributes = defaultSplitAttributes;
        Preconditions.checkArgumentNonnegative((int)this.minWidthDp, (String)"minWidthDp must be non-negative");
        Preconditions.checkArgumentNonnegative((int)this.minHeightDp, (String)"minHeightDp must be non-negative");
        Preconditions.checkArgumentNonnegative((int)this.minSmallestWidthDp, (String)"minSmallestWidthDp must be non-negative");
    }

    public /* synthetic */ SplitRule(String string, int n, int n2, int n3, EmbeddingAspectRatio embeddingAspectRatio, EmbeddingAspectRatio embeddingAspectRatio2, SplitAttributes splitAttributes, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = null;
        }
        if ((n4 & 2) != 0) {
            n = 600;
        }
        if ((n4 & 4) != 0) {
            n2 = 600;
        }
        if ((n4 & 8) != 0) {
            n3 = 600;
        }
        if ((n4 & 0x10) != 0) {
            embeddingAspectRatio = SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT;
        }
        if ((n4 & 0x20) != 0) {
            embeddingAspectRatio2 = SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT;
        }
        this(string, n, n2, n3, embeddingAspectRatio, embeddingAspectRatio2, splitAttributes);
    }

    public final int getMinWidthDp() {
        return this.minWidthDp;
    }

    public final int getMinHeightDp() {
        return this.minHeightDp;
    }

    public final int getMinSmallestWidthDp() {
        return this.minSmallestWidthDp;
    }

    @NotNull
    public final EmbeddingAspectRatio getMaxAspectRatioInPortrait() {
        return this.maxAspectRatioInPortrait;
    }

    @NotNull
    public final EmbeddingAspectRatio getMaxAspectRatioInLandscape() {
        return this.maxAspectRatioInLandscape;
    }

    @NotNull
    public final SplitAttributes getDefaultSplitAttributes() {
        return this.defaultSplitAttributes;
    }

    public final boolean checkParentMetrics$window_release(@NotNull Context context, @NotNull WindowMetrics parentMetrics) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parentMetrics, (String)"parentMetrics");
        if (Build.VERSION.SDK_INT <= 30) {
            return false;
        }
        Rect bounds = Api30Impl.INSTANCE.getBounds(parentMetrics);
        float density = Build.VERSION.SDK_INT <= 33 ? context.getResources().getDisplayMetrics().density : Api34Impl.INSTANCE.getDensity(parentMetrics, context);
        return this.checkParentBounds$window_release(density, bounds);
    }

    public final boolean checkParentBounds$window_release(float density, @NotNull Rect bounds) {
        boolean validSmallestMinWidth;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        int width = bounds.width();
        int height = bounds.height();
        if (width == 0 || height == 0) {
            return false;
        }
        int minWidthPx = this.convertDpToPx(density, this.minWidthDp);
        int minHeightPx = this.convertDpToPx(density, this.minHeightDp);
        int minSmallestWidthPx = this.convertDpToPx(density, this.minSmallestWidthDp);
        boolean validMinWidth = this.minWidthDp == 0 || width >= minWidthPx;
        boolean validMinHeight = this.minHeightDp == 0 || height >= minHeightPx;
        boolean bl = validSmallestMinWidth = this.minSmallestWidthDp == 0 || Math.min(width, height) >= minSmallestWidthPx;
        boolean validAspectRatio = height >= width ? Intrinsics.areEqual((Object)this.maxAspectRatioInPortrait, (Object)EmbeddingAspectRatio.ALWAYS_ALLOW) || (float)height * 1.0f / (float)width <= this.maxAspectRatioInPortrait.getValue$window_release() : Intrinsics.areEqual((Object)this.maxAspectRatioInLandscape, (Object)EmbeddingAspectRatio.ALWAYS_ALLOW) || (float)width * 1.0f / (float)height <= this.maxAspectRatioInLandscape.getValue$window_release();
        return validMinWidth && validMinHeight && validSmallestMinWidth && validAspectRatio;
    }

    private final int convertDpToPx(float density, @IntRange(from=0L) int dimensionDp) {
        return (int)((float)dimensionDp * density + 0.5f);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitRule)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.minWidthDp != ((SplitRule)other).minWidthDp) {
            return false;
        }
        if (this.minHeightDp != ((SplitRule)other).minHeightDp) {
            return false;
        }
        if (this.minSmallestWidthDp != ((SplitRule)other).minSmallestWidthDp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxAspectRatioInPortrait, (Object)((SplitRule)other).maxAspectRatioInPortrait)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxAspectRatioInLandscape, (Object)((SplitRule)other).maxAspectRatioInLandscape)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultSplitAttributes, (Object)((SplitRule)other).defaultSplitAttributes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minWidthDp;
        result = 31 * result + this.minHeightDp;
        result = 31 * result + this.minSmallestWidthDp;
        result = 31 * result + this.maxAspectRatioInPortrait.hashCode();
        result = 31 * result + this.maxAspectRatioInLandscape.hashCode();
        result = 31 * result + this.defaultSplitAttributes.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return SplitRule.class.getSimpleName() + "{ tag=" + this.getTag() + ", defaultSplitAttributes=" + this.defaultSplitAttributes + ", minWidthDp=" + this.minWidthDp + ", minHeightDp=" + this.minHeightDp + ", minSmallestWidthDp=" + this.minSmallestWidthDp + ", maxAspectRatioInPortrait=" + this.maxAspectRatioInPortrait + ", maxAspectRatioInLandscape=" + this.maxAspectRatioInLandscape + '}';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/window/embedding/SplitRule$Api30Impl;", "", "()V", "getBounds", "Landroid/graphics/Rect;", "windowMetrics", "Landroid/view/WindowMetrics;", "window_release"})
    @RequiresApi(value=30)
    public static final class Api30Impl {
        @NotNull
        public static final Api30Impl INSTANCE = new Api30Impl();

        private Api30Impl() {
        }

        @DoNotInline
        @NotNull
        public final Rect getBounds(@NotNull WindowMetrics windowMetrics) {
            Intrinsics.checkNotNullParameter((Object)windowMetrics, (String)"windowMetrics");
            Rect rect = windowMetrics.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"windowMetrics.bounds");
            return rect;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Landroidx/window/embedding/SplitRule$Api34Impl;", "", "()V", "getDensity", "", "windowMetrics", "Landroid/view/WindowMetrics;", "context", "Landroid/content/Context;", "window_release"})
    @RequiresApi(value=34)
    public static final class Api34Impl {
        @NotNull
        public static final Api34Impl INSTANCE = new Api34Impl();

        private Api34Impl() {
        }

        @DoNotInline
        public final float getDensity(@NotNull WindowMetrics windowMetrics, @NotNull Context context) {
            float f;
            Intrinsics.checkNotNullParameter((Object)windowMetrics, (String)"windowMetrics");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                f = windowMetrics.getDensity();
            }
            catch (NoSuchMethodError e) {
                f = context.getResources().getDisplayMetrics().density;
            }
            return f;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/window/embedding/SplitRule$Companion;", "", "()V", "SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT", "Landroidx/window/embedding/EmbeddingAspectRatio;", "SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT", "SPLIT_MIN_DIMENSION_ALWAYS_ALLOW", "", "SPLIT_MIN_DIMENSION_DP_DEFAULT", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Landroidx/window/embedding/SplitRule$FinishBehavior;", "", "description", "", "value", "", "(Ljava/lang/String;I)V", "getValue$window_release", "()I", "toString", "Companion", "window_release"})
    public static final class FinishBehavior {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String description;
        private final int value;
        @JvmField
        @NotNull
        public static final FinishBehavior NEVER = new FinishBehavior("NEVER", 0);
        @JvmField
        @NotNull
        public static final FinishBehavior ALWAYS = new FinishBehavior("ALWAYS", 1);
        @JvmField
        @NotNull
        public static final FinishBehavior ADJACENT = new FinishBehavior("ADJACENT", 2);

        private FinishBehavior(String description, int value) {
            this.description = description;
            this.value = value;
        }

        public final int getValue$window_release() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.description;
        }

        @JvmStatic
        @NotNull
        public static final FinishBehavior getFinishBehaviorFromValue$window_release(@IntRange(from=0L, to=2L) int value) {
            return Companion.getFinishBehaviorFromValue$window_release(value);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/window/embedding/SplitRule$FinishBehavior$Companion;", "", "()V", "ADJACENT", "Landroidx/window/embedding/SplitRule$FinishBehavior;", "ALWAYS", "NEVER", "getFinishBehaviorFromValue", "value", "", "getFinishBehaviorFromValue$window_release", "window_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final FinishBehavior getFinishBehaviorFromValue$window_release(@IntRange(from=0L, to=2L) int value) {
                FinishBehavior finishBehavior;
                int n = value;
                if (n == NEVER.getValue$window_release()) {
                    finishBehavior = NEVER;
                } else if (n == ALWAYS.getValue$window_release()) {
                    finishBehavior = ALWAYS;
                } else if (n == ADJACENT.getValue$window_release()) {
                    finishBehavior = ADJACENT;
                } else {
                    throw new IllegalArgumentException("Unknown finish behavior:" + value);
                }
                return finishBehavior;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

