/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.WindowInsets;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.WindowInsetsCompat;
import androidx.window.core.Bounds;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import androidx.window.layout.WindowMetricsCalculatorCompat;
import androidx.window.layout.WindowMetricsCalculatorDecorator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Landroidx/window/layout/WindowMetricsCalculator;", "", "computeCurrentWindowMetrics", "Landroidx/window/layout/WindowMetrics;", "activity", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "computeMaximumWindowMetrics", "Companion", "window_release"})
public interface WindowMetricsCalculator {
    @NotNull
    public static final Companion Companion = androidx.window.layout.WindowMetricsCalculator$Companion.$$INSTANCE;

    @NotNull
    public WindowMetrics computeCurrentWindowMetrics(@NotNull Activity var1);

    @NotNull
    default public WindowMetrics computeCurrentWindowMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new NotImplementedError("Must override computeCurrentWindowMetrics(context) and provide an implementation.");
    }

    @NotNull
    public WindowMetrics computeMaximumWindowMetrics(@NotNull Activity var1);

    @NotNull
    default public WindowMetrics computeMaximumWindowMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new NotImplementedError("Must override computeMaximumWindowMetrics(context) and provide an implementation.");
    }

    @JvmStatic
    @NotNull
    public static WindowMetricsCalculator getOrCreate() {
        return Companion.getOrCreate();
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void overrideDecorator(@NotNull WindowMetricsCalculatorDecorator overridingDecorator) {
        Companion.overrideDecorator(overridingDecorator);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void reset() {
        Companion.reset();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\b\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0007J\u0015\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/window/layout/WindowMetricsCalculator$Companion;", "", "()V", "decorator", "Lkotlin/Function1;", "Landroidx/window/layout/WindowMetricsCalculator;", "fromDisplayMetrics", "Landroidx/window/layout/WindowMetrics;", "displayMetrics", "Landroid/util/DisplayMetrics;", "fromDisplayMetrics$window_release", "getOrCreate", "overrideDecorator", "", "overridingDecorator", "Landroidx/window/layout/WindowMetricsCalculatorDecorator;", "reset", "translateWindowMetrics", "windowMetrics", "Landroid/view/WindowMetrics;", "translateWindowMetrics$window_release", "window_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static Function1<? super WindowMetricsCalculator, ? extends WindowMetricsCalculator> decorator;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WindowMetricsCalculator getOrCreate() {
            return (WindowMetricsCalculator)decorator.invoke((Object)WindowMetricsCalculatorCompat.INSTANCE);
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void overrideDecorator(@NotNull WindowMetricsCalculatorDecorator overridingDecorator) {
            Intrinsics.checkNotNullParameter((Object)overridingDecorator, (String)"overridingDecorator");
            decorator = (Function1)new Function1<WindowMetricsCalculator, WindowMetricsCalculator>((Object)overridingDecorator){

                @NotNull
                public final WindowMetricsCalculator invoke(@NotNull WindowMetricsCalculator p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((WindowMetricsCalculatorDecorator)this.receiver).decorate(p0);
                }
            };
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void reset() {
            decorator = reset.1.INSTANCE;
        }

        @RequiresApi(value=30)
        @NotNull
        public final WindowMetrics translateWindowMetrics$window_release(@NotNull android.view.WindowMetrics windowMetrics) {
            Intrinsics.checkNotNullParameter((Object)windowMetrics, (String)"windowMetrics");
            Rect rect = windowMetrics.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"windowMetrics.bounds");
            WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)windowMetrics.getWindowInsets());
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(windowMetrics.windowInsets)");
            return new WindowMetrics(rect, windowInsetsCompat);
        }

        @NotNull
        public final WindowMetrics fromDisplayMetrics$window_release(@NotNull DisplayMetrics displayMetrics) {
            Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
            Bounds bounds = new Bounds(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels);
            WindowInsetsCompat windowInsetsCompat = new WindowInsetsCompat.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"Builder().build()");
            return new WindowMetrics(bounds, windowInsetsCompat);
        }

        static {
            $$INSTANCE = new Companion();
            decorator = decorator.1.INSTANCE;
        }
    }
}

