/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.result;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.MainThread;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.os.BundleCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 72\u00020\u0001:\u0003678B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J#\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u0002H\u0017H\u0007\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J8\u0010\u001e\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u0006H\u0002J\b\u0010 \u001a\u00020\nH\u0002JG\u0010!\u001a\u00020\u0012\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H\u00170$2\u0006\u0010%\u001a\u0002H\"2\b\u0010&\u001a\u0004\u0018\u00010'H'\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00122\b\u0010*\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u000fJB\u0010-\u001a\b\u0012\u0004\u0012\u0002H\"0.\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010\u00172\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H\u00170$2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001700JJ\u0010-\u001a\b\u0012\u0004\u0012\u0002H\"0.\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010\u00172\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u00101\u001a\u0002022\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H\u00170$2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001700J\u0010\u00103\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0015\u00104\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b5R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/activity/result/ActivityResultRegistry;", "", "()V", "keyToCallback", "", "", "Landroidx/activity/result/ActivityResultRegistry$CallbackAndContract;", "keyToLifecycleContainers", "Landroidx/activity/result/ActivityResultRegistry$LifecycleContainer;", "keyToRc", "", "launchedKeys", "", "parsedPendingResults", "pendingResults", "Landroid/os/Bundle;", "rcToKey", "bindRcKey", "", "rc", "key", "dispatchResult", "", "O", "requestCode", "result", "(ILjava/lang/Object;)Z", "resultCode", "data", "Landroid/content/Intent;", "doDispatch", "callbackAndContract", "generateRandomNumber", "onLaunch", "I", "contract", "Landroidx/activity/result/contract/ActivityResultContract;", "input", "options", "Landroidx/core/app/ActivityOptionsCompat;", "(ILandroidx/activity/result/contract/ActivityResultContract;Ljava/lang/Object;Landroidx/core/app/ActivityOptionsCompat;)V", "onRestoreInstanceState", "savedInstanceState", "onSaveInstanceState", "outState", "register", "Landroidx/activity/result/ActivityResultLauncher;", "callback", "Landroidx/activity/result/ActivityResultCallback;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "registerKey", "unregister", "unregister$activity_release", "CallbackAndContract", "Companion", "LifecycleContainer", "activity_release"})
@SourceDebugExtension(value={"SMAP\nActivityResultRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityResultRegistry.kt\nandroidx/activity/result/ActivityResultRegistry\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,447:1\n123#2,2:448\n*S KotlinDebug\n*F\n+ 1 ActivityResultRegistry.kt\nandroidx/activity/result/ActivityResultRegistry\n*L\n401#1:448,2\n*E\n"})
public abstract class ActivityResultRegistry {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, String> rcToKey = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> keyToRc = new LinkedHashMap();
    @NotNull
    private final Map<String, LifecycleContainer> keyToLifecycleContainers = new LinkedHashMap();
    @NotNull
    private final List<String> launchedKeys = new ArrayList();
    @NotNull
    private final transient Map<String, CallbackAndContract<?>> keyToCallback = new LinkedHashMap();
    @NotNull
    private final Map<String, Object> parsedPendingResults = new LinkedHashMap();
    @NotNull
    private final Bundle pendingResults = new Bundle();
    @NotNull
    private static final String KEY_COMPONENT_ACTIVITY_REGISTERED_RCS = "KEY_COMPONENT_ACTIVITY_REGISTERED_RCS";
    @NotNull
    private static final String KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS = "KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS";
    @NotNull
    private static final String KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS = "KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS";
    @NotNull
    private static final String KEY_COMPONENT_ACTIVITY_PENDING_RESULTS = "KEY_COMPONENT_ACTIVITY_PENDING_RESULT";
    @NotNull
    private static final String LOG_TAG = "ActivityResultRegistry";
    private static final int INITIAL_REQUEST_CODE_VALUE = 65536;

    @MainThread
    public abstract <I, O> void onLaunch(int var1, @NotNull ActivityResultContract<I, O> var2, I var3, @Nullable ActivityOptionsCompat var4);

    @NotNull
    public final <I, O> ActivityResultLauncher<I> register(@NotNull String key, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultContract<I, O> contract, @NotNull ActivityResultCallback<O> callback2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter(contract, (String)"contract");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        if (!(!lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED))) {
            boolean $i$a$-check-ActivityResultRegistry$register$22 = false;
            String $i$a$-check-ActivityResultRegistry$register$22 = "LifecycleOwner " + lifecycleOwner + " is attempting to register while current state is " + lifecycle.getCurrentState() + ". LifecycleOwners must call register before they are STARTED.";
            throw new IllegalStateException($i$a$-check-ActivityResultRegistry$register$22.toString());
        }
        this.registerKey(key);
        LifecycleContainer lifecycleContainer = this.keyToLifecycleContainers.get(key);
        if (lifecycleContainer == null) {
            lifecycleContainer = new LifecycleContainer(lifecycle);
        }
        LifecycleContainer lifecycleContainer2 = lifecycleContainer;
        LifecycleEventObserver observer = (arg_0, arg_1) -> ActivityResultRegistry.register$lambda$1(this, key, callback2, contract, arg_0, arg_1);
        lifecycleContainer2.addObserver(observer);
        this.keyToLifecycleContainers.put(key, lifecycleContainer2);
        return new ActivityResultLauncher<I>(this, key, contract){
            final /* synthetic */ ActivityResultRegistry this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ ActivityResultContract<I, O> $contract;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$contract = $contract;
            }

            public void launch(I input, @Nullable ActivityOptionsCompat options) {
                V v = ActivityResultRegistry.access$getKeyToRc$p(this.this$0).get(this.$key);
                ActivityResultContract<I, O> activityResultContract = this.$contract;
                V v2 = v;
                if (v2 == null) {
                    boolean bl = false;
                    String string = "Attempting to launch an unregistered ActivityResultLauncher with contract " + activityResultContract + " and input " + input + ". You must ensure the ActivityResultLauncher is registered before calling launch().";
                    throw new IllegalStateException(string.toString());
                }
                int innerCode = ((Number)v2).intValue();
                ActivityResultRegistry.access$getLaunchedKeys$p(this.this$0).add(this.$key);
                try {
                    this.this$0.onLaunch(innerCode, this.$contract, input, options);
                }
                catch (Exception e) {
                    ActivityResultRegistry.access$getLaunchedKeys$p(this.this$0).remove(this.$key);
                    throw e;
                }
            }

            public void unregister() {
                this.this$0.unregister$activity_release(this.$key);
            }

            @NotNull
            public ActivityResultContract<I, ?> getContract() {
                return this.$contract;
            }
        };
    }

    @NotNull
    public final <I, O> ActivityResultLauncher<I> register(@NotNull String key, @NotNull ActivityResultContract<I, O> contract, @NotNull ActivityResultCallback<O> callback2) {
        ActivityResult pendingResult;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(contract, (String)"contract");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.registerKey(key);
        this.keyToCallback.put(key, new CallbackAndContract<O>(callback2, contract));
        if (this.parsedPendingResults.containsKey(key)) {
            Object parsedPendingResult = this.parsedPendingResults.get(key);
            this.parsedPendingResults.remove(key);
            callback2.onActivityResult(parsedPendingResult);
        }
        if ((pendingResult = (ActivityResult)BundleCompat.getParcelable((Bundle)this.pendingResults, (String)key, ActivityResult.class)) != null) {
            this.pendingResults.remove(key);
            callback2.onActivityResult(contract.parseResult(pendingResult.getResultCode(), pendingResult.getData()));
        }
        return new ActivityResultLauncher<I>(this, key, contract){
            final /* synthetic */ ActivityResultRegistry this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ ActivityResultContract<I, O> $contract;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$contract = $contract;
            }

            public void launch(I input, @Nullable ActivityOptionsCompat options) {
                V v = ActivityResultRegistry.access$getKeyToRc$p(this.this$0).get(this.$key);
                ActivityResultContract<I, O> activityResultContract = this.$contract;
                V v2 = v;
                if (v2 == null) {
                    boolean bl = false;
                    String string = "Attempting to launch an unregistered ActivityResultLauncher with contract " + activityResultContract + " and input " + input + ". You must ensure the ActivityResultLauncher is registered before calling launch().";
                    throw new IllegalStateException(string.toString());
                }
                int innerCode = ((Number)v2).intValue();
                ActivityResultRegistry.access$getLaunchedKeys$p(this.this$0).add(this.$key);
                try {
                    this.this$0.onLaunch(innerCode, this.$contract, input, options);
                }
                catch (Exception e) {
                    ActivityResultRegistry.access$getLaunchedKeys$p(this.this$0).remove(this.$key);
                    throw e;
                }
            }

            public void unregister() {
                this.this$0.unregister$activity_release(this.$key);
            }

            @NotNull
            public ActivityResultContract<I, ?> getContract() {
                return this.$contract;
            }
        };
    }

    @MainThread
    public final void unregister$activity_release(@NotNull String key) {
        LifecycleContainer lifecycleContainer;
        Integer rc;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.launchedKeys.contains(key) && (rc = this.keyToRc.remove(key)) != null) {
            this.rcToKey.remove(rc);
        }
        this.keyToCallback.remove(key);
        if (this.parsedPendingResults.containsKey(key)) {
            Log.w((String)LOG_TAG, (String)("Dropping pending result for request " + key + ": " + this.parsedPendingResults.get(key)));
            this.parsedPendingResults.remove(key);
        }
        if (this.pendingResults.containsKey(key)) {
            ActivityResult pendingResult = (ActivityResult)BundleCompat.getParcelable((Bundle)this.pendingResults, (String)key, ActivityResult.class);
            Log.w((String)LOG_TAG, (String)("Dropping pending result for request " + key + ": " + pendingResult));
            this.pendingResults.remove(key);
        }
        if ((lifecycleContainer = this.keyToLifecycleContainers.get(key)) != null) {
            lifecycleContainer.clearObservers();
            this.keyToLifecycleContainers.remove(key);
        }
    }

    public final void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putIntegerArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_RCS, new ArrayList<Integer>(this.keyToRc.values()));
        outState.putStringArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS, new ArrayList(this.keyToRc.keySet()));
        outState.putStringArrayList(KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS, new ArrayList(this.launchedKeys));
        outState.putBundle(KEY_COMPONENT_ACTIVITY_PENDING_RESULTS, new Bundle(this.pendingResults));
    }

    public final void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Bundle restoredPendingResults;
        if (savedInstanceState == null) {
            return;
        }
        ArrayList rcs = savedInstanceState.getIntegerArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_RCS);
        ArrayList keys = savedInstanceState.getStringArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS);
        if (keys == null || rcs == null) {
            return;
        }
        ArrayList restoredLaunchedKeys = savedInstanceState.getStringArrayList(KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS);
        if (restoredLaunchedKeys != null) {
            this.launchedKeys.addAll(restoredLaunchedKeys);
        }
        if ((restoredPendingResults = savedInstanceState.getBundle(KEY_COMPONENT_ACTIVITY_PENDING_RESULTS)) != null) {
            this.pendingResults.putAll(restoredPendingResults);
        }
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            String key = (String)keys.get(i);
            if (this.keyToRc.containsKey(key)) {
                Integer newRequestCode = this.keyToRc.remove(key);
                if (!this.pendingResults.containsKey(key)) {
                    TypeIntrinsics.asMutableMap(this.rcToKey).remove(newRequestCode);
                }
            }
            Object e = rcs.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"rcs[i]");
            int n2 = ((Number)e).intValue();
            Object e2 = keys.get(i);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"keys[i]");
            this.bindRcKey(n2, (String)e2);
        }
    }

    @MainThread
    public final boolean dispatchResult(int requestCode, int resultCode, @Nullable Intent data) {
        String string = this.rcToKey.get(requestCode);
        if (string == null) {
            return false;
        }
        String key = string;
        this.doDispatch(key, resultCode, data, this.keyToCallback.get(key));
        return true;
    }

    @MainThread
    public final <O> boolean dispatchResult(int requestCode, O result) {
        CallbackAndContract<?> callbackAndContract;
        String string = this.rcToKey.get(requestCode);
        if (string == null) {
            return false;
        }
        String key = string;
        CallbackAndContract<?> callbackAndContract2 = callbackAndContract = this.keyToCallback.get(key);
        if ((callbackAndContract2 != null ? callbackAndContract2.getCallback() : null) == null) {
            this.pendingResults.remove(key);
            this.parsedPendingResults.put(key, result);
        } else {
            ActivityResultCallback<?> activityResultCallback = callbackAndContract.getCallback();
            Intrinsics.checkNotNull(activityResultCallback, (String)"null cannot be cast to non-null type androidx.activity.result.ActivityResultCallback<O of androidx.activity.result.ActivityResultRegistry.dispatchResult>");
            ActivityResultCallback<?> callback2 = activityResultCallback;
            if (this.launchedKeys.remove(key)) {
                callback2.onActivityResult(result);
            }
        }
        return true;
    }

    private final <O> void doDispatch(String key, int resultCode, Intent data, CallbackAndContract<O> callbackAndContract) {
        CallbackAndContract<O> callbackAndContract2 = callbackAndContract;
        if ((callbackAndContract2 != null ? callbackAndContract2.getCallback() : null) != null && this.launchedKeys.contains(key)) {
            ActivityResultCallback<O> callback2 = callbackAndContract.getCallback();
            ActivityResultContract<?, O> contract = callbackAndContract.getContract();
            callback2.onActivityResult(contract.parseResult(resultCode, data));
            this.launchedKeys.remove(key);
        } else {
            this.parsedPendingResults.remove(key);
            this.pendingResults.putParcelable(key, (Parcelable)new ActivityResult(resultCode, data));
        }
    }

    private final void registerKey(String key) {
        Integer existing = this.keyToRc.get(key);
        if (existing != null) {
            return;
        }
        int rc = this.generateRandomNumber();
        this.bindRcKey(rc, key);
    }

    private final int generateRandomNumber() {
        Object element$iv2;
        block1: {
            Sequence $this$first$iv = SequencesKt.generateSequence((Function0)generateRandomNumber.1.INSTANCE);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                int number = ((Number)element$iv2).intValue();
                boolean bl = false;
                if (!(!this.rcToKey.containsKey(number))) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return ((Number)element$iv2).intValue();
    }

    private final void bindRcKey(int rc, String key) {
        Integer n = rc;
        this.rcToKey.put(n, key);
        n = rc;
        this.keyToRc.put(key, n);
    }

    private static final void register$lambda$1(ActivityResultRegistry this$0, String $key, ActivityResultCallback $callback, ActivityResultContract $contract, LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$contract, (String)"$contract");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Lifecycle.Event.ON_START == event) {
            ActivityResult pendingResult;
            this$0.keyToCallback.put($key, new CallbackAndContract($callback, $contract));
            if (this$0.parsedPendingResults.containsKey($key)) {
                Object parsedPendingResult = this$0.parsedPendingResults.get($key);
                this$0.parsedPendingResults.remove($key);
                $callback.onActivityResult(parsedPendingResult);
            }
            if ((pendingResult = (ActivityResult)BundleCompat.getParcelable((Bundle)this$0.pendingResults, (String)$key, ActivityResult.class)) != null) {
                this$0.pendingResults.remove($key);
                $callback.onActivityResult($contract.parseResult(pendingResult.getResultCode(), pendingResult.getData()));
            }
        } else if (Lifecycle.Event.ON_STOP == event) {
            this$0.keyToCallback.remove($key);
        } else if (Lifecycle.Event.ON_DESTROY == event) {
            this$0.unregister$activity_release($key);
        }
    }

    public static final /* synthetic */ Map access$getKeyToRc$p(ActivityResultRegistry $this) {
        return $this.keyToRc;
    }

    public static final /* synthetic */ List access$getLaunchedKeys$p(ActivityResultRegistry $this) {
        return $this.launchedKeys;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/activity/result/ActivityResultRegistry$CallbackAndContract;", "O", "", "callback", "Landroidx/activity/result/ActivityResultCallback;", "contract", "Landroidx/activity/result/contract/ActivityResultContract;", "(Landroidx/activity/result/ActivityResultCallback;Landroidx/activity/result/contract/ActivityResultContract;)V", "getCallback", "()Landroidx/activity/result/ActivityResultCallback;", "getContract", "()Landroidx/activity/result/contract/ActivityResultContract;", "activity_release"})
    private static final class CallbackAndContract<O> {
        @NotNull
        private final ActivityResultCallback<O> callback;
        @NotNull
        private final ActivityResultContract<?, O> contract;

        public CallbackAndContract(@NotNull ActivityResultCallback<O> callback2, @NotNull ActivityResultContract<?, O> contract) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            Intrinsics.checkNotNullParameter(contract, (String)"contract");
            this.callback = callback2;
            this.contract = contract;
        }

        @NotNull
        public final ActivityResultCallback<O> getCallback() {
            return this.callback;
        }

        @NotNull
        public final ActivityResultContract<?, O> getContract() {
            return this.contract;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/activity/result/ActivityResultRegistry$Companion;", "", "()V", "INITIAL_REQUEST_CODE_VALUE", "", "KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS", "", "KEY_COMPONENT_ACTIVITY_PENDING_RESULTS", "KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS", "KEY_COMPONENT_ACTIVITY_REGISTERED_RCS", "LOG_TAG", "activity_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/activity/result/ActivityResultRegistry$LifecycleContainer;", "", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroidx/lifecycle/Lifecycle;)V", "getLifecycle", "()Landroidx/lifecycle/Lifecycle;", "observers", "", "Landroidx/lifecycle/LifecycleEventObserver;", "addObserver", "", "observer", "clearObservers", "activity_release"})
    @SourceDebugExtension(value={"SMAP\nActivityResultRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityResultRegistry.kt\nandroidx/activity/result/ActivityResultRegistry$LifecycleContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n1855#2,2:448\n*S KotlinDebug\n*F\n+ 1 ActivityResultRegistry.kt\nandroidx/activity/result/ActivityResultRegistry$LifecycleContainer\n*L\n425#1:448,2\n*E\n"})
    private static final class LifecycleContainer {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final List<LifecycleEventObserver> observers;

        public LifecycleContainer(@NotNull Lifecycle lifecycle) {
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            this.lifecycle = lifecycle;
            this.observers = new ArrayList();
        }

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public final void addObserver(@NotNull LifecycleEventObserver observer) {
            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
            this.lifecycle.addObserver((LifecycleObserver)observer);
            this.observers.add(observer);
        }

        public final void clearObservers() {
            Iterable $this$forEach$iv = this.observers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LifecycleEventObserver observer = (LifecycleEventObserver)element$iv;
                boolean bl = false;
                this.lifecycle.removeObserver((LifecycleObserver)observer);
            }
            this.observers.clear();
        }
    }
}

