﻿using proevi.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http.Json;
using System.Text;
using System.Threading.Tasks;

namespace proevi.Services
{
    internal class ProductService
    {
        private const string BASE_URL = "https://localhost:7115/ProductCategories/";

        private HttpClient _httpClient;
        protected HttpClient HttpClientInstance => _httpClient ??= new HttpClient();

        public async Task<List<ProductCategoryDTO>> Get()
        {

            return await HttpClientInstance.GetFromJsonAsync<List<ProductCategoryDTO>>(BASE_URL);
        }


        public async Task<ProductCategoryDTO> GetById(int Id)
        {

            var data = await HttpClientInstance.GetFromJsonAsync<ProductCategoryDTO>(BASE_URL + Id);

            return data;
        }

        public async Task<bool> Delete(int Id)
        {

            var response = await HttpClientInstance.DeleteAsync(BASE_URL + Id);

            return response.IsSuccessStatusCode;
        }

        public async Task<HttpResponseMessage> Add(ProductCategoryDTO data)
        {
            try
            {
                return await HttpClientInstance.PostAsJsonAsync(BASE_URL, data);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    
    }
}
